/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.servlet.upload;

import com.ejie.r01f.servlet.upload.MultipartParser;
import com.ejie.r01f.servlet.upload.Part;
import com.ejie.r01f.servlet.upload.PartInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletInputStream;

public class ParamPart
extends Part {
    private byte[] value;
    private String encoding;

    ParamPart(String name, String newValue) {
        super(name);
        this.value = newValue.getBytes();
    }

    ParamPart(String newName, ServletInputStream newIn, String newBoundary, String newEncoding) throws IOException {
        super(newName);
        int read;
        this.encoding = newEncoding;
        PartInputStream pis = new PartInputStream(newIn, newBoundary);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        byte[] buf = new byte[128];
        while ((read = pis.read(buf)) != -1) {
            baos.write(buf, 0, read);
        }
        pis.close();
        baos.close();
        this.value = baos.toByteArray();
    }

    public byte[] getValue() {
        return this.value;
    }

    public String getStringValue() throws UnsupportedEncodingException {
        if (this.encoding == null) {
            return this.getStringValue(MultipartParser.DEFAULT_ENCODING);
        }
        return this.getStringValue(this.encoding);
    }

    public String getStringValue(String theEncoding) throws UnsupportedEncodingException {
        return new String(this.value, theEncoding);
    }

    @Override
    public boolean isParam() {
        return true;
    }
}

