/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.servlet.filter.authorization;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.servlet.filter.authorization.R01FAuthCfg;
import com.ejie.r01f.servlet.filter.authorization.R01FAuthCtx;
import com.ejie.r01f.servlet.filter.authorization.R01FBaseAuthProvider;
import com.ejie.r01f.servlet.filter.authorization.R01FOrgNodeCtx;
import com.ejie.r01f.servlet.filter.authorization.R01FProfileCtx;
import com.ejie.r01f.servlet.filter.authorization.R01FResourceAuthorization;
import com.ejie.r01f.servlet.filter.authorization.R01FResourceCtx;
import com.ejie.r01f.servlet.filter.authorization.R01FTargetCfg;
import com.ejie.r01f.servlet.filter.authorization.R01FTargetCtx;
import com.ejie.r01f.servlet.filter.authorization.R01FUserCtx;
import com.ejie.r01f.xlnets.R01FXLNetsAutorizacion;
import com.ejie.r01f.xlnets.R01FXLNetsFuncion;
import com.ejie.r01f.xlnets.R01FXLNetsItemSeguridad;
import com.ejie.r01f.xlnets.R01FXLNetsSession;
import com.ejie.r01f.xlnets.R01FXLNetsTipoObjeto;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import n38c.exe.N38API;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class R01FXLNetsAuthProvider
extends R01FBaseAuthProvider {
    public R01FXLNetsAuthProvider() {
    }

    public R01FXLNetsAuthProvider(ServletRequest newReq) {
        super(newReq);
    }

    @Override
    public R01FAuthCtx getContext(R01FAuthCfg authCfg) {
        try {
            N38API miN38API = new N38API((HttpServletRequest)this.req);
            Document docItemSesion = miN38API.n38ItemSesion();
            R01FXLNetsSession session = new R01FXLNetsSession(docItemSesion.getDocumentElement());
            if (session.getUIDSession() != null) {
                HashMap<String, String> userAttrs = new HashMap<String, String>();
                userAttrs.put("DNI", session.getDNI());
                userAttrs.put("HomePage", session.getHomePage());
                userAttrs.put("idioma", session.getIdioma());
                userAttrs.put("IP", session.getIp());
                userAttrs.put("login", session.getLogin());
                userAttrs.put("persona", session.getPersona());
                userAttrs.put("puesto", session.getPuesto());
                userAttrs.put("loginApp", session.getLoginApp());
                R01FOrgNodeCtx entidad = new R01FOrgNodeCtx(session.getOrganizacion(), "EJIE", "EJIE", null);
                R01FOrgNodeCtx dpto = new R01FOrgNodeCtx(session.getGrupo(), "Proyectos", "Proyectos", entidad);
                R01FOrgNodeCtx grupo = new R01FOrgNodeCtx(session.getUnidad(), "DOMA", "DOMA", dpto);
                R01FUserCtx user = new R01FUserCtx(session.getUIDSession(), session.getPersona(), userAttrs, entidad);
                HashMap<String, String> authAttrs = new HashMap<String, String>();
                authAttrs.put("provider", "fileProvider");
                HashMap<String, R01FProfileCtx> profiles = null;
                String[] sessionProfiles = session.getPerfiles();
                if (sessionProfiles != null && sessionProfiles.length > 0) {
                    profiles = new HashMap<String, R01FProfileCtx>();
                    int i = 0;
                    while (i < sessionProfiles.length) {
                        profiles.put(sessionProfiles[i], new R01FProfileCtx(sessionProfiles[i], sessionProfiles[i], sessionProfiles[i]));
                        ++i;
                    }
                }
                return new R01FAuthCtx(false, user, authAttrs, new Date(), profiles);
            }
            return null;
        }
        catch (Exception ex) {
            R01FLog.to("r01f.auth").severe("Error desconocido!!: " + ex.getMessage());
            return null;
        }
    }

    @Override
    public void redirectToLogin(ServletResponse res, String returnURL) {
        try {
            ((HttpServletResponse)res).sendRedirect(returnURL);
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
            R01FLog.to("r01f.auth").warning("No se ha podido redirigir a la pagina de login");
        }
    }

    @Override
    public R01FTargetCtx authorize(R01FAuthCtx authCtx, R01FTargetCfg targetCfg) {
        if (targetCfg == null || targetCfg.resources == null || targetCfg.resources.size() == 0) {
            return null;
        }
        R01FTargetCfg.ResourceCfg currResCfg2 = null;
        R01FTargetCtx targetCtx = null;
        HashMap<String, R01FResourceCtx> authorizedResources = null;
        R01FResourceCtx resourceCtx = null;
        try {
            for (R01FTargetCfg.ResourceCfg currResCfg2 : targetCfg.resources.values()) {
                if (!authCtx.override) {
                    R01FXLNetsItemSeguridad itemSeg;
                    N38API miN38API = new N38API((HttpServletRequest)this.req);
                    Document doc = null;
                    if (currResCfg2.getType().equals("function")) {
                        doc = miN38API.n38ItemObtenerAutorizacion(currResCfg2.getOID());
                        R01FXLNetsFuncion func = new R01FXLNetsFuncion(doc.getDocumentElement());
                        itemSeg = func.getItemSeguridad();
                        resourceCtx = new R01FResourceCtx(itemSeg.getUID(), itemSeg.getDescripcion().es, itemSeg.getDescripcion().eu, itemSeg.getTipo(), itemSeg.getSubTipo(), this._obtainItemAuths(authCtx, itemSeg));
                        if (authorizedResources == null) {
                            authorizedResources = new HashMap();
                        }
                        authorizedResources.put(resourceCtx.getOID(), resourceCtx);
                    } else if (currResCfg2.getType().equals("object")) {
                        doc = miN38API.n38ItemSeguridad(currResCfg2.getOID());
                        R01FXLNetsTipoObjeto tipoObj = new R01FXLNetsTipoObjeto(doc.getDocumentElement());
                        itemSeg = tipoObj.getItemSeguridad();
                        resourceCtx = new R01FResourceCtx(itemSeg.getUID(), itemSeg.getDescripcion().es, itemSeg.getDescripcion().eu, itemSeg.getTipo(), itemSeg.getSubTipo(), this._obtainItemAuths(authCtx, itemSeg));
                        if (authorizedResources == null) {
                            authorizedResources = new HashMap();
                        }
                        authorizedResources.put(resourceCtx.getOID(), resourceCtx);
                        if (tipoObj.getInstances() != null && tipoObj.getInstances().length > 0) {
                            int i = 0;
                            while (i < tipoObj.getInstances().length) {
                                itemSeg = tipoObj.getInstances()[i];
                                resourceCtx = new R01FResourceCtx(itemSeg.getUID(), tipoObj.getItemSeguridad().getUID(), itemSeg.getDescripcion().es, itemSeg.getDescripcion().eu, itemSeg.getTipo(), itemSeg.getSubTipo(), this._obtainItemAuths(authCtx, itemSeg));
                                if (authorizedResources == null) {
                                    authorizedResources = new HashMap();
                                }
                                authorizedResources.put(resourceCtx.getOID(), resourceCtx);
                                ++i;
                            }
                        }
                    }
                } else if (currResCfg2.getType().equals("function")) {
                    resourceCtx = new R01FResourceCtx(currResCfg2.oid, currResCfg2.name.getEs(), currResCfg2.name.getEu(), currResCfg2.type, null, null);
                    if (authorizedResources == null) {
                        authorizedResources = new HashMap<String, R01FResourceCtx>();
                    }
                    authorizedResources.put(resourceCtx.getOID(), resourceCtx);
                } else if (currResCfg2.getType().equals("object")) {
                    resourceCtx = new R01FResourceCtx(currResCfg2.oid, currResCfg2.name.getEs(), currResCfg2.name.getEu(), currResCfg2.type, null, null);
                    if (authorizedResources == null) {
                        authorizedResources = new HashMap();
                    }
                    authorizedResources.put(resourceCtx.getOID(), resourceCtx);
                }
                R01FLog.to("r01f.auth").fine("Nuevo recurso: " + resourceCtx.getOID());
            }
        }
        catch (Exception saxEx) {
            R01FLog.to("r01f.auth").severe("Error al parsear el documento xml de informacion de xlnets: " + saxEx.getMessage());
            saxEx.printStackTrace();
            return null;
        }
        targetCtx = new R01FTargetCtx(targetCfg, authorizedResources);
        return targetCtx;
    }

    private Map _obtainItemAuths(R01FAuthCtx authCtx, R01FXLNetsItemSeguridad itemSeg) {
        HashMap<String, R01FResourceAuthorization> outAuths = null;
        R01FXLNetsAutorizacion[] auths = itemSeg.getAutorizaciones();
        R01FResourceAuthorization currAuth = null;
        if (auths != null && auths.length > 0) {
            outAuths = new HashMap<String, R01FResourceAuthorization>(auths.length);
            int i = 0;
            while (i < auths.length) {
                currAuth = new R01FResourceAuthorization(auths[i].getCN(), auths[i].getDescripcion().es, auths[i].getDescripcion().eu, auths[i].getAcciones(), authCtx.getProfile(auths[i].getPerfil()));
                outAuths.put(currAuth.getOID(), currAuth);
                ++i;
            }
        }
        return outAuths;
    }

    private Document _loadXMLFile(String fileName) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new File(fileName));
    }
}

