/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.servlet.filter.authorization;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.servlet.filter.authorization.R01FAuthCfg;
import com.ejie.r01f.servlet.filter.authorization.R01FBaseAuthProvider;
import com.ejie.r01f.servlet.filter.authorization.R01FTargetCfg;
import com.ejie.r01f.util.StringUtils;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class R01FAuthFilterUtils {
    public static String getURI(ServletRequest request) {
        HttpServletRequest req = (HttpServletRequest)request;
        return String.valueOf(req.getServerName()) + (req.getServerPort() == 80 ? "" : ":" + req.getServerPort()) + req.getRequestURI();
    }

    public static boolean matches(String uri, String pattern) {
        Pattern p = null;
        Matcher m = null;
        p = Pattern.compile("^" + pattern + "$");
        m = p.matcher(uri);
        return m.find();
    }

    public static R01FBaseAuthProvider obtainAuthProviderInstance(R01FAuthCfg authCfg, ServletRequest req, String providerId) throws ReflectionException {
        R01FBaseAuthProvider outProvider = null;
        R01FAuthCfg.Provider cfgProvider = null;
        if (!StringUtils.isEmptyString(providerId)) {
            cfgProvider = authCfg.getProvider(providerId);
        }
        if (cfgProvider != null && cfgProvider.getClassName() != null) {
            R01FLog.to("r01m.security").fine("Instanciando el provider de autorizacion..." + cfgProvider.getClassName());
            outProvider = (R01FBaseAuthProvider)ReflectionUtils.getObjectInstance(cfgProvider.getClassName());
            if (cfgProvider.getInitParams() != null) {
                try {
                    ReflectionUtils.invokeMethod(outProvider, "init", new Class[]{Properties.class}, new Object[]{cfgProvider.getInitParams()});
                }
                catch (Throwable th) {
                    th.printStackTrace(System.out);
                    R01FLog.to("r01m.security").severe("NO se ha podido inicializar el provider. Error en la llamada a init: " + th.getMessage());
                }
            }
            if (req != null) {
                outProvider.setRequest(req);
            }
        }
        if (outProvider == null) {
            throw new ReflectionException("No se ha podido obtener una instancia del provider de autorizacion (" + (cfgProvider != null ? cfgProvider.getClassName() : "el provider no est\u00e1 configurado") + ")");
        }
        return outProvider;
    }

    public static R01FTargetCfg getResourceThatFirstMatches(R01FAuthCfg appCfg, String uri) {
        if (uri == null) {
            uri = "dummy";
            R01FLog.to("r01f.auth").info("La uri suministrada es nula... se toma una uri dummy, as\u00ed que se machear\u00e1 unicamente el target con uriPattern * (si lo hay)");
        }
        R01FLog.to("r01f.auth").fine("Intentando casar la URI: " + uri + " con los patrones de uri especificados en el fichero de properties");
        if (appCfg.getTargets() != null) {
            Map.Entry me2 = null;
            String pattern = null;
            for (Map.Entry me2 : appCfg.getTargets().entrySet()) {
                pattern = (String)me2.getKey();
                R01FLog.to("r01f.auth").fine("...pattern: " + pattern);
                if (!R01FAuthFilterUtils.matches(uri, pattern)) continue;
                R01FLog.to("r01f.auth").fine("pattern: " + pattern + " MATCHES!!!!");
                return (R01FTargetCfg)me2.getValue();
            }
        }
        R01FLog.to("r01f.auth").warning("No se ha encontrado ningun patron para la uri a la que se quiere acceder!!!!");
        return null;
    }
}

