/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.servlet.filter.authorization;

import com.ejie.r01f.servlet.filter.authorization.R01FProfileCtx;
import com.ejie.r01f.servlet.filter.authorization.R01FTargetCtx;
import com.ejie.r01f.servlet.filter.authorization.R01FUserCtx;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class R01FAuthCtx
implements Serializable {
    private static final long serialVersionUID = 5697699783433808308L;
    public boolean override = false;
    public R01FUserCtx user = null;
    public Map attributes = null;
    public Date loginDate = new Date();
    public Map profiles = null;
    public Map authorizedTargets = null;

    R01FAuthCtx() {
    }

    public R01FAuthCtx(boolean theOverride, R01FUserCtx theUser, Map authAttrs, Date theLoginDate, Map theProfiles) {
        this.override = theOverride;
        this.user = theUser;
        this.attributes = authAttrs;
        this.loginDate = theLoginDate;
        this.profiles = theProfiles;
    }

    public boolean isOverridingAuthorization() {
        return this.override;
    }

    public R01FUserCtx getUser() {
        return this.user;
    }

    public Date getLoginDate() {
        return this.loginDate;
    }

    public Iterator getProfilesIterator() {
        if (this.profiles == null) {
            return null;
        }
        return this.profiles.values().iterator();
    }

    public R01FProfileCtx getProfile(String profileOID) {
        if (this.profiles == null || profileOID == null) {
            return null;
        }
        return (R01FProfileCtx)this.profiles.get(profileOID);
    }

    public R01FTargetCtx getTargetAuth(String uriPattern) {
        if (this.authorizedTargets == null) {
            return null;
        }
        return (R01FTargetCtx)this.authorizedTargets.get(uriPattern);
    }

    public String getAttribute(String attrName) {
        if (attrName == null) {
            return null;
        }
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributes.get(attrName);
    }

    public boolean hasProfile(String profileOID) {
        if (profileOID == null || this.profiles == null) {
            return false;
        }
        return this.profiles.containsKey(profileOID);
    }

    public boolean isValid() {
        if (this.user == null || !this.user.isValid()) {
            return false;
        }
        if (this.profiles == null || this.profiles.size() == 0) {
            return false;
        }
        Object currProfile2 = null;
        for (Object currProfile2 : this.profiles.values()) {
            if (currProfile2 instanceof R01FProfileCtx || ((R01FProfileCtx)currProfile2).isValid()) continue;
            return false;
        }
        if (this.authorizedTargets == null || this.authorizedTargets.size() == 0) {
            return false;
        }
        Object currRes2 = null;
        for (Object currRes2 : this.authorizedTargets.values()) {
            if (currRes2 instanceof R01FTargetCtx || ((R01FTargetCtx)currRes2).isValid()) continue;
            return false;
        }
        return true;
    }

    public String toXML() throws XOMarshallerException {
        String map = XMLProperties.get("r01f", "authMapPath", "/html/datos/r01fAuthMapping.xml");
        if (map != null) {
            return XOManager.getXML(XMLProperties.get("r01f", "authMapPath"), (Object)this);
        }
        return "";
    }
}

