/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.servlet.download;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.servlet.download.DownloadContentReader;
import com.ejie.r01f.xmlproperties.XMLProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DownloadServlet
extends HttpServlet {
    private static final long serialVersionUID = -1348150074328115216L;
    private static final String APPCODE = "appCode";
    private static final String READERID = "readerID";
    private ServletConfig _config = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this._config = config;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        R01FLog.to("r01f.servlet").info("\n\n\n\n>>>>>>>>>>DownloadServlet.................");
        String appCode = this._config.getInitParameter(APPCODE);
        String readerID = null;
        DownloadContentReader contentReader = null;
        try {
            if (request.getParameter(APPCODE) != null) {
                appCode = request.getParameter(APPCODE);
            }
            readerID = request.getParameter(READERID);
            if (appCode == null) {
                throw new ServletException(String.valueOf(((Object)((Object)this)).getClass().getName()) + ": Configuration error: Either the appCode request parameter is left or it's not configured in the web.xml file");
            }
            if (readerID == null) {
                throw new ServletException(String.valueOf(((Object)((Object)this)).getClass().getName()) + ": Configuration error: The readerID parameter is missing");
            }
            if (contentReader == null) {
                contentReader = this._getContentReaderInstance(appCode, readerID);
            }
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            String currParamName = null;
            String currParamValue = null;
            Enumeration en = request.getParameterNames();
            while (en.hasMoreElements()) {
                currParamName = (String)en.nextElement();
                currParamValue = request.getParameterValues(currParamName)[0];
                parameterMap.put(currParamName, currParamValue);
            }
            contentReader.setRequestParams(parameterMap);
            String resourceName = contentReader.getResourceName();
            R01FLog.to("r01f.servlet").info(">>>>Descargando fichero: " + resourceName + "\n\n\n");
            response.setHeader("Content-Disposition", "attachment;name=\"" + resourceName + "\";filename=\"" + resourceName + "\"");
            ServletOutputStream out = response.getOutputStream();
            InputStream in = contentReader.getBinaryStream();
            byte[] b = new byte[24576];
            int readed = -1;
            while ((readed = in.read(b)) > 0) {
                out.write(b, 0, readed);
            }
        }
        catch (IOException ioEx) {
            throw new ServletException("Error while reading from the content or while writing to the output\n" + ioEx.getMessage());
        }
    }

    private DownloadContentReader _getContentReaderInstance(String appCode, String readerID) throws ServletException {
        try {
            DownloadContentReader reader = null;
            String readerClassName = XMLProperties.getString(appCode, "downloadServlet/readers/reader[@id='" + readerID + "']/class");
            Properties readerProperties = XMLProperties.getProperties(appCode, "downloadServlet/readers/reader[@id='" + readerID + "']/config");
            if (readerProperties == null) {
                readerProperties = new Properties();
            }
            readerProperties.setProperty(APPCODE, appCode);
            if (readerClassName == null) {
                throw new ServletException("DownloadServlet configuration error: downloadServlet/readers/reader[@id='" + readerID + "']/class not found in " + appCode + ".properties file");
            }
            R01FLog.to("r01f.servlet").fine(">>> Instanciando clase reader del contenido: '" + readerClassName + "'");
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> readerClass = cl.loadClass(readerClassName);
            reader = (DownloadContentReader)readerClass.newInstance();
            reader.setConfig(readerProperties);
            return reader;
        }
        catch (ClassNotFoundException cnfEx) {
            throw new ServletException("ClassNotFoundException in DownloadServlet: " + cnfEx.toString(), (Throwable)cnfEx);
        }
        catch (IllegalAccessException illAccEx) {
            throw new ServletException("IllegalAccessException in DownloadServlet: " + illAccEx.toString(), (Throwable)illAccEx);
        }
        catch (InstantiationException instEx) {
            throw new ServletException("InstantiationException in DownloadServlet: " + instEx.toString(), (Throwable)instEx);
        }
    }
}

