/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.servlet;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.servlet.URLUtils;
import java.io.IOException;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestUtils {
    public static String obtainClientIP(HttpServletRequest req) {
        String ip = "noIP";
        if (req != null && (ip = req.getHeader("WL-Proxy-Client-IP")) == null) {
            ip = req.getRemoteAddr();
        }
        return ip;
    }

    public static RequestDispatcher getRequestDispatcher(ServletContext ctx, String path) {
        if (ctx == null || path == null) {
            R01FLog.to("r01f.util").warning("NO se puede obtener un request dispatcher: servletContext " + (ctx == null ? null : "no null") + " path " + (path == null ? null : "no null") + ". SE RETORNA UN REQUEST DISPACHER NULL!!!!");
            return null;
        }
        RequestDispatcher outRD = null;
        String pathNormalized = URLUtils.normalize(path);
        if (!path.startsWith("/") && !path.startsWith("\\")) {
            outRD = ctx.getRequestDispatcher(pathNormalized);
        } else {
            String contextPath = URLUtils.getContextPath(pathNormalized);
            String file = URLUtils.getFileName(pathNormalized);
            ServletContext newContext = ctx.getContext(contextPath);
            outRD = newContext.getRequestDispatcher("/" + file);
        }
        return outRD;
    }

    public static void redirect(ServletConfig config, HttpServletRequest req, HttpServletResponse res, String path) throws ServletException {
        if (req == null || path == null) {
            R01FLog.to("r01f.util").warning("NO se puede redirigir: request " + (req == null ? null : "no null") + " path " + (path == null ? null : "no null"));
            throw new ServletException("NO se puede redirigir: request " + (req == null ? null : "no null") + " path " + (path == null ? null : "no null"));
        }
        String pathNormalized = URLUtils.normalize(path);
        try {
            if (pathNormalized.startsWith("http://") || pathNormalized.startsWith("https://")) {
                if (res == null) {
                    R01FLog.to("r01f.servlet").warning("NO se puede redirigir por cliente ya que la response es nula");
                    throw new ServletException("NO se puede redirigir por cliente ya que la response es nula");
                }
                R01FLog.to("r01f.servlet").info("Redireci\u00f3n absoluta via cliente al path " + pathNormalized);
                res.sendRedirect(pathNormalized);
                return;
            }
            if (pathNormalized.startsWith("/") && pathNormalized.indexOf(47, 1) > 1) {
                String contextPath = URLUtils.getContextPath(pathNormalized);
                ServletContext newContext = config.getServletContext().getContext(contextPath);
                if (newContext != null) {
                    String redirectPath = URLUtils.getPathWithoutContext(pathNormalized);
                    R01FLog.to("r01f.servlet").info("Redireci\u00f3n relativa en otro war al path " + redirectPath);
                    RequestDispatcher rd = newContext.getRequestDispatcher(redirectPath);
                    if (rd == null) {
                        throw new ServletException("Error al obtener un request dispatcher al contexto " + contextPath);
                    }
                    rd.forward((ServletRequest)req, (ServletResponse)res);
                    return;
                }
                R01FLog.to("r01f.servlet").warning("No se ha podido obtener el contexto del war " + contextPath + " solicitado en la ruta " + pathNormalized + ". \u00bfpuede ser que no sea un war y sea una redirecci\u00f3n local?");
                R01FLog.to("r01f.servlet").info("Redireci\u00f3n relativa en el mismo war al path " + pathNormalized);
                RequestDispatcher rd = req.getRequestDispatcher(pathNormalized);
                if (rd == null) {
                    throw new ServletException("Error al obtener un request dispatcher al contexto actual");
                }
                rd.forward((ServletRequest)req, (ServletResponse)res);
            }
        }
        catch (IOException ioEx) {
            throw new ServletException("Error al redirigir a la pagina '" + pathNormalized + "'", (Throwable)ioEx);
        }
        catch (IllegalStateException illStEx) {
            throw new ServletException("Error al redirigir a la pagina '" + pathNormalized + "'", (Throwable)illStEx);
        }
        catch (ServletException servEx) {
            throw new ServletException("Error al redirigir a la pagina '" + pathNormalized + "'", (Throwable)servEx);
        }
        catch (Exception ex) {
            throw new ServletException("Error al redirigir a la pagina '" + pathNormalized + "'", (Throwable)ex);
        }
    }

    private static boolean _isRootContext(ServletContext servletContext) {
        return servletContext == servletContext.getContext("/");
    }

    public static String composeRequestParamsDebufInfo(HttpServletRequest req) {
        Map parameters;
        StringBuffer sb = new StringBuffer("RequestParameters:\r\n");
        if (req == null) {
            sb.append("\trequest null!");
        }
        if ((parameters = req.getParameterMap()) == null) {
            sb.append("\tparameters null!!");
        }
        Map.Entry me2 = null;
        for (Map.Entry me2 : parameters.entrySet()) {
            sb.append("\t" + me2.getKey() + "=" + me2.getValue() + "\r\n");
        }
        return sb.toString();
    }
}

