/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.servicelocator;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.R01FProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.rmi.PortableRemoteObject;

public class R01FEJBHomeFactory {
    public static final String APPLICATION_DEFAULT = "default";
    private static Hashtable instance;
    private Context initialContext;
    private Map ejbHomes;
    private String instanceName = "";
    private String instanceApp = "";

    private R01FEJBHomeFactory() throws NamingException {
        this.initialContext = new InitialContext();
        this.ejbHomes = Collections.synchronizedMap(new HashMap());
        this.instanceName = APPLICATION_DEFAULT;
        this.instanceApp = APPLICATION_DEFAULT;
    }

    public static R01FEJBHomeFactory getInstance() {
        return R01FEJBHomeFactory.getInstance(APPLICATION_DEFAULT, APPLICATION_DEFAULT);
    }

    private R01FEJBHomeFactory(String application, String name) {
        this.instanceName = name;
        this.instanceApp = application;
        this.ejbHomes = Collections.synchronizedMap(new HashMap());
    }

    public static R01FEJBHomeFactory getInstance(String application, String name) {
        if (instance == null) {
            instance = new Hashtable();
        }
        R01FEJBHomeFactory fInstance = null;
        if (instance.get(String.valueOf(application) + name) == null) {
            fInstance = new R01FEJBHomeFactory(application, name);
            instance.put(String.valueOf(application) + name, fInstance);
        } else {
            fInstance = (R01FEJBHomeFactory)instance.get(String.valueOf(application) + name);
        }
        return fInstance;
    }

    public EJBLocalHome lookupByLocalEJBReference(String ejbReferenceComponent) throws NamingException {
        Object home;
        if (this.initialContext == null) {
            this.initialContext = new InitialContext();
        }
        if ((home = this.ejbHomes.get(ejbReferenceComponent)) == null) {
            home = this.initialContext.lookup(ejbReferenceComponent);
            this.ejbHomes.put(ejbReferenceComponent, home);
        }
        return (EJBLocalHome)home;
    }

    public EJBHome lookupByRemoteEJBReference(String ejbReferenceComponent, Class homeClass) throws NamingException {
        Object home = this.ejbHomes.get(ejbReferenceComponent);
        if (home == null) {
            Hashtable<String, String> env = new Hashtable<String, String>();
            if (this.initialContext == null) {
                env.put("java.naming.factory.initial", R01FProperties.getProperty(this.instanceApp, "ejbs/" + ejbReferenceComponent + "/initial_context_factory"));
                env.put("java.naming.provider.url", R01FProperties.getProperty(this.instanceApp, "ejbs/" + ejbReferenceComponent + "/provider_url"));
                this.initialContext = new InitialContext(env);
            }
            try {
                Object obj = this.initialContext.lookup(ejbReferenceComponent);
                home = PortableRemoteObject.narrow((Object)obj, (Class)homeClass);
                this.ejbHomes.put(ejbReferenceComponent, home);
            }
            catch (NoInitialContextException e) {
                env.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
                env.put("java.naming.provider.url", R01FProperties.getProperty("r01f", "PROVIDER_URL"));
                this.initialContext = new InitialContext(env);
                Object obj = this.initialContext.lookup(ejbReferenceComponent);
                home = PortableRemoteObject.narrow((Object)obj, (Class)homeClass);
                this.ejbHomes.put(ejbReferenceComponent, home);
            }
            catch (Exception e) {
                R01FLog.to("r01f.test").fine(e.getMessage());
            }
        }
        return (EJBHome)home;
    }
}

