/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.rpcdispatcher;

import com.ejie.r01f.rpcdispatcher.RPCCall;
import com.ejie.r01f.rpcdispatcher.RPCException;
import com.ejie.r01f.servlet.RequestParamParser;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class RPCContext {
    public RPCCall rpcCall;
    public ServletContext application;
    public HttpServletRequest request;
    public HttpServletResponse response;
    public RequestParamParser requestParamParser;
    public Map protocolData;
    public Stack previousCallsResults = new Stack();
    public String token;
    public String threadName;
    public String targetPage;
    public boolean absoluteRedirect = false;
    public boolean includeRPCCallResultWrapperHeader = true;
    public String resultObectsToXMLMapFile = null;

    public HttpSession getSession(boolean createNewSession) {
        if (this.request != null) {
            return this.request.getSession(createNewSession);
        }
        return null;
    }

    public void invalidate() {
        this.rpcCall = null;
        Enumeration en = this.request.getAttributeNames();
        while (en.hasMoreElements()) {
            String attrName = (String)en.nextElement();
            this.request.removeAttribute(attrName);
        }
        this.request = null;
        this.protocolData = null;
        this.previousCallsResults = new Stack();
        this.token = null;
        this.targetPage = null;
        this.absoluteRedirect = false;
    }

    public void throwRPCException(String msg) throws RPCException {
        throw new RPCException(this, msg);
    }

    public void throwRPCException(int errorCode, String msg) throws RPCException {
        throw new RPCException(this, errorCode, msg);
    }

    public void throwRPCException(Exception th) throws RPCException {
        throw new RPCException(this, th);
    }

    public void throwRPCException(String msg, Exception th) throws RPCException {
        throw new RPCException(this, msg, th);
    }

    public void throwRPCException(int errorCode, String msg, Exception th) throws RPCException {
        throw new RPCException(this, errorCode, msg, th);
    }

    public void setProtocolData(String attrName, String attr) {
        if (this.protocolData == null) {
            this.protocolData = new HashMap();
        }
        this.protocolData.put(attrName, attr);
    }

    public String getProtocolData(String attrName) {
        if (this.protocolData == null) {
            return "";
        }
        String value = (String)this.protocolData.get(attrName);
        if (value != null) {
            return value;
        }
        return "";
    }

    public void setApplicationAttribute(String attrName, Object attr) {
        this.application.setAttribute(attrName, attr);
    }

    public Object getApplicationAttribute(String attrName) {
        return this.application.getAttribute(attrName);
    }

    public void setSessionAttribute(String attrName, Object attr) {
        HttpSession thisSession = this.request.getSession(true);
        thisSession.setAttribute(attrName, attr);
    }

    public Object getSessionAttribute(String attrName) {
        HttpSession thisSession = this.request.getSession(false);
        if (thisSession == null) {
            return null;
        }
        return thisSession.getAttribute(attrName);
    }

    public void removeSessionAttribute(String attrName) {
        HttpSession thisSession = this.request.getSession(false);
        thisSession.removeAttribute(attrName);
    }

    public void setRequestAttribute(String attrName, Object attr) {
        this.request.setAttribute(attrName, attr);
    }

    public Object getRequestAttribute(String attrName) {
        return this.request.getAttribute(attrName);
    }

    public String getRequestParameter(String paramName) {
        return this.request.getParameter(paramName);
    }

    public String printDebugInfo() {
        StringBuffer sb = new StringBuffer("");
        if (this.rpcCall != null) {
            sb.append("Llamada RPC\r\n");
            sb.append("\t");
            sb.append(this.rpcCall.toXML());
            sb.append("\r\n");
            if (this.rpcCall != null) {
                sb.append("\tM\u00f3dulo: ");
                sb.append(this.rpcCall.getModule());
                sb.append("\r\n\tFunciones:\r\n");
                if (this.rpcCall.getFunctions() != null && !this.rpcCall.getFunctions().isEmpty()) {
                    Iterator it = this.rpcCall.getFunctions().iterator();
                    while (it.hasNext()) {
                        sb.append("\t\t");
                        sb.append(it.next());
                        sb.append("\r\n");
                    }
                }
            }
        }
        if (this.protocolData != null && !this.protocolData.isEmpty()) {
            sb.append("\tInformacion de protocolo (parametros adicionales)\r\n");
            for (Map.Entry me : this.protocolData.entrySet()) {
                sb.append("\t\t");
                sb.append((String)me.getKey());
                sb.append(" = ");
                sb.append((String)me.getValue());
                sb.append("\r\n");
            }
        }
        return sb.toString();
    }
}

