/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.rpcdispatcher;

import com.ejie.r01f.rpcdispatcher.RPCConstants;
import com.ejie.r01f.rpcdispatcher.RPCException;
import com.ejie.r01f.rpcdispatcher.RPCFunction;
import com.ejie.r01f.rpcdispatcher.RPCParameter;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlbuilder.XMLNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class RPCCall
implements Serializable {
    private static final long serialVersionUID = 3896720502737796845L;
    String _module = null;
    List _functionsToCall = null;

    public RPCCall() {
    }

    public RPCCall(String inModuleName) {
        this._module = inModuleName;
    }

    public RPCCall(String inModuleName, String inThreadName) {
        this._module = inModuleName;
    }

    public boolean addFunction(RPCFunction newFunction) {
        if (this._functionsToCall == null) {
            this._functionsToCall = new ArrayList();
        }
        return this._functionsToCall.add(newFunction);
    }

    public RPCFunction getFunction(int inIndex) {
        if (this._functionsToCall == null) {
            return null;
        }
        return (RPCFunction)this._functionsToCall.get(inIndex);
    }

    public Collection getFunctions() {
        if (this._functionsToCall == null) {
            return null;
        }
        return this._functionsToCall;
    }

    public void setModule(String newModule) {
        this._module = newModule;
    }

    public String getModule() {
        return this._module == null ? "" : this._module;
    }

    public void loadFromXML(InputStream is) throws SAXException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            RPCCallXMLLoader xmlLoader = new RPCCallXMLLoader();
            xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", xmlLoader);
            saxParser.parse(is, (DefaultHandler)xmlLoader);
        }
        catch (ParserConfigurationException pcEx) {
            throw new SAXException("RPCRegistry:loadFromXML(): Error en la configuraci\u00f3n del parser: " + pcEx.getMessage());
        }
        catch (IOException ioEx) {
            throw new SAXException("RPCRegistry:loadFromXML(): Error de IO " + ioEx.getMessage());
        }
    }

    public StringBuffer getJavaScript() {
        StringBuffer sb = new StringBuffer(38);
        sb.append("var ");
        sb.append("rpcCall");
        sb.append(StringUtils.capitalizeFirstLetter(this._module));
        sb.append(" = new RPC(");
        if (this._module != null) {
            sb.append("'");
            sb.append(this._module);
            sb.append("'");
        } else {
            sb.append("null");
        }
        sb.append(");\r\n");
        if (this._functionsToCall != null) {
            for (RPCFunction currFunc : this._functionsToCall) {
                sb.append(currFunc.getJavaScript());
                sb.append("rpcCall");
                sb.append(StringUtils.capitalizeFirstLetter(this._module));
                sb.append(".addFunction(");
                sb.append('f');
                sb.append(StringUtils.capitalizeFirstLetter(currFunc.getName()));
                sb.append(");\r\n");
            }
        }
        return sb;
    }

    XMLNode getXMLNode() {
        XMLNode callNode = new XMLNode("rpcCall");
        callNode.addAttribute("module", this._module);
        if (this._functionsToCall != null) {
            Iterator it = this._functionsToCall.iterator();
            while (it.hasNext()) {
                callNode.addSubNode(((RPCFunction)it.next()).getXMLNode());
            }
        }
        return callNode;
    }

    public String toXML() {
        return this.getXMLNode().toString();
    }

    public String toURLEncodedString() {
        StringBuffer str = new StringBuffer(572);
        str.append("module");
        str.append('=');
        str.append(this._module);
        if (this._functionsToCall != null && this._functionsToCall.size() >= 1) {
            RPCFunction function = (RPCFunction)this._functionsToCall.get(0);
            str.append('&');
            str.append("function");
            str.append('=');
            str.append(function.getName());
            if (function.getParameters() != null) {
                int i = 1;
                for (RPCParameter param : function.getParameters().values()) {
                    str.append('&');
                    str.append("param");
                    str.append(i);
                    str.append('=');
                    if (param.getDataTypeCode() == 14) {
                        str.append(DateUtils.getDateFormated((Date)param.getValue(), "dd/MM/yyyy-hh:mm:ss:SSS"));
                        continue;
                    }
                    str.append(param.getValue().toString());
                }
            }
        }
        return str.toString();
    }

    public String toString() {
        StringBuffer strOut = new StringBuffer(24);
        strOut.append("Llamada RPC:\r\n");
        if (this._module != null) {
            strOut.append("Modulo: ");
            strOut.append(this._module);
            strOut.append("\r\n");
        }
        if (this._functionsToCall != null) {
            strOut.append("Funciones:\r\n");
            RPCFunction currFunc2 = null;
            for (RPCFunction currFunc2 : this._functionsToCall) {
                strOut.append(currFunc2.toString());
                strOut.append("\r\n");
            }
        }
        return strOut.toString();
    }

    private class RPCCallXMLLoader
    extends DefaultHandler
    implements LexicalHandler {
        private Stack _tagStack = new Stack();
        private RPCFunction _currFunction;
        private RPCParameter _currParam;
        private StringBuffer _chars;
        private boolean _loadingXMLParam = false;

        @Override
        public void startDocument() {
        }

        @Override
        public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
            String eName = lName;
            if ("".equals(eName)) {
                eName = qName;
            }
            if (this._loadingXMLParam) {
                if (this._chars == null) {
                    this._chars = new StringBuffer();
                }
                this._chars.append('<');
                this._chars.append(eName);
                int i = 0;
                while (i < attrs.getLength()) {
                    this._chars.append(' ');
                    this._chars.append(attrs.getQName(i));
                    this._chars.append("='");
                    this._chars.append(attrs.getValue(i));
                    this._chars.append("'");
                    ++i;
                }
                this._chars.append('>');
                return;
            }
            this._tagStack.push(eName);
            if (eName.equalsIgnoreCase("rpcCall")) {
                if (attrs != null && attrs.getValue("module") != null) {
                    RPCCall.this._module = attrs.getValue("module");
                }
            } else if (eName.equalsIgnoreCase("function")) {
                if (RPCCall.this._functionsToCall == null) {
                    RPCCall.this._functionsToCall = new ArrayList();
                }
                this._currFunction = new RPCFunction();
                if (attrs != null && attrs.getValue("name") != null) {
                    this._currFunction.setName(attrs.getValue("name"));
                }
            } else if (eName.equalsIgnoreCase("param")) {
                this._currParam = new RPCParameter();
                if (attrs != null) {
                    this._currParam.setName(attrs.getValue("name"));
                    this._currParam.setDataType(attrs.getValue("type"));
                    boolean validDataType = false;
                    int i = 0;
                    while (i < RPCConstants.DATATYPES.length) {
                        if (RPCConstants.DATATYPES[i].equals(this._currParam.getDataType())) {
                            validDataType = true;
                        }
                        ++i;
                    }
                    if (!validDataType) {
                        throw new SAXException("RPCCall:loadFromXML(): El tipo de argumento " + this._currParam.getDataType() + " no esta soportado en una llamada RPC, solamente son validos los argumentos String, Double, Float, Integer, Long, Boolean, Date y XML");
                    }
                    if (this._currParam.getDataTypeCode() == 15) {
                        this._loadingXMLParam = true;
                    }
                }
            }
        }

        @Override
        public void characters(char[] buf, int offset, int len) {
            String s = new String(buf, offset, len);
            if (this._chars == null) {
                this._chars = new StringBuffer();
            }
            this._chars.append(s);
        }

        @Override
        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            String eName = sName;
            if ("".equals(eName)) {
                eName = qName;
            }
            try {
                if (this._loadingXMLParam && eName.equalsIgnoreCase("param")) {
                    this._loadingXMLParam = false;
                    this._currParam.setValue(this._chars.toString());
                    this._chars = null;
                } else {
                    if (this._loadingXMLParam) {
                        if (this._chars == null) {
                            this._chars = new StringBuffer();
                        }
                        this._chars.append("</");
                        this._chars.append(eName);
                        this._chars.append('>');
                        return;
                    }
                    if (this._chars != null) {
                        String currentTag = (String)this._tagStack.peek();
                        String s = this._chars.toString();
                        if (currentTag.equalsIgnoreCase("param")) {
                            this._currParam.setValue(s);
                        }
                        this._chars = null;
                    }
                }
            }
            catch (RPCException xrEx) {
                throw new SAXException("RPCCall:endElement(): Error al establecer el valor del parametro " + xrEx.toString());
            }
            this._tagStack.pop();
            if (eName.equalsIgnoreCase("param")) {
                this._currFunction.putParameter(this._currParam);
            } else if (eName.equalsIgnoreCase("function")) {
                RPCCall.this._functionsToCall.add(this._currFunction);
            }
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void startCDATA() {
            if (this._loadingXMLParam) {
                this._chars.append("<![CDATA[");
            }
        }

        @Override
        public void endCDATA() {
            if (this._loadingXMLParam) {
                this._chars.append("]]>");
            }
        }

        @Override
        public void comment(char[] values, int param, int param2) {
        }

        @Override
        public void startEntity(String str) {
        }

        @Override
        public void endEntity(String str) {
        }

        @Override
        public void endDTD() {
        }

        @Override
        public void startDTD(String str, String str1, String str2) {
        }
    }
}

