/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.replacer;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.log.SimpleFileLogger;
import com.ejie.r01f.replacer.DirectoryReplacer;
import com.ejie.r01f.replacer.FilteredFileReplacer;
import com.ejie.r01f.replacer.PatternMatchTableBasedCharReplacer;
import com.ejie.r01f.replacer.ReplaceEventLogger;
import com.ejie.r01f.replacer.ReplacerTranslationTableLoader;
import com.ejie.r01f.util.MainParamsParser;
import java.util.HashMap;
import java.util.Map;

public class TestReplacer {
    public static void main(String[] args) {
        try {
            MainParamsParser params = new MainParamsParser();
            params.addParamDef("-patternRegExp", "Expresion regular para buscar el texto donde hacer la sustitucion", MainParamsParser.PARAM_TYPE_GENERAL, true);
            params.addParamDef("-mapFile", "Fichero de mapeo para la traduccion", MainParamsParser.PARAM_TYPE_ALFANUMERIC, true);
            params.addParamDef("-logFile", "Fichero de log", MainParamsParser.PARAM_TYPE_ALFANUMERIC, false);
            params.parseParams(args);
            if (params.areValid()) {
                SimpleFileLogger logger = new SimpleFileLogger(params.getParam("-logFile"));
                logger.start();
                ReplaceEventLogger eventListener = new ReplaceEventLogger(logger);
                Map translationTable = ReplacerTranslationTableLoader.loadTranslationTable(params.getParam("-mapFile"));
                if (logger != null) {
                    logger.writeln("-->Fichero de mapeo:");
                }
                if (translationTable != null) {
                    for (Map.Entry me : translationTable.entrySet()) {
                        logger.writeln("\t" + (String)me.getKey() + " -> " + (String)me.getValue());
                    }
                }
                if (logger != null) {
                    logger.writeln("<-- FIN Fichero mapeo\r\n\r\n");
                }
                if (translationTable == null) {
                    throw new Exception("Error en la tabla de traduccion de palabras!!!");
                }
                HashMap context = new HashMap();
                PatternMatchTableBasedCharReplacer charReplacer = null;
                charReplacer = new PatternMatchTableBasedCharReplacer(params.getParam("-patternRegExp"), translationTable, eventListener);
                params.addParamDef("-srcFile", "Fichero de origen", MainParamsParser.PARAM_TYPE_ALFANUMERIC, true);
                params.addParamDef("-destFile", "Fichero destino", MainParamsParser.PARAM_TYPE_ALFANUMERIC, true);
                params.parseParams(args);
                if (params.areValid()) {
                    R01FLog.to("r01f.test").fine("CASO 1: Un \u00fanico fichero....");
                    R01FLog.to("r01f.test").fine(params.toString());
                    FilteredFileReplacer fileReplacer = new FilteredFileReplacer("<", ">", eventListener);
                    fileReplacer.doReplace(context, params.getParam("-srcFile"), params.getParam("-destFile"), charReplacer);
                } else {
                    params.removeParamDef("-srcFile");
                    params.removeParamDef("-destFile");
                    params.addParamDef("-dir", "Directorio", MainParamsParser.PARAM_TYPE_ALFANUMERIC, true);
                    params.addParamDef("-fileFilterExpr", "Expresion que han de verificar los nombres de los ficheros", MainParamsParser.PARAM_TYPE_GENERAL, false);
                    params.parseParams(args);
                    if (params.areValid()) {
                        R01FLog.to("r01f.test").fine("CASO 2: Un directorio....");
                        R01FLog.to("r01f.test").fine(params.toString());
                        DirectoryReplacer dirReplacer = new DirectoryReplacer(eventListener);
                        dirReplacer.doReplace(context, params.getParam("-dir"), params.getParam("-fileFilterExpr"), charReplacer, new FilteredFileReplacer("<", ">", eventListener));
                    } else {
                        R01FLog.to("r01f.test").fine("ERROR EN LOS PARAMETROS DE ENTRADA!!!!");
                        R01FLog.to("r01f.test").fine(TestReplacer._composeHelpMsg());
                    }
                }
                logger.stop();
                R01FLog.to("r01f.test").fine("FIN!!!!!");
            } else {
                R01FLog.to("r01f.test").fine("ERROR EN LOS PARAMETROS DE ENTRADA!!!!");
                R01FLog.to("r01f.test").fine(TestReplacer._composeHelpMsg());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            R01FLog.to("r01f.test").fine("Exception!!!" + ex.toString());
        }
    }

    private static String _composeHelpMsg() {
        StringBuffer sb = new StringBuffer("");
        MainParamsParser params = new MainParamsParser();
        params.addParamDef("-patternRegExp", "Expresion regular para buscar el texto donde hacer la sustitucion", MainParamsParser.PARAM_TYPE_GENERAL, true);
        params.addParamDef("-mapFile", "Fichero de mapeo para la traduccion", MainParamsParser.PARAM_TYPE_ALFANUMERIC, true);
        params.addParamDef("-logFile", "Fichero de log", MainParamsParser.PARAM_TYPE_ALFANUMERIC, false);
        sb.append("Utilizacion:\r\n");
        sb.append("-----------------------------------------------------\r\n");
        sb.append("Para remplazar texto en un unico fichero: \r\n");
        params.addParamDef("-srcFile", "Fichero de origen", MainParamsParser.PARAM_TYPE_ALFANUMERIC, true);
        params.addParamDef("-destFile", "Fichero destino", MainParamsParser.PARAM_TYPE_ALFANUMERIC, false);
        sb.append(params.getParamsUsageMessage());
        sb.append("\r\n\r\n");
        sb.append("Para remplazar texto en varios ficheros en una estructura de directorios:\r\n");
        params.removeParamDef("-srcFile");
        params.removeParamDef("-destFile");
        params.addParamDef("-dir", "Directorio", MainParamsParser.PARAM_TYPE_ALFANUMERIC, true);
        params.addParamDef("-fileFilterExpr", "Expresion que han de verificar los nombres de los ficheros", MainParamsParser.PARAM_TYPE_GENERAL, false);
        sb.append(params.getParamsUsageMessage());
        return sb.toString();
    }
}

