/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.replacer;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.log.SimpleLogger;
import com.ejie.r01f.replacer.ReplaceEventListener;
import java.util.Map;

public class ReplaceEventLogger
implements ReplaceEventListener {
    private SimpleLogger _logger = null;

    public ReplaceEventLogger() {
    }

    public ReplaceEventLogger(SimpleLogger logger) {
        this._logger = logger;
    }

    @Override
    public void beforeCharReplace(Map context, String originalText) {
    }

    @Override
    public void charReplaced(Map context, String originalText, String replacedText) {
        if (originalText == null || replacedText == null) {
            return;
        }
        String msg = "\tFrom: " + originalText + " - To: " + replacedText;
        if (this._logger != null) {
            this._logger.writeln(msg);
        } else {
            R01FLog.to("r01f.test").fine(msg);
        }
    }

    @Override
    public void directoryEntering(Map context, String dirName) {
        String msg = ">>>>>>> Entering directory: " + dirName;
        if (this._logger != null) {
            this._logger.writeln(msg);
        } else {
            R01FLog.to("r01f.test").fine(msg);
        }
    }

    @Override
    public void directoryExiting(Map context, String dirName) {
        String msg = "<<<<<<< Exiting directory:" + dirName;
        if (this._logger != null) {
            this._logger.writeln(msg);
        } else {
            R01FLog.to("r01f.test").fine(msg);
        }
    }

    @Override
    public void beforeFileReplace(Map context, String fileName) {
        String msg = "\t:::::File: " + fileName;
        if (this._logger != null) {
            this._logger.writeln(msg);
        } else {
            R01FLog.to("r01f.test").fine(msg);
        }
    }

    @Override
    public void fileReplaced(Map context, String fileName) {
        String msg = "\t:::::END File: " + fileName;
        if (this._logger != null) {
            this._logger.writeln(msg);
        } else {
            R01FLog.to("r01f.test").fine(msg);
        }
    }

    @Override
    public void generalEvent(Map context, String eventText) {
        if (eventText != null) {
            if (this._logger != null) {
                this._logger.writeln(eventText);
            } else {
                R01FLog.to("r01f.test").fine(eventText);
            }
        }
    }
}

