/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.replacer;

import com.ejie.r01f.file.DirectoryWalker;
import com.ejie.r01f.file.DirectoryWalkerEventListener;
import com.ejie.r01f.file.FileUtils;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.replacer.CharSequenceReplacer;
import com.ejie.r01f.replacer.FileReplacer;
import com.ejie.r01f.replacer.ReplaceEventListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DirectoryReplacer
implements DirectoryWalkerEventListener {
    private CharSequenceReplacer _charReplacer = null;
    private FileReplacer _fileReplacer = null;
    private int _ident = 0;
    private ReplaceEventListener _eventListener = null;
    private Map _context = null;

    public DirectoryReplacer(ReplaceEventListener eventListener) {
        this._eventListener = eventListener;
    }

    @Override
    public void enteringDirectory(File theDirectory) {
        if (this._context.get("dirStack") == null) {
            this._context.put("dirStack", new Stack());
        }
        Stack dirStack = (Stack)this._context.get("dirStack");
        dirStack.push(theDirectory.getName());
        ++this._ident;
        R01FLog.to("r01f.test").fine(String.valueOf(this._ident()) + "[d] " + theDirectory.getName());
        if (this._eventListener != null) {
            this._eventListener.directoryEntering(this._context, theDirectory.getName());
        }
    }

    @Override
    public void exitingDirectory(File theDirectory) {
        Stack dirStack = (Stack)this._context.get("dirStack");
        dirStack.pop();
        --this._ident;
        if (this._eventListener != null) {
            this._eventListener.directoryExiting(this._context, theDirectory.getName());
        }
    }

    @Override
    public void file(File theFile) {
        try {
            String originalFileName = theFile.getCanonicalPath();
            String modifiedFileName = String.valueOf(theFile.getCanonicalPath()) + ".bak";
            FileUtils.renameFile(originalFileName, modifiedFileName);
            this._fileReplacer.doReplace(this._context, modifiedFileName, originalFileName, this._charReplacer);
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace(System.out);
        }
    }

    public void doReplace(Map context, String dir, final String fileFilterExpr, CharSequenceReplacer charReplacer, FileReplacer fileReplacer) {
        this._context = context;
        this._charReplacer = charReplacer;
        this._fileReplacer = fileReplacer;
        DirectoryWalker dirWalk = null;
        if (fileFilterExpr != null) {
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    Pattern p = Pattern.compile(fileFilterExpr, 128);
                    Matcher m = p.matcher(file.getName());
                    return m.matches();
                }
            };
            dirWalk = new DirectoryWalker(dir, this, fileFilter);
        } else {
            dirWalk = new DirectoryWalker(dir, this);
        }
        while (dirWalk.hasNext()) {
            dirWalk.next();
        }
    }

    private String _ident() {
        String outIdent = "";
        int i = 0;
        while (i < this._ident) {
            outIdent = String.valueOf(outIdent) + "\t";
            ++i;
        }
        return outIdent;
    }
}

