/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.process;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.process.Job;
import com.ejie.r01f.util.DateUtils;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class JobManager {
    int _maxThreads = -1;
    int _minThreads = -1;
    int _maxIdleTime = -1;
    Vector _pendingJobs = new Vector();
    List _availableThreads = new ArrayList();
    boolean _debug = false;

    public JobManager(boolean debug, int minThreads, int maxThreads, int maxIdleTime) throws NumberFormatException, IllegalArgumentException {
        this._debug = debug;
        this._minThreads = minThreads;
        this._maxThreads = maxThreads;
        this._maxIdleTime = maxIdleTime;
    }

    public JobManager(boolean debug, int minThreads, int maxThreads) throws IllegalArgumentException {
        this._debug = debug;
        this._minThreads = minThreads;
        this._maxThreads = maxThreads;
    }

    public JobManager(Properties props) throws NumberFormatException, IllegalArgumentException {
        int n;
        if (props == null) {
            return;
        }
        String o = props.getProperty("maxThreads");
        if (o != null) {
            n = Integer.parseInt(o);
            if (n < 1) {
                throw new IllegalArgumentException("El par\u00e1metro maxThreads debe de ser un entero mayor que 0");
            }
            this._maxThreads = n;
        }
        if ((o = props.getProperty("minThreads")) != null) {
            n = Integer.parseInt(o);
            if (n < -1) {
                throw new IllegalArgumentException("El par\u00e1metro minThreads debe de ser un entero de valor mayor o igual a 0 o -1");
            }
            if (n > this._maxThreads) {
                throw new IllegalArgumentException("El par\u00e1metro minThreads no puede ser mayor que  maxThreads");
            }
            this._minThreads = n;
        }
        if ((o = props.getProperty("maxIdleTime")) != null) {
            n = Integer.parseInt(o);
            if (n < 1) {
                throw new IllegalArgumentException("El par\u00e1metro maxIdleTime debe de ser un entero mayor que 0");
            }
            this._maxIdleTime = n;
        }
        if ((o = props.getProperty("debug")) != null) {
            this._debug = true;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.purgeAvailableThreadPool();
        this._availableThreads = null;
    }

    public void purgeAvailableThreadPool() {
        if (this._availableThreads != null && this._availableThreads.size() > 0) {
            for (PoolElement currEl : this._availableThreads) {
                currEl.thread.interrupt();
            }
        }
        this._availableThreads = new ArrayList();
    }

    public void waitForAll(List jobList, long testMillis, long maxMillis) {
        if (maxMillis == -1L) {
            maxMillis = Long.MAX_VALUE;
        }
        this.startAll(jobList);
        Stats stats = null;
        try {
            long countMillis = 0L;
            do {
                stats = this.getStats();
                if (this._debug) {
                    R01FLog.to("r01f.process").finest(">>>>Estadisticas de la ejecuci\u00f3n de trabajos\r\n" + stats.composeDebugInfo() + "\r\n----------------------------------------------------->");
                }
                if (stats.pendingJobs <= 0) continue;
                Thread.sleep(testMillis);
            } while (stats.jobsInProgress > 0 && (countMillis += testMillis) < maxMillis);
        }
        catch (InterruptedException intEx) {
            intEx.printStackTrace(System.out);
        }
    }

    public void waitForAll(List jobList, long testMillis) {
        this.waitForAll(jobList, testMillis, -1L);
    }

    public void startAll(List jobList) {
        this._startJobs(jobList);
    }

    public void startJob(Job theJob) {
        this._startJob(theJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job findJobById(String jobId) {
        Job outJob = null;
        Vector vector = this._pendingJobs;
        synchronized (vector) {
            Job currJob2 = null;
            for (Job currJob2 : this._pendingJobs) {
                if (!currJob2.getJobId().equals(jobId)) continue;
                return currJob2;
            }
        }
        return outJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stats getStats() {
        List list = this._availableThreads;
        synchronized (list) {
            Stats stats = new Stats();
            stats.maxThreads = this._maxThreads;
            stats.minThreads = this._minThreads;
            stats.maxIdleTime = this._maxIdleTime;
            stats.pendingJobs = this._pendingJobs.size();
            stats.numThreads = this._availableThreads.size();
            stats.jobsInProgress = this._availableThreads.size() - this._findNumIdleWorkerThreads();
            return stats;
        }
    }

    private void _startJobs(List jobs) {
        if (jobs != null) {
            Iterator it = jobs.iterator();
            while (it.hasNext()) {
                this._startJob((Job)it.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _startJob(Job theJob) {
        if (theJob != null) {
            this._pendingJobs.add(theJob);
        }
        List list = this._availableThreads;
        synchronized (list) {
            int index = this._findFirstIdleWorkerThread();
            if (index == -1) {
                if (this._maxThreads == -1 || this._availableThreads.size() < this._maxThreads) {
                    if (this._debug) {
                        R01FLog.to("r01f.process").finest("addJob > Creando un nuevo Thread para procesar el trabajo");
                    }
                    PoolElement newWorkerThread = new PoolElement(new WorkerThread());
                    newWorkerThread.idle = false;
                    newWorkerThread.thread.start();
                    this._availableThreads.add(newWorkerThread);
                    return;
                }
                if (this._debug) {
                    R01FLog.to("r01f.process").finest("addJob > Se ha alcanzado el n\u00famero m\u00e1ximo de threads del pool (" + this._maxThreads + "). El trabajo se pone en cola (" + this._pendingJobs.size() + ")");
                }
            } else {
                if (this._debug) {
                    R01FLog.to("r01f.process").finest("addJob > Utilizando un thread existente en el pool de worker threads...");
                }
                Thread thread = ((PoolElement)this._availableThreads.get((int)index)).thread;
                synchronized (thread) {
                    ((PoolElement)this._availableThreads.get((int)index)).idle = false;
                    ((PoolElement)this._availableThreads.get((int)index)).thread.notify();
                }
            }
        }
    }

    int _findNumIdleWorkerThreads() {
        int idleThreads = 0;
        int size = this._availableThreads.size();
        int i = 0;
        while (i < size) {
            if (((PoolElement)this._availableThreads.get((int)i)).idle) {
                ++idleThreads;
            }
            ++i;
        }
        return idleThreads;
    }

    int _findFirstIdleWorkerThread() {
        int size = this._availableThreads.size();
        int i = 0;
        while (i < size) {
            if (((PoolElement)this._availableThreads.get((int)i)).idle) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    int _findMe() {
        int size = this._availableThreads.size();
        int i = 0;
        while (i < size) {
            if (((PoolElement)this._availableThreads.get((int)i)).thread == Thread.currentThread()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void _removeMe() {
        int size = this._availableThreads.size();
        int i = 0;
        while (i < size) {
            if (((PoolElement)this._availableThreads.get((int)i)).thread == Thread.currentThread()) {
                this._availableThreads.remove(i);
                if (this._debug) {
                    R01FLog.to("r01f.process").finest("Ha pasado el tiempo de " + this._maxIdleTime + " milisegundos sin que se haya asignado ningun trabajo al thread: Se mata");
                }
                return;
            }
            ++i;
        }
    }

    private class PoolElement {
        boolean idle;
        Thread thread;

        public PoolElement(Thread newThread) {
            this.thread = newThread;
            this.idle = true;
        }
    }

    public class Stats {
        public int maxThreads;
        public int minThreads;
        public int maxIdleTime;
        public int numThreads;
        public int pendingJobs;
        public int jobsInProgress;

        public String toString() {
            StringBuffer sb = new StringBuffer(104);
            String strMax = this.maxThreads == -1 ? "No limit" : Integer.valueOf("" + this.maxThreads).toString();
            String strMin = this.minThreads == -1 ? "No limit" : Integer.valueOf("" + this.minThreads).toString();
            sb.append("maxThreads = ");
            sb.append(strMax);
            sb.append("\r\nminThreads = ");
            sb.append(strMin);
            sb.append("\r\nmaxIdleTime = ");
            sb.append(this.maxIdleTime);
            sb.append("\r\nnumThreads = ");
            sb.append(this.numThreads);
            sb.append("\r\npendingJobs = ");
            sb.append(this.pendingJobs);
            sb.append("\r\njobsInProgress = ");
            sb.append(this.jobsInProgress);
            return sb.toString();
        }

        public String composeDebugInfo() {
            return this.toString();
        }
    }

    private class WorkerThread
    extends Thread {
        protected void finalize() throws Throwable {
            super.finalize();
            R01FLog.to("r01f.test").fine("**************** WorkerThread del JobManager BORRADO DEL MAPA!!!!");
            if (JobManager.this._debug) {
                R01FLog.to("r01f.process").info("**************** WorkerThread del JobManager BORRADO DEL MAPA!!!!");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Job job = null;
            while (true) {
                List list;
                Object object;
                block31: {
                    object = JobManager.this._pendingJobs;
                    synchronized (object) {
                        if (JobManager.this._pendingJobs.size() == 0) {
                            break block31;
                        }
                        job = (Job)JobManager.this._pendingJobs.firstElement();
                        if (JobManager.this._debug) {
                            R01FLog.to("r01f.process").info("trabajar > Ejecutar el trabajo de id='" + job.getJobId() + "' encolado hace " + (System.currentTimeMillis() - job.getJobEnqueuedTimeStamp()) + " msg");
                        }
                        JobManager.this._pendingJobs.removeElementAt(0);
                    }
                    job.perform();
                    if (JobManager.this._debug) {
                        R01FLog.to("r01f.process").info(this._composeDebugInfo(job));
                    }
                    job = null;
                    continue;
                }
                try {
                    if (JobManager.this._debug) {
                        R01FLog.to("r01f.process").finest("dormir > NO hay trabajos para realizar... dormir el thread " + (JobManager.this._maxIdleTime == -1 ? "indefinidamente" : Integer.toString(JobManager.this._maxIdleTime)) + " (sg)");
                    }
                    object = this;
                    synchronized (object) {
                        list = JobManager.this._availableThreads;
                        synchronized (list) {
                            int index = JobManager.this._findMe();
                            if (index == -1) {
                                return;
                            }
                            ((PoolElement)JobManager.this._availableThreads.get((int)index)).idle = true;
                        }
                        if (JobManager.this._maxIdleTime == -1) {
                            this.wait();
                        } else {
                            this.wait(JobManager.this._maxIdleTime);
                        }
                    }
                }
                catch (InterruptedException e) {
                    list = JobManager.this._availableThreads;
                    synchronized (list) {
                        if (JobManager.this._debug) {
                            R01FLog.to("r01f.process").severe("Thread Interrupted!!!");
                        }
                        JobManager.this._removeMe();
                    }
                    return;
                }
                object = JobManager.this._availableThreads;
                synchronized (object) {
                    if (JobManager.this._pendingJobs.size() == 0) {
                        if (JobManager.this._debug) {
                            R01FLog.to("r01f.process").finest("despertar > NO hay trabajos para realizar...devolver el thread al pool");
                        }
                        if (JobManager.this._minThreads == -1 || JobManager.this._availableThreads.size() > JobManager.this._maxThreads) {
                            if (JobManager.this._debug) {
                                R01FLog.to("r01f.process").finest("\t\tel pool esta lleno...>>> Descartarlo!");
                            }
                            JobManager.this._removeMe();
                            return;
                        }
                        if (JobManager.this._debug) {
                            R01FLog.to("r01f.process").finest("\t\tdevolver al pool");
                        }
                    }
                }
            }
        }

        private String _composeDebugInfo(Job theJob) {
            StringBuffer sb = new StringBuffer(367);
            sb.append("Estadisticas de ejecucion del trabajo ");
            sb.append(theJob.getJobId());
            sb.append("\r\n\tEncolado del trabajo     : ");
            sb.append(DateUtils.getDateFormated(new Date(theJob.getJobEnqueuedTimeStamp()), "dd/MM/yyyy [HH:mm:ss:SSSS]"));
            sb.append("\r\n\tComienzo del trabajo     : ");
            sb.append(DateUtils.getDateFormated(new Date(theJob.getJobStartedTimeStamp()), "dd/MM/yyyy [HH:mm:ss:SSSS]"));
            sb.append("\r\n\tFinalizacion del trabajo : ");
            sb.append(DateUtils.getDateFormated(new Date(theJob.getJobPerformedTimeStamp()), "dd/MM/yyyy [HH:mm:ss:SSSS]"));
            sb.append("\r\n\tTiempo desde el encolado hasta el comienzo del trabajo : ");
            sb.append(theJob.getJobStartedTimeStamp() - theJob.getJobEnqueuedTimeStamp());
            sb.append(" milisegundos\r\n\tTiempo total de ejecucion del trabajo                  : ");
            sb.append(theJob.getJobPerformedTimeStamp() - theJob.getJobStartedTimeStamp());
            sb.append(" milisegundos");
            return sb.toString();
        }
    }
}

