/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.net.ssl;

import com.ejie.r01f.util.encoders.BASE64Encoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import sun.net.www.protocol.http.HttpURLConnection;

public class SSLTunnelSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory dfactory;
    private String tunnelHost;
    private int tunnelPort;
    private String proxyUser;
    private String proxyPassword;

    public SSLTunnelSocketFactory(String host, String port, String usr, String pwd) {
        this.proxyUser = usr;
        this.proxyPassword = pwd;
        this.tunnelHost = host;
        this.tunnelPort = Integer.parseInt(port);
        this.dfactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    @Override
    public Socket createSocket(String s, int i) throws IOException, UnknownHostException {
        return this.createSocket(null, s, i, true);
    }

    @Override
    public Socket createSocket(String s, int i, InetAddress inetaddress, int j) throws IOException, UnknownHostException {
        return this.createSocket(null, s, i, true);
    }

    @Override
    public Socket createSocket(InetAddress inetaddress, int i) throws IOException {
        return this.createSocket(null, inetaddress.getHostName(), i, true);
    }

    @Override
    public Socket createSocket(InetAddress inetaddress, int i, InetAddress inetaddress1, int j) throws IOException {
        return this.createSocket(null, inetaddress.getHostName(), i, true);
    }

    @Override
    public Socket createSocket(Socket socket, String s, int i, boolean flag) throws IOException, UnknownHostException {
        Socket socket1 = new Socket(this.tunnelHost, this.tunnelPort);
        this.doTunnelHandshake(socket1, s, i);
        SSLSocket sslsocket = (SSLSocket)this.dfactory.createSocket(socket1, s, i, flag);
        return sslsocket;
    }

    public void setDelegateFactory(SSLSocketFactory sslsocketfactory) {
        this.dfactory = sslsocketfactory;
    }

    public void setProxyAuth(String s, String s1) {
        this.proxyUser = s;
        this.proxyPassword = s1;
    }

    private void doTunnelHandshake(Socket socket, String s, int i) throws IOException {
        String s3;
        byte[] abyte0;
        OutputStream outputstream = socket.getOutputStream();
        String s1 = "";
        if (this.proxyUser != null) {
            s1 = "Proxy-Authorization: Basic " + new BASE64Encoder().encodeBuffer((String.valueOf(this.proxyUser) + ":" + this.proxyPassword).getBytes()) + "\r\n";
        }
        String s2 = "CONNECT " + s + ":" + i + " HTTP/1.0\n" + s1 + "User-Agent: " + HttpURLConnection.userAgent + "\r\n\r\n";
        try {
            abyte0 = s2.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException unsupportedencodingexception) {
            abyte0 = s2.getBytes();
        }
        outputstream.write(abyte0);
        outputstream.flush();
        byte[] abyte1 = new byte[200];
        int j = 0;
        int k = 0;
        boolean flag = false;
        InputStream inputstream = socket.getInputStream();
        while (k < 2) {
            int l = inputstream.read();
            if (l < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (l == 10) {
                flag = true;
                ++k;
                continue;
            }
            if (l == 13) continue;
            k = 0;
            if (flag || j >= abyte1.length) continue;
            abyte1[j++] = (byte)l;
        }
        try {
            s3 = new String(abyte1, 0, j, "ASCII7");
        }
        catch (UnsupportedEncodingException unsupportedencodingexception1) {
            s3 = new String(abyte1, 0, j);
        }
        if (s3.toLowerCase().indexOf(" 200 ") == -1) {
            throw new IOException("Unable to tunnel through " + this.tunnelHost + ":" + this.tunnelPort + ".  Proxy returns \"" + s3 + "\"");
        }
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.dfactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.dfactory.getSupportedCipherSuites();
    }

    public String toString() {
        return "  <SSLTunnelSocketFactory proxyPort=" + this.tunnelPort + " proxyHost=" + this.tunnelHost + " delegate=" + this.dfactory + "/>";
    }
}

