/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.net.proxy;

import com.ejie.r01f.log.R01FLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;

public class SimpleProxyServer {
    public static void main(String[] args) throws IOException {
        try {
            String host = "localhost";
            int remoteport = 7001;
            int localport = 115;
            R01FLog.to("r01f.test").fine("Starting proxy for " + host + ":" + remoteport + " on port " + localport);
            SimpleProxyServer.runServer(host, remoteport, localport);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void runServer(String host, int remoteport, int localport) throws IOException {
        ServerSocket ss = new ServerSocket(localport);
        final byte[] request = new byte[1024];
        byte[] reply = new byte[4096];
        while (true) {
            OutputStream streamToClient;
            InputStream streamFromClient;
            Socket client = null;
            Socket server = null;
            try {
                client = ss.accept();
                streamFromClient = client.getInputStream();
                streamToClient = client.getOutputStream();
                try {
                    server = new Socket(host, remoteport);
                }
                catch (IOException e) {
                    PrintWriter out = new PrintWriter(streamToClient);
                    out.print("Proxy server cannot connect to " + host + ":" + remoteport + ":\n" + e + "\n");
                    out.flush();
                    client.close();
                    try {
                        if (server != null) {
                            server.close();
                        }
                        if (client == null) continue;
                        client.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
            }
            catch (IOException e) {
                System.err.println(e);
                try {
                    if (server != null) {
                        server.close();
                    }
                    if (client == null) continue;
                    client.close();
                }
                catch (IOException iOException) {}
                continue;
            }
            catch (Throwable throwable) {
                try {
                    if (server != null) {
                        server.close();
                    }
                    if (client == null) throw throwable;
                    client.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            {
                InputStream streamFromServer = server.getInputStream();
                final OutputStream streamToServer = server.getOutputStream();
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        try {
                            int bytesRead;
                            while ((bytesRead = streamFromClient.read(request)) != -1) {
                                streamToServer.write(request, 0, bytesRead);
                                streamToServer.flush();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        try {
                            streamToServer.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                };
                t.start();
                int bytesRead = 0;
                try {
                    while ((bytesRead = streamFromServer.read(reply)) != -1) {
                        streamToClient.write(reply, 0, bytesRead);
                        streamToClient.flush();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                streamToClient.close();
            }
            try {
                if (server != null) {
                    server.close();
                }
                if (client == null) continue;
                client.close();
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }
}

