/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.net;

import com.ejie.r01f.net.BaseNetRequest;
import com.ejie.r01f.net.ssl.SSLTunnelSocketFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import javax.net.ssl.SSLSocketFactory;

public class HttpsRequest
extends BaseNetRequest {
    static boolean _streamHandlerSet = false;
    static String _httpsDefaultClass = "javax.net.ssl.HttpsURLConnection";
    static String _httpsSunClass = "com.sun.net.ssl.HttpsURLConnection";
    static String _httpsIBMClass = "com.ibm.net.ssl.HttpsURLConnection";
    static String _sunURLHandler = "com.sun.net.ssl.internal.www.protocol.https.Handler";
    static String _ibmURLHandler = "com.ibm.net.ssl.internal.www.protocol.https.Handler";

    public HttpsRequest() {
    }

    public HttpsRequest(String inURLStr) throws MalformedURLException {
        super(inURLStr);
        if (this.jdkVersionHigher5) {
            try {
                System.setProperty("proxySet", "");
                System.setProperty("http.proxyHost", "");
                System.setProperty("http.proxyPort", "");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public HttpsRequest(String inURLStr, String proxyHost, String proxyPort) throws MalformedURLException {
        super(inURLStr);
        this.setURL(inURLStr);
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        if (this.jdkVersionHigher5) {
            if (proxyHost != null && !"".equals(proxyHost)) {
                try {
                    System.setProperty("proxySet", "true");
                    System.setProperty("https.proxyHost", proxyHost);
                    System.setProperty("https.proxyPort", proxyPort);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            } else {
                try {
                    System.setProperty("proxySet", "");
                    System.setProperty("http.proxyHost", "");
                    System.setProperty("http.proxyPort", "");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void setURL(String inURLStr) throws MalformedURLException {
        URL urlWrapped;
        URLStreamHandler streamHandler;
        try {
            streamHandler = this.getURLStreamHandler();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MalformedURLException(e.getMessage());
        }
        this._targetURL = urlWrapped = new URL(null, inURLStr, streamHandler);
    }

    @Override
    public HttpURLConnection getConnection(URL url) throws IOException {
        URLConnection urlc = url.openConnection();
        if (this.proxyHost != null) {
            if (this.isHttpsDefaultClassInstance(urlc.getClass())) {
                Class[] argType = new Class[]{SSLSocketFactory.class};
                Object[] argValue = new Object[]{new SSLTunnelSocketFactory(this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPW)};
                Method setSSLMethod = this.getSSLMethodByClassName(_httpsDefaultClass, argType);
                try {
                    setSSLMethod.invoke((Object)urlc, argValue);
                }
                catch (Exception e) {
                    throw new IOException("Error al establecer SSLTunnelSocketFactory : " + e.getMessage());
                }
            }
            if (this.isSunClassInstance(urlc.getClass())) {
                Class[] argType = new Class[]{SSLSocketFactory.class};
                Object[] argValue = new Object[]{new SSLTunnelSocketFactory(this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPW)};
                Method setSSLMethod = this.getSSLMethodByClassName(_httpsSunClass, argType);
                try {
                    setSSLMethod.invoke((Object)urlc, argValue);
                }
                catch (Exception e) {
                    System.getProperties().list(System.err);
                    throw new IOException("Error al establecer SSLTunnelSocketFactory : " + _httpsSunClass + " of " + urlc.getClass().getName() + e.getMessage());
                }
            }
            URLStreamHandler streamHandler = this.getURLStreamHandler();
            URL urlWrapped = new URL(url, url.toExternalForm(), streamHandler);
            URLConnection urlConnWrapped = urlWrapped.openConnection();
            Class[] argType = new Class[]{SSLSocketFactory.class};
            Object[] argValue = new Object[]{new SSLTunnelSocketFactory(this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPW)};
            Method setSSLMethod = this.getCustomSSLMethod(argType);
            try {
                setSSLMethod.invoke((Object)urlConnWrapped, argValue);
            }
            catch (Exception e) {
                System.getProperties().list(System.err);
                throw new IOException("Error al establecer SSLTunnelSocketFactory : " + e.getMessage());
            }
            return (HttpURLConnection)urlConnWrapped;
        }
        return (HttpURLConnection)urlc;
    }

    private void _loadStreamHandler() {
        if (!_streamHandlerSet) {
            _streamHandlerSet = false;
            String szVendor = System.getProperty("java.vendor");
            String szVersion = System.getProperty("java.version");
            Double dVersion = new Double(szVersion.substring(0, 3));
            if (-1 < szVendor.indexOf("Microsoft")) {
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    Class<?> clsFactory = cl.loadClass("com.ms.net.wininet.WininetStreamHandlerFactory");
                    if (clsFactory != null) {
                        URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)clsFactory.newInstance());
                    }
                    _streamHandlerSet = true;
                }
                catch (ClassNotFoundException cl) {
                }
                catch (InstantiationException cl) {
                }
                catch (IllegalAccessException cl) {
                }
                catch (Exception cl) {}
            } else if (1.2 <= dVersion) {
                String JSSE_HANDLER = "com.sun.net.ssl.internal.www.protocol";
                String WLS_HANDLER = "weblogic.net";
                String handler = System.getProperty("weblogic.class.path") != null ? "weblogic.net" : "com.sun.net.ssl.internal.www.protocol";
                Properties sysProps = System.getProperties();
                String handlerValue = sysProps.getProperty("java.protocol.handler.pkgs");
                if (handlerValue == null) {
                    handlerValue = handler;
                } else if (handlerValue.indexOf(handler) == -1) {
                    handlerValue = String.valueOf(handlerValue) + "|" + handler;
                }
                sysProps.put("java.protocol.handler.pkgs", handlerValue);
                System.setProperties(sysProps);
                if (handler.equals("weblogic.net")) {
                    return;
                }
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    Class<?> clsFactory = cl.loadClass("com.sun.net.ssl.internal.ssl.Provider");
                    if (clsFactory != null && Security.getProvider("SunJSSE") == null) {
                        Security.addProvider((Provider)clsFactory.newInstance());
                    }
                    _streamHandlerSet = true;
                }
                catch (ClassNotFoundException cfe) {
                    throw new RuntimeException("No se ha podido cargar el Stream Handler de J2EE, verifica que la clase com.sun.net.ssl.internal.ssl.Provider esta accesible en el classpath" + cfe.getMessage());
                }
                catch (InstantiationException instEx) {
                    throw new RuntimeException("No se puede instanciar el Stream Handler SSL de de J2EE: " + instEx.getMessage());
                }
                catch (IllegalAccessException illAccEx) {
                    throw new RuntimeException("Aceso ilegal al Stream Handler SSL de J2EE: " + illAccEx.getMessage());
                }
                catch (Exception ex) {
                    throw new RuntimeException("Error: " + ex.getMessage());
                }
            }
        }
    }

    private boolean isHttpsDefaultClassInstance(Class classInstance) {
        try {
            Class<?> httpsDefaultClass = Class.forName(_httpsDefaultClass);
            return httpsDefaultClass.isAssignableFrom(classInstance);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean isSunClassInstance(Class classInstance) {
        try {
            Class<?> httpsDefaultClass = Class.forName(_httpsSunClass);
            return httpsDefaultClass.isAssignableFrom(classInstance);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean isIBMClassInstance(Class classInstance) {
        try {
            Class<?> httpsDefaultClass = Class.forName(_httpsIBMClass);
            return httpsDefaultClass.isAssignableFrom(classInstance);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private Method getSSLMethodByClassName(String className, Class[] argType) throws IOException {
        try {
            return Class.forName(className).getMethod("setSSLSocketFactory", argType);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new IOException("getSSLMethodByClassNameclassName:" + className + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new IOException("getSSLMethodByClassNameclassName:" + className + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new IOException("getSSLMethodByClassNameclassName:" + className + e.getMessage());
        }
    }

    /*
     * Loose catch block
     */
    private Method getCustomSSLMethod(Class[] argType) throws IOException {
        String szVendor;
        block6: {
            szVendor = System.getProperty("java.vendor");
            Object streamHandler = null;
            if (-1 < szVendor.indexOf("SUN")) {
                return this.getSSLMethodByClassName(_httpsSunClass, argType);
            }
            if (-1 >= szVendor.indexOf("IBM")) break block6;
            return this.getSSLMethodByClassName(_httpsIBMClass, argType);
            {
                catch (IOException e) {
                    throw e;
                }
            }
        }
        try {
            return this.getSSLMethodByClassName(_httpsSunClass, argType);
        }
        catch (IOException e) {
            e.printStackTrace();
            Properties prop = System.getProperties();
            prop.list(System.err);
            IOException ioex = new IOException("JAVA VENDOR UNKNOWN!! :" + szVendor);
            throw ioex;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private URLStreamHandler getURLStreamHandler() throws IOException {
        String szVendor = System.getProperty("java.vendor");
        try {
            if (-1 < szVendor.indexOf("Sun")) {
                return (URLStreamHandler)Class.forName(_sunURLHandler).newInstance();
            }
            if (-1 < szVendor.indexOf("IBM")) {
                return (URLStreamHandler)Class.forName(_ibmURLHandler).newInstance();
            }
            {
                catch (ClassNotFoundException e) {
                    throw new IOException(e.getMessage());
                }
                try {
                    return (URLStreamHandler)Class.forName(_sunURLHandler).newInstance();
                }
                catch (ClassNotFoundException e) {}
                {
                    e.printStackTrace();
                    Properties prop = System.getProperties();
                    prop.list(System.err);
                    IOException ioex = new IOException("JAVA VENDOR UNKNOWN!! :" + szVendor);
                    throw ioex;
                }
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IOException(e.getMessage());
        }
    }
}

