/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.mail;

import com.ejie.r01f.util.StringUtils;
import java.io.File;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class MailComposer {
    public static final String CONTENT_TYPE_HTML = "text/html";
    public static final String CONTENT_TYPE_TEXT = "text/plain";
    String _smtpHost = null;
    String _debug = "false";

    public MailComposer() {
    }

    public MailComposer(String smtpHost, boolean debug) {
        this._smtpHost = smtpHost;
        this._debug = debug ? "true" : "false";
    }

    public void sendMessage(String from, String to, String subject, String messageContentType, String messageText, String[] attachListFileNames) throws AddressException, MessagingException {
        if (StringUtils.isEmptyString(this._smtpHost)) {
            throw new MessagingException("NO se puede enviar el mensaje JavaMail: NO se ha especificado el servidor SMTP");
        }
        if (StringUtils.isEmptyString(to)) {
            throw new MessagingException("NO se puede enviar el mensaje JavaMail: NO se ha especificado destinatario!");
        }
        Properties props = new Properties();
        props.put("mail.smtp.host", this._smtpHost);
        props.put("mail.debug", this._debug);
        Session sesion = Session.getInstance((Properties)props, null);
        sesion.setDebug(false);
        MimeMessage message = new MimeMessage(sesion);
        InternetAddress addr = new InternetAddress(to);
        message.addRecipients(Message.RecipientType.TO, (Address[])new InternetAddress[]{addr});
        InternetAddress from_addr = new InternetAddress(from);
        message.setFrom((Address)from_addr);
        message.setSubject(subject);
        MimeMultipart mp = new MimeMultipart("related");
        MimeBodyPart textMP = new MimeBodyPart();
        textMP.setDisposition("inline");
        textMP.setContent((Object)messageText, messageContentType);
        mp.addBodyPart((BodyPart)textMP);
        if (attachListFileNames != null) {
            int i = 0;
            while (i < attachListFileNames.length) {
                MimeBodyPart file_part = new MimeBodyPart();
                File file = new File(attachListFileNames[i]);
                FileDataSource fds = new FileDataSource(file);
                DataHandler dh = new DataHandler((DataSource)fds);
                file_part.setFileName(file.getName());
                file_part.setDisposition("attachment");
                file_part.setDataHandler(dh);
                mp.addBodyPart((BodyPart)file_part);
                ++i;
            }
        }
        message.setContent((Multipart)mp);
        Transport.send((Message)message);
        if (attachListFileNames != null && attachListFileNames.length > 0) {
            this._deleteTempFiles(attachListFileNames);
        }
    }

    public String getSMTPHost() {
        return this._smtpHost;
    }

    public void setSMTPHost(String host) {
        this._smtpHost = host;
    }

    private void _deleteTempFiles(String[] attachList) {
        int i = 0;
        while (i < attachList.length) {
            File file = new File(attachList[i]);
            file.delete();
            ++i;
        }
    }
}

