/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.log;

import com.ejie.r01f.log.FileHandler;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLExternalProperties;
import com.ejie.r01f.xmlproperties.XMLProperties;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class R01FLog
extends Logger {
    private static Map _appsLogLevels = new Hashtable();

    static {
        AppLogDef appLogDef = (AppLogDef)_appsLogLevels.get("r01f");
        if (appLogDef == null) {
            appLogDef = new AppLogDef("r01f");
            _appsLogLevels.put("r01f", appLogDef);
        }
        Logger.global.setLevel(appLogDef.level);
    }

    public R01FLog(String name, String resourceBundleName) {
        super(name, resourceBundleName);
    }

    public static synchronized void reset() {
        LogManager manager = LogManager.getLogManager();
        manager.reset();
        _appsLogLevels = new Hashtable();
    }

    public static Logger getLogger(String name) {
        return R01FLog._obtainLogger(name);
    }

    public static Logger to(String name) {
        return R01FLog.getLogger(name);
    }

    public static Level getLogLevel(String name) {
        String[] appCodeAndComp = R01FLog._extractAppCodeAndComponentName(name);
        return R01FLog.getLogLevel(appCodeAndComp[0], appCodeAndComp[1]);
    }

    public static Level getLogLevel(String appCode, String component) {
        AppLogDef appLogDef = R01FLog.getApplicationLogDef(appCode);
        CompLogDef compLogDef = R01FLog.getComponentLogDef(appCode, component);
        return R01FLog.getLogLevel(appLogDef, compLogDef);
    }

    public static Level getLogLevel(AppLogDef appLogDef, CompLogDef compLogDef) {
        Level effectiveLogLevel = null;
        effectiveLogLevel = compLogDef != null ? R01FLog._obtainPreferencedLevel(appLogDef, compLogDef) : appLogDef.level;
        return effectiveLogLevel;
    }

    public static AppLogDef getApplicationLogDef(String appCode) {
        AppLogDef appLogDef = (AppLogDef)_appsLogLevels.get(appCode);
        if (appLogDef == null) {
            appLogDef = new AppLogDef(appCode);
            _appsLogLevels.put(appCode, appLogDef);
        }
        return appLogDef;
    }

    public static CompLogDef getComponentLogDef(String appCode, String component) {
        AppLogDef appLogDef = R01FLog.getApplicationLogDef(appCode);
        if (component != null && appLogDef.componentLogLevels != null) {
            return (CompLogDef)appLogDef.componentLogLevels.get(component);
        }
        Logger.global.warning("No se ha definido el componente " + component + " en la seccion de log del fichero de properties de la aplicacion " + appCode);
        return null;
    }

    private static Logger _obtainLogger(String name) {
        if (name == null) {
            return Logger.global;
        }
        String[] appCodeAndComp = R01FLog._extractAppCodeAndComponentName(name);
        AppLogDef appLogDef = R01FLog.getApplicationLogDef(appCodeAndComp[0]);
        CompLogDef compLogDef = R01FLog.getComponentLogDef(appCodeAndComp[0], appCodeAndComp[1]);
        String loggerName = appCodeAndComp[1] == null || compLogDef == null ? appCodeAndComp[0] : name;
        Level effectiveLogLevel = R01FLog.getLogLevel(appLogDef, compLogDef);
        LogManager manager = LogManager.getLogManager();
        Logger logger = manager.getLogger(loggerName);
        if (logger == null) {
            logger = Logger.getLogger(loggerName);
            logger.setLevel(effectiveLogLevel);
            if (appLogDef.handler == null || appLogDef.handler.equalsIgnoreCase("CONSOLE")) {
                logger.setUseParentHandlers(false);
                ConsoleHandler consoleHndlr = new ConsoleHandler();
                logger.addHandler(consoleHndlr);
            } else if (appLogDef.handler.equalsIgnoreCase("FILE")) {
                String logFileName = (String)appLogDef.handlerProperties.get("fileName");
                try {
                    FileHandler fileHndlr;
                    if (logFileName != null && (fileHndlr = new FileHandler(logFileName, true)) != null) {
                        logger.addHandler(fileHndlr);
                    }
                }
                catch (IOException ioEx) {
                    Logger.global.warning("Error al abrir el FileHandler de log: '" + logFileName + "'");
                }
            } else {
                appLogDef.handler.equalsIgnoreCase("SOCKET");
            }
            R01FLog._setLogFormatter(logger, appLogDef.formatter);
        }
        return logger;
    }

    private static Level _obtainPreferencedLevel(AppLogDef appLogDef, CompLogDef compLogDef) {
        if (compLogDef.ignoreGlobal) {
            return compLogDef.level;
        }
        if (appLogDef.level.intValue() > compLogDef.level.intValue()) {
            return appLogDef.level;
        }
        return compLogDef.level;
    }

    private static void _setLogFormatter(Logger logger, String formatterClassName) {
        if (formatterClassName == null) {
            return;
        }
        if (logger == null) {
            return;
        }
        Handler[] handlers = logger.getHandlers();
        if (handlers != null && handlers.length > 0) {
            try {
                int i = 0;
                while (i < handlers.length) {
                    handlers[i].setFormatter((Formatter)ReflectionUtils.getObjectInstance(formatterClassName));
                    ++i;
                }
            }
            catch (ReflectionException refEx) {
                R01FLog.to("r01f.test").fine("\r\n\r\nERROR AL CARGAR LA CLASE DE FORMATEO '" + formatterClassName + "'\r\n\r\n\r\n");
            }
        } else {
            R01FLog._setLogFormatter(logger.getParent(), formatterClassName);
        }
    }

    private static String[] _extractAppCodeAndComponentName(String name) {
        StringTokenizer st = new StringTokenizer(name, ".");
        String appCode = st.nextToken();
        String component = st.hasMoreTokens() ? st.nextToken() : null;
        return new String[]{appCode, component};
    }

    private static class AppLogDef {
        public String appCode;
        public String handler;
        public String formatter;
        public Map handlerProperties;
        public Level level;
        public Map componentLogLevels;

        public AppLogDef() {
        }

        public AppLogDef(String newAppCode) {
            this.appCode = newAppCode;
            if (!this.load()) {
                this.level = Level.ALL;
            }
            if (this.handler == null) {
                this.handler = "CONSOLE";
            }
            if (this.handler.equals("FILE")) {
                this.handlerProperties = new HashMap();
                String fileName = XMLProperties.get(newAppCode, "log/handler/property");
                if (fileName == null || fileName.equalsIgnoreCase("")) {
                    this.handlerProperties.put("fileName", "%tR01H%u.log");
                } else {
                    GregorianCalendar calendar = new GregorianCalendar();
                    SimpleDateFormat sdfFormat = new SimpleDateFormat("yyyyMMdd");
                    String strDirToday = sdfFormat.format(calendar.getTime()).toString();
                    fileName = StringUtils.replaceString(fileName, "[dateCode]", strDirToday);
                    fileName = StringUtils.replaceString(fileName, "[appCode]", newAppCode.substring(0, 3));
                    fileName = StringUtils.replaceString(fileName, "[entityCode]", newAppCode);
                    File f = new File(fileName);
                    boolean bDirCreado = new File(f.getParent()).mkdirs();
                    this.handlerProperties.put("fileName", fileName);
                }
            }
        }

        public boolean load() {
            NodeList nl;
            Node appLogDefNode = null;
            String storage = XMLProperties.get(this.appCode, "log[@storage]/@storage");
            if (storage != null) {
                XMLExternalProperties props = new XMLExternalProperties(storage);
                appLogDefNode = props.getPropertyNode(this.appCode, "/log");
            } else {
                appLogDefNode = XMLProperties.getPropertyNode(this.appCode, "/log");
            }
            if (appLogDefNode == null) {
                return false;
            }
            NamedNodeMap attrs = appLogDefNode.getAttributes();
            if (attrs != null && attrs.getNamedItem("level") != null) {
                this.level = this._parseLevel(attrs.getNamedItem("level").getNodeValue().trim());
            }
            if ((nl = appLogDefNode.getChildNodes()) != null) {
                Node currNode = null;
                int i = 0;
                while (i < nl.getLength()) {
                    currNode = nl.item(i);
                    if (currNode.getNodeName().equals("handler")) {
                        attrs = currNode.getAttributes();
                        if (attrs != null && attrs.getNamedItem("id") != null) {
                            this.handler = attrs.getNamedItem("id").getNodeValue();
                            NodeList pl = currNode.getChildNodes();
                            if (pl != null) {
                                Node currPropNode = null;
                                int j = 0;
                                while (j < pl.getLength()) {
                                    currPropNode = pl.item(j);
                                    if (currPropNode.getNodeName().equals("property") && (attrs = currPropNode.getAttributes()) != null && attrs.getNamedItem("id") != null) {
                                        if (this.handlerProperties == null) {
                                            this.handlerProperties = new HashMap();
                                        }
                                        this.handlerProperties.put(attrs.getNamedItem("id").getNodeValue(), currPropNode.getNodeValue());
                                    }
                                    ++j;
                                }
                            }
                        }
                    } else if (currNode.getNodeName().equals("formatter")) {
                        if (currNode.getFirstChild() != null) {
                            this.formatter = currNode.getFirstChild().getNodeValue();
                        }
                    } else if (currNode.getNodeName().equals("component")) {
                        String currComponentName = null;
                        String currComponentLogLevel = null;
                        String currComponentIgnoreGlobal = null;
                        attrs = currNode.getAttributes();
                        if (attrs != null) {
                            if (attrs.getNamedItem("level") != null) {
                                currComponentName = attrs.getNamedItem("name").getNodeValue().trim();
                            }
                            if (attrs.getNamedItem("level") != null) {
                                currComponentLogLevel = attrs.getNamedItem("level").getNodeValue().trim();
                            }
                            if (attrs.getNamedItem("ignoreGlobal") != null) {
                                currComponentIgnoreGlobal = attrs.getNamedItem("ignoreGlobal").getNodeValue().trim();
                            }
                            if (currComponentName != null && currComponentName.length() > 0) {
                                if (this.componentLogLevels == null) {
                                    this.componentLogLevels = new HashMap();
                                }
                                CompLogDef componentLogDef = new CompLogDef();
                                componentLogDef.name = currComponentName;
                                componentLogDef.level = this._parseLevel(currComponentLogLevel);
                                componentLogDef.ignoreGlobal = currComponentIgnoreGlobal != null && "true".equals(currComponentIgnoreGlobal);
                                this.componentLogLevels.put(componentLogDef.name, componentLogDef);
                            }
                        }
                    }
                    ++i;
                }
            }
            return true;
        }

        private Level _parseLevel(String theLevel) {
            if (StringUtils.isEmptyString(theLevel)) {
                return Level.ALL;
            }
            try {
                return Level.parse(theLevel);
            }
            catch (Exception exception) {
                return Level.ALL;
            }
        }
    }

    static class CompLogDef {
        public String name = null;
        public boolean ignoreGlobal = false;
        public Level level = Level.ALL;

        CompLogDef() {
        }
    }
}

