/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.log;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import java.util.logging.XMLFormatter;

public class FileHandler
extends StreamHandler {
    private MeteredStream meter;
    private boolean append;
    private int limit;
    private int count;
    private String pattern;
    private String lockFileName;
    private FileOutputStream lockStream;
    private File[] files;
    private static final int MAX_LOCKS = 10000;
    private static HashMap locks = new HashMap();
    private LogManager manager = LogManager.getLogManager();

    private void open(File fname, boolean append) throws IOException {
        int len = 0;
        if (append) {
            len = (int)fname.length();
        }
        FileOutputStream fout = new FileOutputStream(fname.toString(), append);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        this.meter = new MeteredStream(bout, len);
        this.setOutputStream(this.meter);
    }

    private void configure() {
        String cname = this.getClass().getName();
        String patternProperty = this.manager.getProperty(String.valueOf(cname) + ".pattern");
        try {
            this.pattern = patternProperty == null ? "%h/java%u.log" : patternProperty;
            String countProperty = this.manager.getProperty(String.valueOf(cname) + ".count");
            this.count = countProperty == null ? 1 : Integer.parseInt(countProperty);
            String limitProperty = this.manager.getProperty(String.valueOf(cname) + ".limit");
            this.limit = limitProperty == null ? 0 : Integer.parseInt(limitProperty);
            String appendProperty = this.manager.getProperty(String.valueOf(cname) + ".append");
            this.append = appendProperty == null ? false : Boolean.getBoolean(appendProperty);
            String levelProperty = this.manager.getProperty(String.valueOf(cname) + ".level");
            if (levelProperty == null) {
                this.setLevel(Level.ALL);
            } else {
                this.setLevel(Level.parse(levelProperty));
            }
            String formatterProperty = this.manager.getProperty(String.valueOf(cname) + ".formatter");
            if (formatterProperty == null) {
                this.setFormatter(new XMLFormatter());
            } else {
                this.setFormatter((Formatter)ClassLoader.getSystemClassLoader().loadClass(formatterProperty).newInstance());
            }
            String encodingProperty = this.manager.getProperty(String.valueOf(cname) + ".formatter");
            if (encodingProperty == null) {
                this.setEncoding(null);
            } else {
                this.setEncoding(encodingProperty);
            }
            String filterProperty = this.manager.getProperty(String.valueOf(cname) + ".filter");
            if (filterProperty == null) {
                this.setFilter(null);
            } else {
                this.setFilter((Filter)ClassLoader.getSystemClassLoader().loadClass(filterProperty).newInstance());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public FileHandler() throws IOException, SecurityException {
        this.checkAccess();
        this.configure();
        this.openFiles();
    }

    public FileHandler(String pattern) throws IOException, SecurityException {
        if (pattern.length() < 1) {
            throw new IllegalArgumentException();
        }
        this.checkAccess();
        this.configure();
        this.pattern = pattern;
        this.limit = 0;
        this.count = 1;
        this.openFiles();
    }

    public FileHandler(String pattern, boolean append) throws IOException, SecurityException {
        if (pattern.length() < 1) {
            throw new IllegalArgumentException();
        }
        this.checkAccess();
        this.configure();
        this.pattern = pattern;
        this.limit = 0;
        this.count = 1;
        this.append = append;
        this.openFiles();
    }

    public FileHandler(String pattern, int limit, int count) throws IOException, SecurityException {
        if (limit < 0 || count < 1 || pattern.length() < 1) {
            throw new IllegalArgumentException();
        }
        this.checkAccess();
        this.configure();
        this.pattern = pattern;
        this.limit = limit;
        this.count = count;
        this.openFiles();
    }

    public FileHandler(String pattern, int limit, int count, boolean append) throws IOException, SecurityException {
        if (limit < 0 || count < 1 || pattern.length() < 1) {
            throw new IllegalArgumentException();
        }
        this.checkAccess();
        this.configure();
        this.pattern = pattern;
        this.limit = limit;
        this.count = count;
        this.append = append;
        this.openFiles();
    }

    /*
     * Exception decompiling
     */
    private void openFiles() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private File generate(String pattern, int generation, int unique) throws IOException {
        File file = null;
        String word = "";
        int ix = 0;
        boolean sawg = false;
        boolean sawu = false;
        while (ix < pattern.length()) {
            char ch = pattern.charAt(ix);
            char ch2 = '\u0000';
            if (++ix < pattern.length()) {
                ch2 = Character.toLowerCase(pattern.charAt(ix));
            }
            if (ch == '/') {
                file = file == null ? new File(word) : new File(file, word);
                word = "";
                continue;
            }
            if (ch == '%') {
                if (ch2 == 't') {
                    String tmpDir = System.getProperty("java.io.tmpdir");
                    if (tmpDir == null) {
                        tmpDir = System.getProperty("user.home");
                    }
                    file = new File(tmpDir);
                    ++ix;
                    word = "";
                    continue;
                }
                if (ch2 == 'h') {
                    file = new File(System.getProperty("user.home"));
                    if (FileHandler.isSetUID()) {
                        throw new IOException("can't use %h in set UID program");
                    }
                    ++ix;
                    word = "";
                    continue;
                }
                if (ch2 == 'g') {
                    word = String.valueOf(word) + generation;
                    sawg = true;
                    ++ix;
                    continue;
                }
                if (ch2 == 'u') {
                    word = String.valueOf(word) + unique;
                    sawu = true;
                    ++ix;
                    continue;
                }
                if (ch2 == '%') {
                    word = String.valueOf(word) + "%";
                    ++ix;
                    continue;
                }
            }
            word = String.valueOf(word) + ch;
        }
        if (this.count > 1 && !sawg) {
            word = String.valueOf(word) + "." + generation;
        }
        if (unique > 0 && !sawu) {
            word = String.valueOf(word) + "." + unique;
        }
        if (word.length() > 0) {
            file = file == null ? new File(word) : new File(file, word);
        }
        return file;
    }

    private synchronized void rotate() {
        Level oldLevel = this.getLevel();
        this.setLevel(Level.OFF);
        super.close();
        int i = this.count - 2;
        while (i >= 0) {
            File f1 = this.files[i];
            File f2 = this.files[i + 1];
            if (f1.exists()) {
                if (f2.exists()) {
                    f2.delete();
                }
                f1.renameTo(f2);
            }
            --i;
        }
        try {
            this.open(this.files[0], false);
        }
        catch (IOException ix) {
            this.reportError(null, ix, 4);
        }
        this.setLevel(oldLevel);
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        super.publish(record);
        this.flush();
        if (this.limit > 0 && this.meter.written >= this.limit) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    FileHandler.this.rotate();
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SecurityException {
        super.close();
        if (this.lockFileName == null) {
            return;
        }
        try {
            this.lockStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap hashMap = locks;
        synchronized (hashMap) {
            locks.remove(this.lockFileName);
        }
        new File(this.lockFileName).delete();
        this.lockFileName = null;
        this.lockStream = null;
    }

    private static native boolean isSetUID();

    void checkAccess() throws SecurityException {
        this.manager.checkAccess();
    }

    private static class InitializationErrorManager
    extends ErrorManager {
        Exception lastException;

        private InitializationErrorManager() {
        }

        @Override
        public void error(String msg, Exception ex, int code) {
            this.lastException = ex;
        }
    }

    private class MeteredStream
    extends OutputStream {
        OutputStream out;
        int written;

        MeteredStream(OutputStream out, int written) {
            this.out = out;
            this.written = written;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.written;
        }

        @Override
        public void write(byte[] buff) throws IOException {
            this.out.write(buff);
            this.written += buff.length;
        }

        @Override
        public void write(byte[] buff, int off, int len) throws IOException {
            this.out.write(buff, off, len);
            this.written += len;
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }
}

