/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.jvt.test;

import com.ejie.r01f.clone.CloneUtils;
import com.ejie.r01f.io.BytesInputStream;
import com.ejie.r01f.jvt.JVTComparator;
import com.ejie.r01f.jvt.test.Clase1;
import com.ejie.r01f.jvt.test.Clase2;
import com.ejie.r01f.jvt.test.Clase3;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xml.marshalling.XOMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.xml.sax.SAXException;

public class Test {
    public static void main(String[] args) {
        try {
            int testTimes = 1;
            long t1 = System.currentTimeMillis();
            int times = 0;
            while (times < testTimes) {
                Clase1 cS1 = Test._composeTestObj();
                Clase1 cS2 = Test._alterTestObj(cS1);
                R01FLog.to("r01f.test").fine("\r\n\r\n...Preparacion OK!!\r\n\r\n");
                JVTComparator comp = new JVTComparator(Test._loadXOMap(), cS1, cS2);
                List plan = comp.getPlanTable();
                R01FLog.to("r01f.test").fine(JVTComparator.composeDebugInfo(plan));
                ++times;
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to("r01f.test").fine("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg - " + (t2 - t1) + "msg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static Clase1 _composeTestObj() {
        Clase1 c1 = new Clase1("c1", "Valor del miembro", new HashMap());
        Clase2 c2_1 = new Clase2("c2_1", "miembro2_1", new ArrayList());
        Clase3 c3_1 = new Clase3("a", 1);
        Clase3 c3_2 = new Clase3("b", 2);
        c2_1.lista.add(c3_1);
        c2_1.lista.add(c3_2);
        c1.mapa.put(c2_1.oid, c2_1);
        Clase2 c2_2 = new Clase2("c2_2", "miembro2_2", new ArrayList());
        c1.mapa.put(c2_2.oid, c2_2);
        return c1;
    }

    private static Clase1 _alterTestObj(Clase1 c1) {
        Clase1 c2 = (Clase1)CloneUtils.cloneByReflection(c1);
        c2.mapa.remove("c2_2");
        Clase2 c2_1 = (Clase2)c2.mapa.get("c2_1");
        c2_1.lista.add(new Clase3("c", 3));
        c2_1.lista.remove(0);
        Clase2 c2_3 = new Clase2("c2_3", "miembro2_3", new ArrayList());
        c2.mapa.put(c2_3.oid, c2_3);
        return c2;
    }

    private static XOMap _loadXOMap() throws SAXException {
        XOMap xoMap = new XOMap();
        xoMap.loadFromXML(new BytesInputStream(Test._composeMappingXML().getBytes()));
        return xoMap;
    }

    private static String _composeMappingXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<classes>");
        sb.append("     <class name='Clase1' package='com.ejie.r01f.jvt.test' fromElement='clase1' useAccessors='false'>");
        sb.append("         <member name='oid' dataType='String' fromElement='oid' isOID='true'/>");
        sb.append("         <member name='miembro' dataType='String' fromElement='miembro' />");
        sb.append("         <member name='mapa' collection='Map' dataType='Clase2' relation='composition' fromElement='mapa' />");
        sb.append("     </class>");
        sb.append("     <class name='Clase2' package='com.ejie.r01f.jvt.test' fromElement='clase2' useAccessors='false'>");
        sb.append("         <member name='oid' dataType='String' fromAttribute='oid' isOID='true'/>");
        sb.append("         <member name='miembro' dataType='String' fromElement='miembro' />");
        sb.append("         <member name='lista' collection='List' dataType='Clase3' relation='composition' fromElement='lista' />");
        sb.append("     </class>");
        sb.append("     <class name='Clase3' package='com.ejie.r01f.jvt.test' fromElement='clase3' useAccessors='false'>");
        sb.append("         <member name='oid' dataType='String' fromAttribute='oid' isOID='true'/>");
        sb.append("         <member name='primitive' dataType='int' fromElement='primitive' />");
        sb.append("     </class>");
        sb.append("</classes>");
        return sb.toString();
    }
}

