/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.io.filters;

import com.ejie.r01f.io.filters.BufferEventListener;
import com.ejie.r01f.io.filters.CircularCharBuffer;
import com.ejie.r01f.io.filters.DirectiveListener;
import com.ejie.r01f.log.R01FLog;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegExpDirectiveFilterReader
extends Reader {
    private List _directiveListeners = null;
    private List _regExps = null;
    private int _maxDirectiveLength = 255;
    private Reader _in;
    private CircularCharBuffer _regExCircularBuff;
    private CircularCharBuffer _outCircularBuff;
    private boolean _circularCharBufferFull = false;

    public RegExpDirectiveFilterReader(Reader newIn) {
        this._in = newIn;
        this._regExCircularBuff = new CircularCharBuffer(false);
        this._outCircularBuff = new CircularCharBuffer(false);
    }

    public RegExpDirectiveFilterReader(Reader newIn, int bufferSize) {
        this._in = newIn;
        this._regExCircularBuff = new CircularCharBuffer(bufferSize, false);
        this._outCircularBuff = new CircularCharBuffer(false);
    }

    public RegExpDirectiveFilterReader(Reader newIn, int bufferSize, int newMaxDirectiveLength) {
        this(newIn, bufferSize);
        this._maxDirectiveLength = newMaxDirectiveLength;
    }

    public void addListener(String regExp, DirectiveListener listener) {
        if (this._directiveListeners == null) {
            this._directiveListeners = new ArrayList();
        }
        this._directiveListeners.add(listener);
        if (this._regExps == null) {
            this._regExps = new ArrayList();
        }
        this._regExps.add(regExp);
    }

    public CircularCharBuffer getBuffer() {
        return this._regExCircularBuff;
    }

    @Override
    public void close() throws IOException {
        this._in.close();
        this._regExCircularBuff.writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        RegExpDirectiveFilterReader regExpDirectiveFilterReader = this;
        synchronized (regExpDirectiveFilterReader) {
            if (this._outCircularBuff.isEmpty()) {
                this._fillCircularBuffer();
            }
            return this._outCircularBuff.getReader().read();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cbuf) throws IOException {
        RegExpDirectiveFilterReader regExpDirectiveFilterReader = this;
        synchronized (regExpDirectiveFilterReader) {
            if (this._outCircularBuff.isEmpty()) {
                this._fillCircularBuffer();
            }
            return this._outCircularBuff.getReader().read(cbuf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        RegExpDirectiveFilterReader regExpDirectiveFilterReader = this;
        synchronized (regExpDirectiveFilterReader) {
            if (this._outCircularBuff.isEmpty()) {
                this._fillCircularBuffer();
            }
            return this._outCircularBuff.getReader().read(cbuf, off, len);
        }
    }

    private int _fillCircularBuffer() throws IOException {
        int availableToRead = this._regExCircularBuff.getSpaceLeft();
        char[] tmpBuff = new char[availableToRead];
        int charsReaded = this._in.read(tmpBuff);
        if (charsReaded > 0) {
            this._regExCircularBuff.getWriter().write(tmpBuff);
            this._processCircularBuffer();
        } else {
            R01FLog.to("r01f.test").fine("...cerrando...");
            this._regExCircularBuff.getWriter().close();
        }
        return charsReaded;
    }

    private void _processCircularBuffer() throws IOException {
        Pattern p = Pattern.compile("caracola");
        Matcher m = p.matcher(this._regExCircularBuff);
        boolean match = m.find();
        char[] buff = null;
        CharSequence matchStr = null;
        while (match) {
            matchStr = this._regExCircularBuff.subSequence(m.start(), m.end());
            buff = new char[m.start()];
            this._regExCircularBuff.getReader().read(buff, 0, m.start());
            this._outCircularBuff.getWriter().write(buff);
            this._outCircularBuff.getWriter().write(" [" + matchStr + "] ");
            match = m.find();
        }
    }

    private static int _parseText(String pattern, String text, StringWriter outWriter, boolean bSkipPattern, Method transformMethod) {
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(text);
        int end = 0;
        while (m.find(bSkipPattern ? end : end + pattern.length())) {
            outWriter.write(text.substring(end, m.start()));
            try {
                if (transformMethod != null) {
                    outWriter.write((String)transformMethod.invoke(null, (Object[])new String[]{text.substring(m.start(), m.end())}));
                }
            }
            catch (Exception e) {
                R01FLog.to("r01f.test").fine("2 \u00b7 " + e);
            }
            end = bSkipPattern ? m.end() : m.end() - pattern.length();
        }
        return end;
    }

    public static String transformDirective(String directive) {
        String out = "";
        out = " [" + directive + "] ";
        return out;
    }

    private static int proccessText(StringWriter outWriter, String inputText, int readBufferSize, int circularBufferSize) {
        int Matchersize = inputText.length() < circularBufferSize && inputText.length() < readBufferSize ? inputText.length() : (circularBufferSize < readBufferSize ? circularBufferSize : readBufferSize);
        String text = inputText.substring(0, Matchersize);
        int end = 0;
        try {
            Method transformMethod = RegExpDirectiveFilterReader.class.getMethod("transformDirective", String.class);
            end = RegExpDirectiveFilterReader._parseText("<!--#.*-->", text, outWriter, true, transformMethod);
            end += RegExpDirectiveFilterReader._parseText("<", text.substring(end), outWriter, false, null);
            if (end == 0) {
                outWriter.write(inputText.substring(end));
            }
        }
        catch (Exception e) {
            R01FLog.to("r01f.test").fine(e.getMessage());
        }
        return end;
    }

    public int readBuffer(StringWriter outWriter, CircularCharBuffer circularBuffer, char[] buff, int charsReaded) {
        int readSize = 0;
        int initReadPosition = circularBuffer.readPosition;
        try {
            circularBuffer.getWriter().write(buff, 0, charsReaded);
            int end = RegExpDirectiveFilterReader.proccessText(outWriter, circularBuffer.toString(true), buff.length, circularBuffer.buffer.length);
            circularBuffer.markPosition = circularBuffer.writePosition;
            circularBuffer.readPosition = circularBuffer.getPositionFromLineal(end);
            if (initReadPosition == circularBuffer.readPosition) {
                circularBuffer.writePosition = 0;
                circularBuffer.markPosition = 0;
                circularBuffer.readPosition = 0;
                Arrays.fill(circularBuffer.buffer, '\u0000');
            }
            int n = end == 0 ? (circularBuffer.buffer.length > buff.length ? buff.length : circularBuffer.buffer.length) : (readSize = end > buff.length ? buff.length : end);
            if (circularBuffer.getSpaceLeft() < readSize) {
                readSize = circularBuffer.getSpaceLeft();
                R01FLog.to("r01f.test").fine(" ##### C\u00c1LCULO DE CARACTERES DE LECTURA DEL SIGUIENTE CICLO ERR\u00d3NEO ##### ");
            }
        }
        catch (Exception e) {
            R01FLog.to("r01f.test").fine(e.getMessage());
        }
        return readSize;
    }

    public static void main(String[] args) {
        try {
            String srcStr = "<!--:************************************************************:--><!--: Euskadi.net: Eusko Jaurlaritza - Gobierno Vasco            :--><!--: Created by:                                                :--><!--:     EJIE, S.A. Eusko Jaurlaritzaren Informatiko Elkartea   :--><!--:     Avda. Mediterraneo, 3                                  :--><!--:     Vitoria-Gasteiz                                        :--><!--:************************************************************:--><!--:============================================================:--><!--:                     PAGE XML DESCRIPTOR                    :--><!--:============================================================:--><!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"es\"><head>   <!-- Directiva para la previsualizaci\u00f3n de la plantilla, se borrar\u00e1 de las p\u00e1ginas -->      <!-- Area visual que contiene parametros del head en cada idioma:           title           description         metas         Este VA es OBLIGATORIO!!!! y tiene que estar en la seccion HEAD   -->         <title>Euskadi.net: TestPage</title>        <!-- **** MetaTags **** -->            <META name=\"Publisher\" content=\"Ejie\" />        <!-- **** JavaScript for the PageTags **** -->        <script type='text/javascript'>              var r01gIsAdminPage='false';              var r01gLang='<!--#echo var='LANG'-->';              var r01gPortalCode='r33';              var r01gPageCode='containe';        </script>                                       </head><body>   <h1>(Init) R01HProxyWar Test Page</h1>  <hr />  <!--#include virtual='$APPEXT'-->   <hr />  <h1>(End) R01HProxyWar Test Page</h1></body></html>";
            StringReader srcReader = new StringReader(srcStr);
            StringWriter outWriter = new StringWriter();
            RegExpDirectiveFilterReader directiveFilterReader = new RegExpDirectiveFilterReader(srcReader, srcStr.length() / 4);
            directiveFilterReader.addListener("<!--#.*-->", new DirectiveListener(){

                @Override
                public char[] processDirective(String directiveText, long index) {
                    return "Patr\u00f3n de directiva encontrado.".toCharArray();
                }
            });
            directiveFilterReader.addListener("<", new DirectiveListener(){

                @Override
                public char[] processDirective(String directiveText, long index) {
                    return "Inicio de etiqueta encontrada.".toCharArray();
                }
            });
            Writer circularBufferWriter = directiveFilterReader.getBuffer().getWriter();
            directiveFilterReader.getBuffer().setEventListener(new BufferEventListener(){

                @Override
                public void bufferEmpty() {
                    R01FLog.to("r01f.test").fine("\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8Buffer vacio!!!");
                }

                @Override
                public void bufferFull() {
                    R01FLog.to("r01f.test").fine("\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8Buffer lleno!!!");
                }
            });
            int charsReaded = -1;
            int readSize = srcStr.length() / 5;
            char[] buff = new char[readSize];
            boolean initReadPosition = false;
            while ((charsReaded = srcReader.read(buff, 0, readSize)) > 0) {
                readSize = directiveFilterReader.readBuffer(outWriter, directiveFilterReader.getBuffer(), buff, charsReaded);
                Arrays.fill(buff, '\u0000');
            }
            outWriter.write(directiveFilterReader.getBuffer().toString(true));
            R01FLog.to("r01f.test").fine(outWriter.toString());
            outWriter.close();
            circularBufferWriter.close();
        }
        catch (IOException ioEx) {
            R01FLog.to("r01f.test").fine("Exception!!!" + ioEx);
            R01FLog.to("r01f.test").fine(ioEx.getMessage());
        }
    }
}

