/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.io.filters;

import com.ejie.r01f.io.filters.DirectiveListener;
import com.ejie.r01f.io.filters.TestDirectiveListener;
import com.ejie.r01f.log.R01FLog;
import java.io.BufferedReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DirectiveFilterReader
extends FilterReader {
    private List _directiveListeners = null;
    private String[] _beginningDelimiters = null;
    private String[] _endingDelimiters = null;
    private String _beginningDelimitersFirstLetters = "";
    private int _maxDirectiveLength = 255;
    private long _index = 0L;
    private char[] _lastDirectiveOutput = null;
    private int _lastDirectiveOutputIndex = -1;
    private int _currDirectiveIndex = -1;
    private int _endingDelimiterMatches = 0;
    private StringBuffer _directiveText = null;

    public DirectiveFilterReader(Reader newIn) {
        super(new BufferedReader(newIn));
    }

    public DirectiveFilterReader(Reader newIn, int bufferSize) {
        super(new BufferedReader(newIn, bufferSize));
    }

    public DirectiveFilterReader(Reader newIn, int bufferSize, int newMaxDirectiveLength) {
        super(new BufferedReader(newIn, bufferSize));
        this._maxDirectiveLength = newMaxDirectiveLength;
    }

    public void addListener(DirectiveListener listener, String beginningDelimiter, String endingDelimiter) {
        if (this._directiveListeners == null) {
            this._directiveListeners = new ArrayList();
        }
        this._directiveListeners.add(listener);
        this._beginningDelimiters = this._insertStringInArray(this._beginningDelimiters, beginningDelimiter);
        this._endingDelimiters = this._insertStringInArray(this._endingDelimiters, endingDelimiter);
        this._beginningDelimitersFirstLetters = String.valueOf(this._beginningDelimitersFirstLetters) + beginningDelimiter.charAt(0);
    }

    @Override
    public int read(char[] text, int offset, int length) throws IOException {
        int numRead = 0;
        int i = offset;
        while (i < offset + length) {
            int temp = this.read();
            if (temp == -1) break;
            text[i] = (char)temp;
            ++numRead;
            ++i;
        }
        return numRead;
    }

    @Override
    public int read() throws IOException {
        if (this._lastDirectiveOutput != null && this._lastDirectiveOutputIndex >= 0) {
            char c = this._lastDirectiveOutput[this._lastDirectiveOutputIndex++];
            if (this._lastDirectiveOutputIndex == this._lastDirectiveOutput.length) {
                this._lastDirectiveOutput = null;
                this._lastDirectiveOutputIndex = -1;
            }
            return c;
        }
        if (this._currDirectiveIndex < 0) {
            this.in.mark(this._maxDirectiveLength);
            this._currDirectiveIndex = this._beginningDelimitersFirstLetters.indexOf(this.in.read(), 0);
            if (this._currDirectiveIndex >= 0) {
                boolean tryNextDirective;
                block0: do {
                    tryNextDirective = false;
                    int j = 1;
                    while (j < this._beginningDelimiters[this._currDirectiveIndex].length()) {
                        if (this._beginningDelimiters[this._currDirectiveIndex].charAt(j) != this.in.read()) {
                            this.in.reset();
                            tryNextDirective = true;
                            this._currDirectiveIndex = this._beginningDelimitersFirstLetters.indexOf(this.in.read(), this._currDirectiveIndex + 1);
                            continue block0;
                        }
                        ++j;
                    }
                } while (tryNextDirective && this._currDirectiveIndex > 0);
                if (this._currDirectiveIndex < 0) {
                    this.in.reset();
                }
            } else {
                this.in.reset();
            }
            if (this._currDirectiveIndex >= 0) {
                this._directiveText = new StringBuffer();
                this.in.reset();
                boolean endDelimiterFound = false;
                int c = -1;
                do {
                    if ((c = this.in.read()) < 0) continue;
                    this._directiveText.append((char)c);
                    boolean bl = endDelimiterFound = this._directiveText.lastIndexOf(this._endingDelimiters[this._currDirectiveIndex]) > 0;
                } while (c >= 0 && !endDelimiterFound);
                if (endDelimiterFound) {
                    this.in.reset();
                    this.in.skip(this._directiveText.length());
                    DirectiveListener listener = (DirectiveListener)this._directiveListeners.get(this._currDirectiveIndex);
                    this._lastDirectiveOutput = listener.processDirective(this._directiveText.toString(), this._index - 1L);
                    if (this._lastDirectiveOutput != null && this._lastDirectiveOutput.length > 0) {
                        this._lastDirectiveOutputIndex = 0;
                    } else {
                        this._lastDirectiveOutputIndex = -1;
                        this._lastDirectiveOutput = null;
                    }
                    this._currDirectiveIndex = -1;
                    return this.read();
                }
                this.in.reset();
                ++this._index;
                return this.in.read();
            }
            ++this._index;
            return this.in.read();
        }
        int c = this.in.read();
        if (this._endingDelimiters[this._currDirectiveIndex].charAt(this._endingDelimiterMatches) == c) {
            if (this._endingDelimiters[this._currDirectiveIndex].length() == this._endingDelimiterMatches + 1) {
                this._currDirectiveIndex = -1;
                this._endingDelimiterMatches = 0;
            } else {
                ++this._endingDelimiterMatches;
            }
        }
        ++this._index;
        return c;
    }

    private String[] _insertStringInArray(String[] oldArray, String newStringToInsert) {
        String[] newArray = null;
        if (newStringToInsert == null) {
            return oldArray;
        }
        if (oldArray != null) {
            newArray = new String[oldArray.length + 1];
            System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
        } else {
            newArray = new String[1];
        }
        newArray[newArray.length - 1] = newStringToInsert;
        return newArray;
    }

    public static void main(String[] args) {
        try {
            TestDirectiveListener listener0 = new TestDirectiveListener();
            TestDirectiveListener listener1 = new TestDirectiveListener();
            StringReader reader = new StringReader("<!--:************************************************************:--><!--: Euskadi.net: Eusko Jaurlaritza - Gobierno Vasco            :--><!--: Created by:                                                :--><!--:     EJIE, S.A. Eusko Jaurlaritzaren Informatiko Elkartea   :--><!--:     Avda. Mediterraneo, 3                                  :--><!--:     Vitoria-Gasteiz                                        :--><!--:************************************************************:--><!--:============================================================:--><!--:                     PAGE XML DESCRIPTOR                    :--><!--:============================================================:--><!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"es\"><head>   <!-- Directiva para la previsualizaci\u00f3n de la plantilla, se borrar\u00e1 de las p\u00e1ginas -->      <!-- Area visual que contiene parametros del head en cada idioma:           title           description         metas         Este VA es OBLIGATORIO!!!! y tiene que estar en la seccion HEAD   -->         <title>Euskadi.net: TestPage</title>        <!-- **** MetaTags **** -->            <META name=\"Publisher\" content=\"Ejie\" />        <!-- **** JavaScript for the PageTags **** -->        <script type='text/javascript'>              var r01gIsAdminPage='false';              var r01gLang='<!--#echo var='LANG'-->';              var r01gPortalCode='r33';              var r01gPageCode='containe';        </script>                                       </head><body>   <h1>(Init) R01HProxyWar Test Page</h1>  <hr />  <!--#include virtual='$APPEXT'-->   <hr />  <h1>(End) R01HProxyWar Test Page</h1></body></html>");
            DirectiveFilterReader directiveFilterReader = new DirectiveFilterReader(reader);
            directiveFilterReader.addListener(listener0, "<!--#", "-->");
            int c = 0;
            do {
                if ((c = directiveFilterReader.read()) <= 0) continue;
                System.out.print((char)c);
            } while (c > 0);
            R01FLog.to("r01f.test").fine("\n\n");
            Iterator it = listener0.directivas.iterator();
            while (it.hasNext()) {
                R01FLog.getLogger("r01f.io").finest("Directiva encontrada>>> " + it.next());
            }
            it = listener1.directivas.iterator();
            while (it.hasNext()) {
                R01FLog.getLogger("r01f.io").finest("Directiva encontrada>>> " + it.next());
            }
        }
        catch (IOException ioEx) {
            R01FLog.to("r01f.test").fine("Exception!!!" + ioEx);
        }
    }
}

