/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.io;

import com.ejie.r01f.io.BytesInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BytesOutputStream
extends OutputStream {
    private static final int DEFAULT_INITIAL_BUFFER_SIZE = 8192;
    private byte[] _buffer;
    private int _index;
    private int _capacity;
    private boolean _closed;
    private boolean _shared;

    public BytesOutputStream() {
        this(8192);
    }

    public BytesOutputStream(int initialBufferSize) {
        this._capacity = initialBufferSize;
        this._buffer = new byte[this._capacity];
    }

    @Override
    public void write(int datum) throws IOException {
        if (this._closed) {
            throw new IOException("BytesOutputStream closed!!!");
        }
        if (this._index >= this._capacity) {
            this._capacity = this._capacity * 2 + 1;
            byte[] tmp = new byte[this._capacity];
            System.arraycopy(this._buffer, 0, tmp, 0, this._index);
            this._buffer = tmp;
            this._shared = false;
        }
        this._buffer[this._index++] = (byte)datum;
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        if (data == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset + length > data.length || length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this._closed) {
            throw new IOException("Stream closed");
        }
        if (this._index + length > this._capacity) {
            this._capacity = this._capacity * 2 + length;
            byte[] tmp = new byte[this._capacity];
            System.arraycopy(this._buffer, 0, tmp, 0, this._index);
            this._buffer = tmp;
            this._shared = false;
        }
        System.arraycopy(data, offset, this._buffer, this._index, length);
        this._index += length;
    }

    @Override
    public void close() {
        this._closed = true;
    }

    public byte[] toByteArray() {
        byte[] result = new byte[this._index];
        System.arraycopy(this._buffer, 0, result, 0, this._index);
        return result;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this._buffer, 0, this._index);
    }

    public InputStream toInputStream() {
        this._shared = true;
        return new BytesInputStream(this._buffer, 0, this._index);
    }

    public void reset() throws IOException {
        if (this._closed) {
            throw new IOException("Stream closed");
        }
        if (this._shared) {
            this._buffer = new byte[this._capacity];
            this._shared = false;
        }
        this._index = 0;
    }

    public int getLength() {
        return this._index;
    }

    public String toString() {
        StringBuffer outStr = new StringBuffer("");
        if (this._buffer != null) {
            int i = 0;
            while (i < this._index) {
                outStr.append((char)this._buffer[i]);
                ++i;
            }
        }
        return outStr.toString();
    }
}

