/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.guids;

import com.ejie.r01f.guids.GUIDDispenser;
import com.ejie.r01f.guids.GUIDDispenserDef;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Date;

public class SimpleGUIDDispenser
implements GUIDDispenser {
    GUIDDispenserDef _dispDef = null;

    public SimpleGUIDDispenser() {
    }

    public SimpleGUIDDispenser(GUIDDispenserDef dispDef) {
        this();
        this._dispDef = dispDef;
        if (dispDef.properties.get("length") == null) {
            R01FLog.to("r01f.guid").warning("No se ha definido la propiedad guidGenerator/sequence[@id='" + dispDef.sequenceName + "']/properties/length en el fichero de properties de la aplicacion " + dispDef.appCode + ". Se toma un tama\u00f1o de 36");
            dispDef.properties.put("length", "36");
        }
        if (dispDef.uniqueID == null) {
            dispDef.uniqueID = "un";
        }
        if (dispDef.uniqueID.length() < 2) {
            StringUtils.rPadWithChar(dispDef.uniqueID, '0', 2);
        }
        R01FLog.to("r01f.guid").warning("GUIDGenerator > Tama\u00f1o guid=" + (5 + Integer.parseInt(dispDef.properties.getProperty("length"))) + ", environment=" + dispDef.uniqueID);
    }

    @Override
    public String getGUID() {
        return this._generateGUID();
    }

    private String _generateGUID() {
        String guid = "";
        int guidLength = Integer.parseInt(this._dispDef.properties.getProperty("length"));
        String prefix = this._dispDef.appCode;
        String prefixV = null;
        char[] resultCharArray = new char[guidLength];
        Arrays.fill(resultCharArray, '0');
        prefixV = prefix == null || prefix.length() == 0 ? "UNKN" : (prefix.length() > 4 ? prefix.substring(0, 4) : (prefix.length() < 4 ? StringUtils.rPadWithChar(prefix, '0', 4) : prefix));
        long timeStampLong = new Date().getTime();
        SecureRandom sRandom = new SecureRandom();
        int objectHashCode = System.identityHashCode(this);
        long secureInt = sRandom.nextLong();
        String result = String.valueOf(Long.toHexString(timeStampLong)) + Integer.toHexString(objectHashCode) + Long.toHexString(secureInt);
        int cont = result.length() - 1;
        int i = guidLength;
        while (i > 0) {
            if (cont >= 0) {
                resultCharArray[i - 1] = result.charAt(cont);
            }
            --cont;
            --i;
        }
        sRandom = null;
        guid = String.valueOf(prefixV) + this._dispDef.uniqueID.charAt(0) + this._dispDef.uniqueID.charAt(1) + new String(resultCharArray);
        return guid;
    }
}

