/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.guids;

import com.ejie.r01f.guids.GUIDDispenser;
import com.ejie.r01f.guids.GUIDDispenserDef;
import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01f.guids.GUIDPersist;
import com.ejie.r01f.guids.Key;
import com.ejie.r01f.guids.MaxForKeyReachedException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;

public class HighLowGUIDDispenser
implements GUIDDispenser {
    private GUIDDispenserDef _dispenserDef = null;
    private Key _currHighKey = null;
    private Key _currLowKey = null;
    private GUIDPersist _guidPersist = null;

    public HighLowGUIDDispenser(GUIDDispenserDef newDispDef) throws GUIDDispenserException {
        if (newDispDef == null) {
            throw new GUIDDispenserException("La definicion del guid es nula. No se puede crear el dispenser!");
        }
        this._dispenserDef = newDispDef;
        if (this._dispenserDef.properties.get("highKeyBytes") == null) {
            R01FLog.to("r01f.guid").warning("No se ha definido la propiedad guidGenerator/sequence[@id='" + this._dispenserDef.sequenceName + "']/properties/highKeyBytes en el fichero de properties de la aplicacion " + this._dispenserDef.appCode + ". Se toma un tama\u00f1o de 5");
            this._dispenserDef.properties.put("highKeyBytes", "5");
        }
        if (this._dispenserDef.properties.get("lowKeyBytes") == null) {
            R01FLog.to("r01f.guid").warning("No se ha definido la propiedad guidGenerator/sequence[@id='" + this._dispenserDef.sequenceName + "']/properties/lowKeyBytes en el fichero de properties de la aplicacion " + this._dispenserDef.appCode + ". Se toma un tama\u00f1o de 5");
            this._dispenserDef.properties.put("lowKeyBytes", "5");
        }
        if (this._dispenserDef.properties.get("persistClassName") == null) {
            R01FLog.to("r01f.guid").warning("No se ha definido la propiedad guidGenerator/sequence[@id='" + this._dispenserDef.sequenceName + "']/properties/persistenceClass en el fichero de properties de la aplicacion " + this._dispenserDef.appCode + ". Se toma la persistencia en memoria!!!!");
            this._dispenserDef.properties.put("persistClassName", (this.getClass().getPackage() + "." + "MemoryGUIDPersist").substring(8));
        }
        if (newDispDef.properties.get("persistClassName") == null) {
            throw new GUIDDispenserException("No se ha definido la propiedad que indica el nombre de la clase que se encarga de la persistencia de GUIDs!");
        }
        try {
            this._guidPersist = (GUIDPersist)ReflectionUtils.getObjectInstance(newDispDef.properties.getProperty("persistClassName"));
        }
        catch (ReflectionException refEx) {
            throw new GUIDDispenserException("No se puede crear el objeto de persistencia de guids " + newDispDef.properties.getProperty("persistClassName"), (Exception)refEx);
        }
        this._currLowKey = new Key(Integer.parseInt(newDispDef.properties.getProperty("lowKeyBytes")));
        this._moveToNextHighKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getGUID() throws GUIDDispenserException {
        String theUIdString = null;
        HighLowGUIDDispenser highLowGUIDDispenser = this;
        synchronized (highLowGUIDDispenser) {
            try {
                this._currLowKey.increment();
            }
            catch (MaxForKeyReachedException maxEx) {
                this._moveToNextHighKey();
                this._currLowKey.setToZero();
            }
        }
        theUIdString = String.valueOf(this._currHighKey.toString()) + this._currLowKey.toString() + this._dispenserDef.uniqueID;
        return theUIdString;
    }

    private boolean _moveToNextHighKey() throws GUIDDispenserException {
        try {
            if (this._currHighKey != null) {
                this._currHighKey.increment();
            } else {
                this._currHighKey = this._guidPersist.getHighKeyValue(this._dispenserDef);
                this._currHighKey.setToZero();
            }
            return this._guidPersist.updateGUID(this._dispenserDef, this._currHighKey);
        }
        catch (MaxForKeyReachedException maxKeyEx) {
            throw new GUIDDispenserException("Se han agotado los HIGH... ponte a temblar");
        }
    }
}

