/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.guids;

import com.ejie.r01f.guids.GUIDDispenser;
import com.ejie.r01f.guids.GUIDDispenserDef;
import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import java.util.Hashtable;
import java.util.Map;

public class GUIDDispenserManager {
    Map dispensers = null;

    GUIDDispenserManager() {
    }

    public static GUIDDispenser createDispenser() throws GUIDDispenserException {
        return GUIDDispenserManager.createDispenser("r01f", "default");
    }

    public static GUIDDispenser createDispenser(String appCode) throws GUIDDispenserException {
        return GUIDDispenserManager.createDispenser(appCode, "default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GUIDDispenser createDispenser(String appCode, String sequenceId) throws GUIDDispenserException {
        GUIDDispenser outDispenser = null;
        Map map = SingletonHolder.instance.dispensers;
        synchronized (map) {
            if (SingletonHolder.instance.dispensers != null && sequenceId != null) {
                outDispenser = (GUIDDispenser)SingletonHolder.instance.dispensers.get(String.valueOf(appCode) + "." + sequenceId);
            }
        }
        if (outDispenser == null) {
            R01FLog.to("r01f.guid").finest("El dispenser " + sequenceId + " de la aplicacion " + appCode + " NO estaba creado...se crea ahora!");
            GUIDDispenserDef newDispenserDef = new GUIDDispenserDef(appCode, sequenceId);
            outDispenser = GUIDDispenserManager.createDispenser(newDispenserDef);
        }
        if (outDispenser == null) {
            throw new GUIDDispenserException("La secuencia '" + sequenceId + "' no se ha inicializado!");
        }
        return outDispenser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GUIDDispenser createDispenser(GUIDDispenserDef newDispenserDef) throws GUIDDispenserException {
        if (newDispenserDef == null) {
            throw new GUIDDispenserException("La definicion del dispenser es nula!");
        }
        GUIDDispenser dispenser = null;
        Map map = SingletonHolder.instance.dispensers;
        synchronized (map) {
            String dispenserKey = String.valueOf(newDispenserDef.appCode) + "." + newDispenserDef.sequenceName;
            if (SingletonHolder.instance.dispensers != null) {
                dispenser = (GUIDDispenser)SingletonHolder.instance.dispensers.get(dispenserKey);
            }
            if (dispenser == null && (dispenser = (GUIDDispenser)SingletonHolder.instance.dispensers.get(dispenserKey)) == null) {
                try {
                    dispenser = (GUIDDispenser)ReflectionUtils.getObjectInstance(newDispenserDef.dispenserClass, new Class[]{GUIDDispenserDef.class}, new Object[]{newDispenserDef}, true);
                    if (dispenser != null) {
                        SingletonHolder.instance.dispensers.put(dispenserKey, dispenser);
                        R01FLog.to("r01f.guid").warning("GUIDGenerator >\r\n" + newDispenserDef.composeDebugInfo());
                        return dispenser;
                    }
                    throw new GUIDDispenserException("No se puede crear el dispenser de guids: " + newDispenserDef.dispenserClass + ",key:" + newDispenserDef.appCode + "." + newDispenserDef.sequenceName);
                }
                catch (ReflectionException refEx) {
                    throw new GUIDDispenserException("No se puede crear el dispensador de guids " + newDispenserDef.dispenserClass + ",key:" + newDispenserDef.appCode + "." + newDispenserDef.sequenceName, (Exception)refEx);
                }
                catch (ClassCastException ccEx) {
                    throw new GUIDDispenserException("La clase " + newDispenserDef.dispenserClass + " no implementa el interfaz " + GUIDDispenser.class.getName());
                }
            }
        }
        return dispenser;
    }

    private static final class SingletonHolder {
        public static final GUIDDispenserManager instance = new GUIDDispenserManager();

        static {
            SingletonHolder.instance.dispensers = new Hashtable();
        }

        private SingletonHolder() {
        }
    }
}

