/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.guids;

import com.ejie.r01f.guids.GUIDDispenserDef;
import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01f.guids.GUIDPersist;
import com.ejie.r01f.guids.Key;
import com.ejie.r01f.sql.BDConnectionHelpper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class BDGUIDPersist
implements GUIDPersist {
    private static final String CONXNAME = "conxName";
    private static final String GUIDSTABLE = "guidsTable";
    private static final String HIGHKEYCOLUMN = "highKeyColumn";
    private static final String SEQUENCENAMECOLUMN = "seqNameColumn";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Key getHighKeyValue(GUIDDispenserDef dispDef) throws GUIDDispenserException {
        try {
            if (this._checkDispenserDef(dispDef) != null) {
                throw new IllegalArgumentException(this._checkDispenserDef(dispDef));
            }
            String conxName = dispDef.properties.getProperty(CONXNAME);
            String guidsTable = dispDef.properties.getProperty(GUIDSTABLE);
            String highKeyCol = dispDef.properties.getProperty(HIGHKEYCOLUMN);
            String seqCol = dispDef.properties.getProperty(SEQUENCENAMECOLUMN);
            Connection conx = null;
            Statement ps = null;
            ResultSet rs = null;
            try {
                conx = BDConnectionHelpper.getConnection(dispDef.appCode, conxName);
                String sqlSELECT = null;
                sqlSELECT = "SELECT " + highKeyCol + " " + "FROM " + guidsTable + " " + "WHERE " + seqCol + "= ?";
                ps = conx.prepareStatement(sqlSELECT);
                ps.setString(1, dispDef.sequenceName);
                rs = ps.executeQuery();
                if (rs.next()) {
                    Key key = new Key(rs.getString(highKeyCol));
                    return key;
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (conx != null) {
                    conx.close();
                }
            }
        }
        catch (SQLException sqlEx) {
            throw new GUIDDispenserException("Error al obtener el valor de la parte high de la clave: " + sqlEx.getMessage(), (Exception)sqlEx);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean updateGUID(GUIDDispenserDef dispDef, Key newHighKey) throws GUIDDispenserException {
        if (this._checkDispenserDef(dispDef) != null) {
            throw new IllegalArgumentException(this._checkDispenserDef(dispDef));
        }
        if (newHighKey == null) {
            throw new IllegalArgumentException("La nueva clave high NO es valida!");
        }
        String conxName = dispDef.properties.getProperty(CONXNAME);
        String guidsTable = dispDef.properties.getProperty(GUIDSTABLE);
        String highKeyCol = dispDef.properties.getProperty(HIGHKEYCOLUMN);
        String seqCol = dispDef.properties.getProperty(SEQUENCENAMECOLUMN);
        Connection conx = null;
        Statement ps = null;
        try {
            try {
                conx = BDConnectionHelpper.getConnection(dispDef.appCode, conxName);
                String sqlUPDATE = "UPDATE " + guidsTable + " " + "SET " + highKeyCol + " = ? " + "WHERE " + seqCol + " = ?";
                ps = conx.prepareStatement(sqlUPDATE);
                ps.setString(1, newHighKey.toString());
                ps.setString(2, dispDef.sequenceName);
                if (ps.executeUpdate() == 1) return true;
                return false;
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
                if (conx != null) {
                    conx.close();
                }
            }
        }
        catch (SQLException sqlEx) {
            throw new GUIDDispenserException("Error al actualizar el valor high de la clave en la base de datos: " + sqlEx.getMessage(), (Exception)sqlEx);
        }
    }

    private String _checkDispenserDef(GUIDDispenserDef dispDef) {
        StringBuffer sb = new StringBuffer("");
        if (dispDef == null) {
            sb.append("\r\nDescriptor del dispenser NO es valido!\r\n");
        } else if (dispDef.properties == null) {
            sb.append("\tNo se han definido las propiedades del dispenser que permiten conocer la Base de Datos\r\n");
        } else {
            String conxName = dispDef.properties.getProperty(CONXNAME);
            String guidsTable = dispDef.properties.getProperty(GUIDSTABLE);
            String highKeyCol = dispDef.properties.getProperty(HIGHKEYCOLUMN);
            if (conxName == null) {
                sb.append("\tFalta la propiedad conxName en la definicion del dispenser " + dispDef.sequenceName);
            }
            if (guidsTable == null) {
                sb.append("\tFalta la propiedad guidsTable en la definicion del dispenser " + dispDef.sequenceName);
            }
            if (highKeyCol == null) {
                sb.append("\tFalta la propiedad highKeyColumn en la definicion del dispenser " + dispDef.sequenceName);
            }
            if (guidsTable == null) {
                sb.append("\tFalta la propiedad guidsTable en la definicion del dispenser " + dispDef.sequenceName);
            }
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }
}

