/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.file;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.changes.ChangeSet;
import org.apache.commons.compress.changes.ChangeSetPerformer;
import org.apache.commons.compress.utils.IOUtils;

public abstract class FileCompressorUtils {
    private static final boolean DEBUG = R01FLog.getLogLevel("r01f.test").intValue() != Level.OFF.intValue();
    public static final String DEFAULT_ZIPFILE_ENCODING = "CP437";

    public static StringBuffer printContentsFromZipFile(String zipFilename) {
        return FileCompressorUtils.printContentsFromZipFile(zipFilename, DEFAULT_ZIPFILE_ENCODING);
    }

    public static StringBuffer printContentsFromZipFile(String zipFilename, String encoding) {
        StringBuffer buf = new StringBuffer(113);
        buf.append("########### Contenido del archivo ");
        buf.append(zipFilename);
        buf.append(" ##########\r\n\r\n");
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy hh:mm");
        try {
            ZipFile zf = new ZipFile(zipFilename, encoding);
            Enumeration fileContents = zf.getEntries();
            int size = 0;
            while (fileContents.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)fileContents.nextElement();
                if (!entry.isDirectory()) {
                    buf.append("\r\n\t");
                    buf.append(df.format(new Date(entry.getTime())));
                    buf.append("\t");
                    buf.append(entry.getSize());
                    buf.append("\t");
                    buf.append(entry.toString());
                    ++size;
                    continue;
                }
                buf.append("\r\nDIR ");
                buf.append(entry.getName());
            }
            buf.append("\r\n============");
            buf.append(size);
            buf.append(" ficheros encontrados.");
            zf.close();
        }
        catch (IOException e) {
            buf.append("Error al leer el fichero: ");
            buf.append(e.getMessage());
        }
        return buf;
    }

    public static void extractContentsFromZipFile(String zipFileName, String targetPath) throws IOException {
        FileCompressorUtils.extractContentsFromZipFile(zipFileName, targetPath, DEFAULT_ZIPFILE_ENCODING);
    }

    public static void extractContentsFromZipFile(String zipFileName, String targetPath, String encoding) throws IOException {
        String PATHSEPARATOR = File.separator;
        ZipFile zipFile = new ZipFile(zipFileName, encoding);
        Enumeration entries = zipFile.getEntries();
        while (entries.hasMoreElements()) {
            ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
            if (entry.getName().indexOf("/") > -1) {
                PATHSEPARATOR = "/";
            } else if (entry.getName().indexOf("\\") > -1) {
                PATHSEPARATOR = "\\";
            }
            if (entry.isDirectory()) {
                new File(String.valueOf(targetPath) + PATHSEPARATOR + entry.getName()).mkdirs();
                continue;
            }
            if (entry.getName().lastIndexOf(PATHSEPARATOR) > -1) {
                boolean success;
                String resourceDirs = entry.getName().substring(0, entry.getName().lastIndexOf(PATHSEPARATOR));
                File dirPath = new File(String.valueOf(targetPath) + PATHSEPARATOR + resourceDirs);
                if (!dirPath.exists() && !(success = dirPath.mkdirs())) {
                    throw new IOException("No se puede crear la ruta " + resourceDirs);
                }
            }
            if (DEBUG) {
                R01FLog.to("r01f.test").info(">>>> Extraer --> " + entry.getName() + " en " + targetPath + File.separator + entry.getName());
            }
            InputStream in = null;
            OutputStream out = null;
            try {
                in = zipFile.getInputStream(entry);
                out = new FileOutputStream(new File(String.valueOf(targetPath) + PATHSEPARATOR, entry.getName()));
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
        }
        if (zipFile != null) {
            zipFile.close();
        }
    }

    public static void createZipFile(String zipFileName, List files, String encoding) throws IOException {
        if (files == null || files.isEmpty()) {
            return;
        }
        ZipArchiveOutputStream zipOutput = null;
        try {
            zipOutput = new ZipArchiveOutputStream(new File(zipFileName));
            zipOutput.setEncoding(encoding);
            for (String currFile : files) {
                ZipArchiveEntry entry = new ZipArchiveEntry(currFile);
                zipOutput.putArchiveEntry((ArchiveEntry)entry);
                FileInputStream currFileInputStream = new FileInputStream(currFile);
                IOUtils.copy((InputStream)currFileInputStream, (OutputStream)zipOutput);
                currFileInputStream.close();
                zipOutput.closeArchiveEntry();
            }
        }
        finally {
            if (zipOutput != null) {
                zipOutput.close();
            }
        }
    }

    public static void createZipFile(String zipFileName, String zipEntryPath, List files, String encoding) throws IOException {
        if (files == null || files.isEmpty()) {
            return;
        }
        ZipArchiveOutputStream zipOutput = null;
        try {
            zipOutput = new ZipArchiveOutputStream(new File(zipFileName));
            zipOutput.setEncoding(encoding);
            for (String currFile : files) {
                ZipArchiveEntry entry = new ZipArchiveEntry(String.valueOf(zipEntryPath) + File.separator + new File(currFile).getName());
                zipOutput.putArchiveEntry((ArchiveEntry)entry);
                FileInputStream currFileInputStream = new FileInputStream(currFile);
                IOUtils.copy((InputStream)currFileInputStream, (OutputStream)zipOutput);
                currFileInputStream.close();
                zipOutput.closeArchiveEntry();
            }
        }
        finally {
            if (zipOutput != null) {
                zipOutput.close();
            }
        }
    }

    public static void appendToZipFile(String zipFileName, String fileName, InputStream fileContentsIS) throws Exception {
        if (StringUtils.isEmptyString(zipFileName) || StringUtils.isEmptyString(fileName) || fileContentsIS == null) {
            return;
        }
        File input = new File(zipFileName);
        if (!input.exists()) {
            input.createNewFile();
        }
        String tmpFile = String.valueOf(zipFileName.substring(0, zipFileName.lastIndexOf(46) != -1 ? zipFileName.lastIndexOf(46) : zipFileName.length())) + ".tmp";
        File result = new File(tmpFile);
        result.createNewFile();
        if (input.exists() && result.exists()) {
            ArchiveOutputStream out = null;
            ArchiveInputStream ais = null;
            FileInputStream is = null;
            ChangeSet changes = new ChangeSet();
            ArchiveStreamFactory factory = new ArchiveStreamFactory();
            try {
                is = new FileInputStream(input);
                ais = factory.createArchiveInputStream("zip", (InputStream)is);
                out = factory.createArchiveOutputStream("zip", (OutputStream)new FileOutputStream(result));
                ZipArchiveEntry entry = new ZipArchiveEntry(fileName);
                changes.add((ArchiveEntry)entry, fileContentsIS);
                ChangeSetPerformer performer = new ChangeSetPerformer(changes);
                performer.perform(ais, out);
                ((InputStream)is).close();
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (ais != null) {
                    ais.close();
                } else if (is != null) {
                    ((InputStream)is).close();
                }
            }
            if (!input.delete() || !result.renameTo(new File(zipFileName))) {
                throw new IOException("El fichero '" + input.getCanonicalPath() + "' y/o el fichero temporal '" + result.getCanonicalPath() + "' no pueden ser tratados.");
            }
        } else {
            throw new IOException("El fichero '" + input.getCanonicalPath() + "' no se ha podido borrar.");
        }
    }
}

