/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.file;

import com.ejie.r01f.file.DirectoryWalkerEventListener;
import com.ejie.r01f.log.R01FLog;
import java.io.File;

public class DirectoryWalkerLogger
implements DirectoryWalkerEventListener {
    private transient int _ident = 0;

    @Override
    public void enteringDirectory(File theDirectory) {
        ++this._ident;
        R01FLog.to("r01f.util").fine(String.valueOf(this._identText().toString()) + "[d] " + theDirectory.getName());
    }

    @Override
    public void exitingDirectory(File theDirectory) {
        --this._ident;
    }

    @Override
    public void file(File theFile) {
        R01FLog.to("r01f.util").fine(this._identText() + "\t" + theFile.getName());
    }

    private StringBuffer _identText() {
        StringBuffer outIdent = new StringBuffer("");
        int i = 0;
        while (i < this._ident) {
            outIdent.append("\t");
            ++i;
        }
        return outIdent;
    }
}

