/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.file;

import com.ejie.r01f.file.DirectoryWalkerEventListener;
import com.ejie.r01f.log.R01FLog;
import java.io.File;

public class DirectoryWalkerFileNameChanger
implements DirectoryWalkerEventListener {
    private transient int _ident = 0;
    private transient File _currDir = null;

    @Override
    public void enteringDirectory(File theDirectory) {
        this._currDir = theDirectory;
        ++this._ident;
        R01FLog.to("r01f.util").fine(String.valueOf(this._identText().toString()) + "[d] " + theDirectory.getName());
    }

    @Override
    public void exitingDirectory(File theDirectory) {
        --this._ident;
    }

    @Override
    public void file(File theFile) {
        R01FLog.to("r01f.util").fine(String.valueOf(this._identText().toString()) + "\t" + theFile.getName());
        if (theFile.getName().startsWith("r46-")) {
            String newFileName = "r59-" + theFile.getName().substring(4);
            theFile.renameTo(new File(this._currDir, newFileName));
            R01FLog.to("r01f.util").fine("El nuevo nombre del fichero es: " + newFileName);
        }
    }

    private StringBuffer _identText() {
        StringBuffer outIdent = new StringBuffer();
        int i = 0;
        while (i < this._ident) {
            outIdent.append('\t');
            ++i;
        }
        return outIdent;
    }
}

