/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.file;

import com.ejie.r01f.file.DirectoryWalkerEventListener;
import com.ejie.r01f.file.DirectoryWalkerFileNameChanger;
import com.ejie.r01f.log.R01FLog;
import java.io.File;
import java.io.FileFilter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.logging.Level;

public class DirectoryWalker
implements Iterator {
    private static final boolean DEBUG = R01FLog.getLogLevel("r01f.util") == null || R01FLog.getLogLevel("r01f.util").intValue() != Level.OFF.intValue();
    private transient String _startingDirectory = null;
    private transient LinkedList _dirStack = null;
    private transient File _nextFile = null;
    private transient LinkedList _events = new LinkedList();
    private transient DirectoryWalkerEventListener _listener = null;
    private transient FileFilter _filter = null;
    private transient int _ident = 0;

    public DirectoryWalker(String startingDirectory) {
        this.setStartingDirectory(startingDirectory);
        this._nextFile = this._walk();
    }

    public DirectoryWalker(String startingDirectory, DirectoryWalkerEventListener listener) {
        this.setStartingDirectory(startingDirectory);
        this.setListener(listener);
        this._nextFile = this._walk();
    }

    public DirectoryWalker(String startingDirectory, FileFilter filter) {
        this._filter = filter;
        this.setStartingDirectory(startingDirectory);
        this._nextFile = this._walk();
    }

    public DirectoryWalker(String startingDirectory, DirectoryWalkerEventListener listener, FileFilter filter) {
        this._filter = filter;
        this.setStartingDirectory(startingDirectory);
        this.setListener(listener);
        this._nextFile = this._walk();
    }

    public void setStartingDirectory(String startingDirectory) {
        if (startingDirectory == null || startingDirectory.length() == 0) {
            throw new IllegalArgumentException("El directorio para empezar el recorrido no es v\u00e1lido");
        }
        this._startingDirectory = startingDirectory;
        File startingDir = new File(this._startingDirectory);
        if (!startingDir.exists() || !startingDir.isDirectory()) {
            throw new IllegalArgumentException("El directorio " + this._startingDirectory + " no existe o no es un directorio");
        }
        this._dirStack = new LinkedList();
        this._processDir(startingDir);
    }

    public String getStartingDirectory() {
        return this._startingDirectory;
    }

    public void setListener(DirectoryWalkerEventListener listener) {
        this._listener = listener;
    }

    public DirectoryWalkerEventListener getListener() {
        return this._listener;
    }

    @Override
    public boolean hasNext() {
        return this._nextFile != null;
    }

    /*
     * Unable to fully structure code
     */
    public Object next() {
        outFile = this._nextFile;
        if (outFile != null) ** GOTO lbl5
        throw new NoSuchElementException("No hay mas ficheros o directorios para procesar");
lbl-1000:
        // 1 sources

        {
            ((WalkerEvent)this._events.removeFirst()).throwEvent();
lbl5:
            // 2 sources

            ** while (!this._events.isEmpty())
        }
lbl6:
        // 1 sources

        this._nextFile = this._walk();
        return outFile;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operacion no soportada: No se puede borrar un fichero utilizando esta clase");
    }

    private void _processDir(File dir) {
        DirContext dirCtx = new DirContext(dir);
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isFile()) {
                    if (this._filter != null && this._filter.accept(files[i])) {
                        dirCtx.addFile(files[i]);
                    } else if (this._filter == null) {
                        dirCtx.addFile(files[i]);
                    }
                } else if (files[i].isDirectory()) {
                    dirCtx.addDir(files[i]);
                }
                ++i;
            }
        }
        this._dirStack.addLast(dirCtx);
    }

    private void _pushEvent(int eventCode, File eventSource) {
        if (this._listener == null || eventSource == null) {
            if (DEBUG) {
                R01FLog.to("r01f.util").finest("EventSource = null!!!!");
            }
            return;
        }
        this._events.addLast(new WalkerEvent(eventCode, eventSource));
    }

    private File _walk() {
        File currItem = null;
        StringBuffer logStr = new StringBuffer();
        do {
            if (this._dirStack.isEmpty()) {
                return null;
            }
            DirContext dirCtx = (DirContext)this._dirStack.getLast();
            currItem = dirCtx.getNextFile();
            if (currItem == null) {
                currItem = dirCtx.getNextDir();
                if (currItem != null) {
                    this._processDir(currItem);
                    ++this._ident;
                    this._pushEvent(1, currItem);
                }
            } else {
                this._pushEvent(0, currItem);
            }
            if (currItem == null) {
                --this._ident;
                DirContext exitedDir = (DirContext)this._dirStack.removeLast();
                this._pushEvent(2, exitedDir.dir);
            }
            if (currItem == null || !DEBUG) continue;
            logStr.setLength(0);
            logStr.append(this._identText());
            logStr.append(currItem.isFile() ? "\t" : "[d] ");
            logStr.append(currItem.getName());
            R01FLog.to("r01f.util").fine(logStr.toString());
        } while (currItem == null);
        return currItem;
    }

    private StringBuffer _identText() {
        StringBuffer outIdent = new StringBuffer("");
        int i = 0;
        while (i < this._ident) {
            outIdent.append("\t");
            ++i;
        }
        return outIdent;
    }

    public static void main(String[] args) {
        try {
            long t1 = System.currentTimeMillis();
            int testTimes = 1;
            int times = 0;
            while (times < testTimes) {
                DirectoryWalker dirWalk = new DirectoryWalker("d:/test", new DirectoryWalkerFileNameChanger());
                while (dirWalk.hasNext()) {
                    dirWalk.next();
                }
                R01FLog.to("r01f.test").fine("---> Finito!!!");
                ++times;
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to("r01f.test").fine("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg - " + (t2 - t1) + "msg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private class DirContext {
        private transient File dir = null;
        private transient LinkedList _files = null;
        private transient LinkedList _dirs = null;

        DirContext(File newDir) {
            this.dir = newDir;
        }

        void addFile(File file) {
            if (this._files == null) {
                this._files = new LinkedList();
            }
            this._files.addLast(file);
        }

        void addDir(File theDir) {
            if (this._dirs == null) {
                this._dirs = new LinkedList();
            }
            this._dirs.addLast(theDir);
        }

        File getNextFile() {
            if (this._files != null && this._files.size() > 0) {
                return (File)this._files.removeLast();
            }
            return null;
        }

        File getNextDir() {
            if (this._dirs != null && this._dirs.size() > 0) {
                return (File)this._dirs.removeLast();
            }
            return null;
        }
    }

    private class WalkerEvent {
        private transient int _code = -1;
        private transient File _source = null;
        static final int EVENT_FILE = 0;
        static final int EVENT_ENTERING_DIR = 1;
        static final int EVENT_EXITING_DIR = 2;

        WalkerEvent(int eventCode, File eventSource) {
            this._code = eventCode;
            this._source = eventSource;
        }

        void throwEvent() {
            switch (this._code) {
                case 0: {
                    DirectoryWalker.this._listener.file(this._source);
                    break;
                }
                case 1: {
                    DirectoryWalker.this._listener.enteringDirectory(this._source);
                    break;
                }
                case 2: {
                    DirectoryWalker.this._listener.exitingDirectory(this._source);
                }
            }
        }

        public int hashCode() {
            return this._code & this._source.hashCode();
        }
    }
}

