/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.exceptions;

import com.ejie.r01f.exceptions.R01FBaseException;

public final class ExceptionFormatter {
    public static String getShortMsg(Exception ex) {
        return ExceptionFormatter.getShortMsg(ex, null);
    }

    public static String getShortMsg(Exception ex, String inMsg) {
        StackTraceElement[] stackElements = ex.getStackTrace();
        long exNumber = -1L;
        String msg = inMsg;
        if (ex.getClass().isAssignableFrom(R01FBaseException.class)) {
            exNumber = ((R01FBaseException)ex).getErrorNumber();
            if (msg == null) {
                msg = ((R01FBaseException)ex).getRawMessage();
            }
        } else {
            exNumber = -1L;
            if (msg == null) {
                msg = "";
            }
        }
        StackTraceElement originator = null;
        if (stackElements != null && stackElements.length > 0 && (originator = stackElements[0]) != null) {
            return "#" + exNumber + "#: " + originator.getClassName() + "." + originator.getMethodName() + "(" + originator.getLineNumber() + "): " + msg;
        }
        return "#" + exNumber + "#: " + msg;
    }

    public static String getLongMsg(Exception ex) {
        return ExceptionFormatter.getLongMsg(ex, null);
    }

    public static String getLongMsg(Exception ex, String inMsg) {
        StackTraceElement[] stackElements = ex.getStackTrace();
        long exNumber = -1L;
        String msg = inMsg;
        if (ex.getClass().isAssignableFrom(R01FBaseException.class)) {
            exNumber = ((R01FBaseException)ex).getErrorNumber();
            if (msg == null) {
                msg = ((R01FBaseException)ex).getRawMessage();
            }
        } else {
            exNumber = -1L;
            if (msg == null) {
                msg = ex.getMessage();
            }
        }
        if (stackElements != null && stackElements.length > 0) {
            StringBuffer exSb = new StringBuffer(78);
            exSb.append("\r\nEXCEPTION!!!!!!_______________________________________________________\r\nERROR    : #");
            exSb.append(exNumber);
            exSb.append("#: ");
            exSb.append(msg);
            exSb.append("\r\nFICHERO  : ");
            exSb.append(stackElements[0].getFileName());
            exSb.append("\r\nCLASE    : ");
            exSb.append(stackElements[0].getClassName());
            exSb.append("\r\nMETODO   : ");
            exSb.append(stackElements[0].getMethodName());
            exSb.append("\r\nPILA DE LLAMADAS _____________________________________________________ \r\n");
            int i = 0;
            while (i < stackElements.length) {
                exSb.append(stackElements[i].getClassName());
                exSb.append('.');
                exSb.append(stackElements[i].getMethodName());
                exSb.append('(');
                exSb.append(stackElements[i].getLineNumber());
                exSb.append(")\r\n");
                ++i;
            }
            exSb.append("______________________________________________________________________\r\n");
            return exSb.toString();
        }
        return ExceptionFormatter.getShortMsg(ex);
    }

    public static String getXML(Exception ex) {
        return ExceptionFormatter.getXML(ex, null);
    }

    public static String getXML(Exception ex, String inMsg) {
        StringBuffer exSb = new StringBuffer(70);
        exSb.append("<exceptionStack>");
        Exception currEx = ex;
        while (currEx != null) {
            exSb.append("<exception>");
            StackTraceElement[] stackElements = currEx.getStackTrace();
            long exNumber = -1L;
            String msg = inMsg;
            if (currEx.getClass().isAssignableFrom(R01FBaseException.class)) {
                exNumber = ((R01FBaseException)currEx).getErrorNumber();
                if (msg == null) {
                    msg = ((R01FBaseException)currEx).getRawMessage();
                }
            } else {
                exNumber = -1L;
                if (msg == null) {
                    msg = currEx.getMessage();
                }
            }
            if (stackElements != null && stackElements.length > 0) {
                exSb.append("\t<error code='");
                exSb.append(exNumber);
                exSb.append("'>");
                exSb.append(msg);
                exSb.append("</error>\r\n\t<stack>\r\n");
                int i = 0;
                while (i < stackElements.length) {
                    exSb.append("\t\t<element>\r\n\t\t\t<file>");
                    exSb.append(stackElements[i].getFileName());
                    exSb.append("</file>\r\n\t\t\t<class>");
                    exSb.append(stackElements[i].getClassName());
                    exSb.append("</class>\r\n\t\t\t<method>");
                    exSb.append(stackElements[i].getMethodName());
                    exSb.append("</method>\r\n\t\t\t<line>");
                    exSb.append(stackElements[i].getLineNumber());
                    exSb.append("</line>\r\n\t</element>\r\n");
                    ++i;
                }
                exSb.append("\t</stack>\r\n");
            }
            exSb.append("</exception>");
            currEx = (Exception)currEx.getCause();
        }
        exSb.append("</exceptionStack>");
        return exSb.toString();
    }

    public static String getHTML(Exception ex) {
        return ExceptionFormatter.getHTML(ex, null);
    }

    public static String getHTML(Exception ex, String inMsg) {
        StringBuffer exSb = new StringBuffer(110);
        exSb.append("<table width='100%'>\r\n<tr><td><h1>EXCEPTION!!!!!!</h1></td></tr>\r\n");
        Exception currEx = ex;
        while (currEx != null) {
            StackTraceElement[] stackElements = currEx.getStackTrace();
            String msg = inMsg;
            if (currEx.getClass().isAssignableFrom(R01FBaseException.class)) {
                if (msg == null) {
                    msg = ((R01FBaseException)currEx).getRawMessage();
                }
            } else if (msg == null) {
                msg = currEx.getMessage();
            }
            if (stackElements != null && stackElements.length > 0) {
                exSb.append("<tr><td><h4>");
                exSb.append(msg);
                exSb.append("</h4></td></tr>\r\n<tr><td>\r\n<table width='100%' style='border:1px solid'>\r\n<tr>\r\n<td valign='top'><h2>File</h2></td>\r\n<td valign='top'><h2>Class</h2></td>\r\n<td valign='top'><h2>Method</h2></td>\r\n<td valign='top'><h2>Line</h2></td>\r\n</tr>\r\n");
                int i = 0;
                while (i < stackElements.length) {
                    exSb.append("<tr>\r\n<td valign='top'>");
                    exSb.append(stackElements[i].getFileName());
                    exSb.append("</td>\r\n<td valign='top'>");
                    exSb.append(stackElements[i].getClassName());
                    exSb.append("</td>\r\n<td valign='top'>");
                    exSb.append(stackElements[i].getMethodName());
                    exSb.append("</td>\r\n<td valign='top'>");
                    exSb.append(stackElements[i].getLineNumber());
                    exSb.append("</td>\r\n</tr>\r\n");
                    ++i;
                }
                exSb.append("\t\t</table>\r\n</tr></td>\r\n</table>\r\n");
            }
            currEx = (Exception)currEx.getCause();
        }
        return exSb.toString();
    }
}

