/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.debug;

import com.ejie.r01f.debug.CheckException;
import com.ejie.r01f.debug.PreconditionException;
import com.ejie.r01f.util.StringUtils;

public abstract class DebugUtils {
    private static String _name = "EJIE";
    public static final boolean precs = true;
    public static final boolean checks = true;

    public static final void check(boolean condition, String reason) {
        if (!condition) {
            throw new CheckException(reason);
        }
    }

    public static final void check(boolean condition) {
        DebugUtils.check(condition, "Check failed[" + _name + "]: invoked method should be fixed");
    }

    public static final void check(Object notNull) {
        DebugUtils.check(notNull != null, "Check failed[" + _name + "]: null reference found");
    }

    public static final void check(String notEmpty) {
        DebugUtils.check(notEmpty != null && !StringUtils.isEmptyString(notEmpty), "Check failed[" + _name + "]: Empty String");
    }

    public static final void prec(boolean condition, String reason) {
        if (!condition) {
            throw new PreconditionException(reason);
        }
    }

    public static final void prec(Object notNull) {
        DebugUtils.prec(notNull != null, "Precondition failed[" + _name + "]: null parameter");
    }

    public static final void prec(Object notNull, String msg) {
        DebugUtils.prec(notNull != null, msg);
    }

    public static final void prec(String notEmpty) {
        DebugUtils.prec(notEmpty != null && !StringUtils.isEmptyString(notEmpty), "Precondition failed[" + _name + "]: empty string parameter");
    }

    public static final void prec(String notEmpty, String msg) {
        DebugUtils.prec(notEmpty != null && !StringUtils.isEmptyString(notEmpty), msg);
    }
}

