/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.collections;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SoftHashMap
extends AbstractMap
implements Map {
    private Map _table;
    private Set _entrySet = null;
    private ReferenceQueue _queue = new ReferenceQueue();

    private void _processQueue() {
        ValueCell vc;
        while ((vc = (ValueCell)this._queue.poll()) != null) {
            if (vc.isValid()) {
                this._table.remove(vc.key);
                continue;
            }
            ValueCell.dropped = ValueCell.dropped - 1;
        }
    }

    public SoftHashMap() {
        this._table = new HashMap();
    }

    public SoftHashMap(int initialCapacity, float loadFactor) {
        this._table = new HashMap(initialCapacity, loadFactor);
    }

    public SoftHashMap(int initialCapacity) {
        this._table = new HashMap(initialCapacity);
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        ValueCell vc = (ValueCell)this._table.get(key);
        return ValueCell.strip(vc, false) != null;
    }

    public Object get(Object key) {
        this._processQueue();
        Object v = this._table.get(key);
        return ValueCell.strip(v, false);
    }

    public Object put(Object key, Object value) {
        this._processQueue();
        ValueCell vc = ValueCell.create(key, value, this._queue);
        ValueCell prevVC = this._table.put(key, vc);
        return ValueCell.strip(prevVC, true);
    }

    public Object remove(Object key) {
        this._processQueue();
        ValueCell removedVC = (ValueCell)this._table.remove(key);
        return ValueCell.strip(removedVC, true);
    }

    @Override
    public void clear() {
        this._processQueue();
        this._table.clear();
    }

    private static boolean valEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public Set entrySet() {
        if (this._entrySet == null) {
            this._entrySet = new EntrySet();
        }
        return this._entrySet;
    }

    private class Entry
    implements Map.Entry {
        private Map.Entry ent;
        private Object value;

        Entry(Map.Entry ent, Object value) {
            this.ent = ent;
            this.value = value;
        }

        public Object getKey() {
            return this.ent.getKey();
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            return this.ent.setValue(ValueCell.create(this.ent.getKey(), value, SoftHashMap.this._queue));
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return SoftHashMap.valEquals(this.ent.getKey(), e.getKey()) && SoftHashMap.valEquals(this.value, e.getValue());
        }

        @Override
        public int hashCode() {
            Object k = this.getKey();
            return (k == null ? 0 : k.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }

    private class EntrySet
    extends AbstractSet {
        Set hashEntries;

        private EntrySet() {
            this.hashEntries = SoftHashMap.this._table.entrySet();
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                Iterator hashIterator;
                Entry next;
                {
                    this.hashIterator = EntrySet.this.hashEntries.iterator();
                    this.next = null;
                }

                @Override
                public boolean hasNext() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry ent = (Map.Entry)this.hashIterator.next();
                        ValueCell vc = (ValueCell)ent.getValue();
                        Object v = null;
                        if (vc != null) {
                            Object t = vc.get();
                            v = t;
                            if (t == null) continue;
                        }
                        this.next = new Entry(ent, v);
                        return true;
                    }
                    return false;
                }

                public Object next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Entry e = this.next;
                    this.next = null;
                    return e;
                }

                @Override
                public void remove() {
                    this.hashIterator.remove();
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public int size() {
            int j = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ++j;
                i.next();
            }
            return j;
        }

        @Override
        public boolean remove(Object o) {
            SoftHashMap.this._processQueue();
            if (o instanceof Entry) {
                return this.hashEntries.remove(((Entry)o).ent);
            }
            return false;
        }
    }

    private static class ValueCell
    extends SoftReference {
        private static Object INVALID_KEY = new Object();
        private static int dropped = 0;
        private Object key;

        private ValueCell(Object key, Object value, ReferenceQueue queue) {
            super(value, queue);
            this.key = key;
        }

        private static ValueCell create(Object key, Object value, ReferenceQueue queue) {
            if (value == null) {
                return null;
            }
            return new ValueCell(key, value, queue);
        }

        private void drop() {
            super.clear();
            this.key = INVALID_KEY;
            ++dropped;
        }

        private static Object strip(Object val, boolean drop) {
            if (val == null) {
                return null;
            }
            ValueCell vc = (ValueCell)val;
            Object o = vc.get();
            if (drop) {
                vc.drop();
            }
            return o;
        }

        private boolean isValid() {
            return this.key != INVALID_KEY;
        }
    }
}

