/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.businessdelegate;

import com.ejie.r01f.businessdelegate.BaseBusinessDelegateInvocationHandler;
import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.rpcdispatcher.RPCCall;
import com.ejie.r01f.rpcdispatcher.RPCCallResultParser;
import com.ejie.r01f.rpcdispatcher.RPCClient;
import com.ejie.r01f.rpcdispatcher.RPCFunction;
import com.ejie.r01f.rpcdispatcher.RPCParameter;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.NumberUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.MarshallerArrayContainer;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.Date;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.SAXException;

class RPCServletBusinessDelegateInvocationHandler
extends BaseBusinessDelegateInvocationHandler {
    private static Map _rpcCfgCache = new HashMap();
    public static long NO_TIME_OUT = -1L;

    public RPCServletBusinessDelegateInvocationHandler() {
    }

    public RPCServletBusinessDelegateInvocationHandler(String newAppCode, String newBzdOid) throws BzdConfigException {
        super(newAppCode, newBzdOid);
        this._init();
    }

    public RPCServletBusinessDelegateInvocationHandler(String newAppCode, String newBzdOid, String newRpcServletURL, String newRpcModule, String newXOMapFile) throws BzdConfigException {
        this(newAppCode, newBzdOid, newRpcServletURL, newRpcModule, newXOMapFile, NO_TIME_OUT, null, null, null, null);
    }

    public RPCServletBusinessDelegateInvocationHandler(String newAppCode, String newBzdOid, String newRpcServletURL, String newRpcModule, String newXOMapFile, long newConxTimeOut) throws BzdConfigException {
        this(newAppCode, newBzdOid, newRpcServletURL, newRpcModule, newXOMapFile, newConxTimeOut, null, null, null, null);
    }

    public RPCServletBusinessDelegateInvocationHandler(String newAppCode, String newBzdOid, String newRpcServletURL, String newRpcModule, String newXOMapFile, long newConxTimeOut, String newProxyHost, String newProxyPort) throws BzdConfigException {
        this(newAppCode, newBzdOid, newRpcServletURL, newRpcModule, newXOMapFile, newConxTimeOut, newProxyHost, newProxyPort, null, null);
    }

    public RPCServletBusinessDelegateInvocationHandler(String newAppCode, String newBzdOid, String newRpcServletURL, String newRpcModule, String newXOMapFile, long newConxTimeOut, String newProxyHost, String newProxyPort, String newProxyUsr, String newProxyPwd) throws BzdConfigException {
        super(newAppCode, newBzdOid);
        RPCServletConfigWrapper cfg = new RPCServletConfigWrapper(newAppCode, newBzdOid);
        cfg.rpcServletURL = newRpcServletURL;
        cfg.rpcModule = newRpcModule;
        cfg.conxTimeout = newConxTimeOut;
        boolean bl = cfg.proxyRequired = newProxyHost != null && newProxyHost.length() > 0;
        if (cfg.proxyRequired) {
            cfg.proxyHost = newProxyHost;
            String string = cfg.proxyPort = newProxyPort != null ? newProxyPort : "8080";
            if (newProxyUsr != null && newProxyPwd != null) {
                cfg.proxyAuthRequired = true;
                cfg.proxyUsr = newProxyUsr;
                cfg.proxyPwd = newProxyPwd;
            }
        }
        _rpcCfgCache.put(cfg.rpcKey, cfg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object doInvoke(Method method, Object[] args) throws Throwable {
        RPCServletConfigWrapper cfg = (RPCServletConfigWrapper)_rpcCfgCache.get(String.valueOf(this.getAppCode()) + "." + this.getBzdOid());
        if (cfg == null) {
            R01FLog.to("r01f.bzd").severe("NO se ha podido encontrar la configuraci\u00f3n de BZD para proxy RPC = " + this.getAppCode() + "." + this.getBzdOid());
            return null;
        }
        if (DEBUG) {
            R01FLog.to("r01f.bzd").fine(cfg.composeDebugInfo());
        }
        if (DEBUG) {
            R01FLog.to("r01f.bzd").info("Invocando el metodo (" + method + ") en modulo " + cfg.rpcModule + " del RPCServlet " + cfg.rpcServletURL);
        }
        RPCCall rpcCall = new RPCCall(cfg.rpcModule);
        RPCFunction function = new RPCFunction(method.getName());
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (args[i].getClass().equals(String.class)) {
                    function.putParameter(new RPCParameter("param" + i, "String", args[i].toString()));
                } else if (args[i].getClass().equals(Integer.class)) {
                    function.putParameter(new RPCParameter("param" + i, "int", args[i].toString()));
                } else if (args[i].getClass().equals(Long.class)) {
                    function.putParameter(new RPCParameter("param" + i, "long", args[i].toString()));
                } else if (args[i].getClass().equals(Double.class)) {
                    function.putParameter(new RPCParameter("param" + i, "double", args[i].toString()));
                } else if (args[i].getClass().equals(Float.class)) {
                    function.putParameter(new RPCParameter("param" + i, "float", args[i].toString()));
                } else if (args[i].getClass().equals(Boolean.class)) {
                    function.putParameter(new RPCParameter("param" + i, "Boolean", args[i].toString()));
                } else if (args[i].getClass().equals(java.util.Date.class) || args[i].getClass().equals(Date.class)) {
                    function.putParameter(new RPCParameter("param" + i, "Date", DateUtils.getDateFormated((java.util.Date)args[i], "dd/MM/yyyy-hh:mm:ss:SSS")));
                } else if (args[i].getClass().isArray()) {
                    try {
                        if (DEBUG) {
                            R01FLog.to("r01f.bzd").fine("El parametro es de tipo array... se encapsula el array en un objeto MarshallerArrayContainer y se pasa a XML utilizando el fichero de mapeo " + cfg.xoMapFile);
                        }
                        MarshallerArrayContainer arrayContainer = new MarshallerArrayContainer((Object[])args[i]);
                        String[] oids = (String[])arrayContainer.array;
                        String xml = XOManager.getXML(cfg.xoMapFile, (Object)arrayContainer);
                        function.putParameter(new RPCParameter("param" + i, "XML", xml));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else {
                    if (DEBUG) {
                        R01FLog.to("r01f.bzd").fine("El parametro es de tipo complejo... se convierte a XML utilizando el fichero de mapeo " + cfg.xoMapFile);
                    }
                    String xml = XOManager.getXML(cfg.xoMapFile, args[i]);
                    function.putParameter(new RPCParameter("param" + i, "XML", xml));
                }
                ++i;
            }
        }
        rpcCall.addFunction(function);
        if (DEBUG) {
            R01FLog.to("r01f.bzd").info("\n\nHaciendo llamada al servlet RPC Remoto " + cfg.rpcServletURL + "\r\n" + rpcCall.toXML());
        }
        RPCClient rpcClient = null;
        if (cfg.proxyHost == null && cfg.proxyPort == null) {
            if (DEBUG) {
                R01FLog.to("r01f.bzd").info("\nHaciendo llamada al servlet RPC Remoto " + cfg.rpcServletURL + "\r\n" + rpcCall.toXML());
            }
            rpcClient = new RPCClient(cfg.rpcServletURL);
        } else {
            if (DEBUG) {
                R01FLog.to("r01f.bzd").info("\nHaciendo llamada al servlet RPC Remoto " + cfg.rpcServletURL + " atraves del PROXY :" + cfg.proxyHost + ":" + cfg.proxyPort + "\r\n" + rpcCall.toXML());
            }
            rpcClient = new RPCClient(cfg.rpcServletURL, cfg.proxyHost, cfg.proxyPort);
            if (cfg.proxyUsr != null && cfg.proxyPwd != null) {
                rpcClient.setProxyAuthorization(cfg.proxyUsr, cfg.proxyPwd);
            }
        }
        if (cfg.conxTimeout != NO_TIME_OUT) {
            rpcClient.setTimeOut(cfg.conxTimeout);
        }
        String resultXML = null;
        try {
            InputStream is = rpcClient.sendPostRPCCall(rpcCall);
            resultXML = StringUtils.loadFromStream(is);
        }
        catch (Throwable tr) {
            tr.printStackTrace();
            throw tr;
        }
        if (method.getReturnType().equals(Void.class)) {
            return null;
        }
        if (!(method.getReturnType().equals(Void.class) || method.getReturnType().equals(String.class) || method.getReturnType().equals(Integer.class) || method.getReturnType().equals(Long.class) || method.getReturnType().equals(Double.class) || method.getReturnType().equals(Float.class) || method.getReturnType().equals(Boolean.class) || method.getReturnType().equals(java.util.Date.class))) {
            method.getReturnType().equals(Date.class);
        }
        String returnValue = null;
        RPCCallResultParser callResult = null;
        try {
            if (!resultXML.startsWith("<?xml version='1.0' encoding='ISO-8859-1'?>")) {
                resultXML = "<?xml version='1.0' encoding='ISO-8859-1'?>" + resultXML;
            }
            callResult = new RPCCallResultParser(new ByteArrayInputStream(resultXML.getBytes()));
            if (DEBUG) {
                R01FLog.to("r01f.bzd").info("Respuesta recibida del RPCServlet:\r\n" + callResult.composeDebugInfo());
            }
        }
        catch (SAXException saxEx) {
            saxEx.printStackTrace(System.out);
            R01FLog.to("r01f.bzd").warning("No se ha podido parsear el XML de respuesta del servlet RPC. Se devuelve null!!!");
            return null;
        }
        if (callResult.resultTypeCode == 16) {
            if (callResult.resultType != null) {
                Object ex = null;
                try {
                    ex = ReflectionUtils.getObjectInstance(callResult.resultType, new Class[]{String.class}, new Object[]{callResult.resultValue != null ? callResult.resultValue.toString() : "R01F: Unknown Exception"}, true);
                    throw (Throwable)ex;
                }
                catch (ReflectionException refEx) {
                    R01FLog.to("r01f.bzd").warning("No se ha podido instanciar la excepcion de tipo '" + callResult.resultType + "'. Se lanza una excepcion normal!!!");
                    throw new Exception(returnValue != null ? returnValue.toString() : "R01F: Unknown Exception");
                }
            }
            R01FLog.to("r01f.bzd").warning("No se conoce el tipo concreto de excepcion. Se lanza una excepcion normal!!!");
            throw new Exception("R01F: Unknown Exception");
        }
        if (callResult.resultValue == null) return returnValue;
        if (callResult.resultTypeCode == -1) {
            R01FLog.to("r01f.bzd").warning("El tipo de retorno devuelto por el servlet RPC es UNKNOWN. Si el metodo devuelve un tipo String, se devuelve el valor devuelto, en otro caso se devuelve null!!!");
            if (method.getReturnType().equals(String.class)) return null;
            return callResult.resultValue.toString();
        }
        if (callResult.resultTypeCode == 2) {
            if (!callResult.resultType.equals(method.getReturnType().getName())) {
                throw new Exception("El tipo de objeto " + method.getReturnType().getName() + " devuelto por el metodo " + method.getName() + " NO coincide con el devuelto por el m\u00e9todo correspondiente en el modulo RPC");
            }
            try {
                return XOManager.getObject(cfg.xoMapFile, (InputStream)new ByteArrayInputStream(("<?xml version='1.0' encoding='ISO-8859-1'?>" + callResult.resultValue.toString()).getBytes()));
            }
            catch (XOMarshallerException xoEx) {
                xoEx.printStackTrace(System.out);
                R01FLog.to("r01f.bzd").warning("No se ha podido pasar a objeto el resultado de la llamada RPC: " + callResult.resultValue.toString() + "\r\n" + xoEx.getMessage() + "\r\nSe devuelve null!!!!!");
                return null;
            }
        }
        if (callResult.resultTypeCode == 3) {
            if (method.getReturnType().equals(String.class)) return callResult.resultValue.toString();
            try {
                return XOManager.getObject(cfg.xoMapFile, (InputStream)new ByteArrayInputStream(("<?xml version='1.0' encoding='ISO-8859-1'?>" + callResult.resultValue.toString()).getBytes()));
            }
            catch (XOMarshallerException xoEx) {
                xoEx.printStackTrace(System.out);
                R01FLog.to("r01f.bzd").warning("No se ha podido pasar a objeto el resultado de la llamada RPC: " + callResult.resultValue.toString() + "\r\n" + xoEx.getMessage() + "\r\nSe devuelve null!!!!!");
                return null;
            }
        }
        if (callResult.resultTypeCode == 4) {
            if (method.getReturnType().equals(Integer.class)) return new Integer(callResult.resultValue.toString());
            throw new Exception("El metodo RPC remoto ha devuelto un java.lang.Integer sin embargo, el BZD establece que devuelve un " + method.getReturnType().getName());
        }
        if (callResult.resultTypeCode == 6) {
            if (method.getReturnType().equals(Long.class)) return new Long(callResult.resultValue.toString());
            throw new Exception("El metodo RPC remoto ha devuelto un java.lang.Long sin embargo, el BZD establece que devuelve un " + method.getReturnType().getName());
        }
        if (callResult.resultTypeCode == 8) {
            if (method.getReturnType().equals(Double.class)) return new Double(callResult.resultValue.toString());
            throw new Exception("El metodo RPC remoto ha devuelto un java.lang.Double sin embargo, el BZD establece que devuelve un " + method.getReturnType().getName());
        }
        if (callResult.resultTypeCode == 10) {
            if (method.getReturnType().equals(Float.class)) return new Double(callResult.resultValue.toString());
            throw new Exception("El metodo RPC remoto ha devuelto un java.lang.Float sin embargo, el BZD establece que devuelve un " + method.getReturnType().getName());
        }
        if (callResult.resultTypeCode == 12) {
            if (!method.getReturnType().equals(Boolean.class)) {
                throw new Exception("El metodo RPC remoto ha devuelto un java.lang.Boolean sin embargo, el BZD establece que devuelve un " + method.getReturnType().getName());
            }
            String booleanVal = callResult.resultValue.toString();
            if (booleanVal.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (!booleanVal.equalsIgnoreCase("false")) throw new Exception("Valor incorrecto para un tipo de retorno boolean: " + booleanVal);
            return Boolean.FALSE;
        }
        if (callResult.resultTypeCode != 14) return returnValue;
        if (method.getReturnType().equals(java.util.Date.class)) return DateUtils.getDateFromFormatedString(callResult.resultValue.toString(), "dd/MM/yyyy");
        if (method.getReturnType().equals(Date.class)) return DateUtils.getDateFromFormatedString(callResult.resultValue.toString(), "dd/MM/yyyy");
        throw new Exception("El metodo RPC remoto ha devuelto un java.util.Date sin embargo, el BZD establece que devuelve un " + method.getReturnType().getName());
    }

    private void _init() throws BzdConfigException {
        RPCServletConfigWrapper cfg = (RPCServletConfigWrapper)_rpcCfgCache.get(String.valueOf(this.getAppCode()) + "." + this.getBzdOid());
        if (cfg == null) {
            String proxyRequired;
            cfg = new RPCServletConfigWrapper(this.getAppCode(), this.getBzdOid());
            cfg.rpcServletURL = BaseBusinessDelegateInvocationHandler.getBzdConfigProperty(this.getAppCode(), this.getBzdOid(), "rpcServlet", "bzdRemote/rpcServlet");
            cfg.rpcModule = BaseBusinessDelegateInvocationHandler.getBzdConfigProperty(this.getAppCode(), this.getBzdOid(), "module", "bzdRemote/module");
            cfg.xoMapFile = BaseBusinessDelegateInvocationHandler.getBzdConfigProperty(this.getAppCode(), this.getBzdOid(), "xoMapFile", "bzdRemote/xoMapFile");
            String timeOutStr = BaseBusinessDelegateInvocationHandler.getBzdConfigProperty(this.getAppCode(), this.getBzdOid(), "timeOutVariable", "bzdRemote/timeout");
            if (NumberUtils.isLong(timeOutStr)) {
                cfg.conxTimeout = Long.parseLong(timeOutStr);
            }
            boolean bl = (proxyRequired = BaseBusinessDelegateInvocationHandler.getBzdConfigProperty(this.getAppCode(), this.getBzdOid(), "proxyRequired", "bzdRemote/proxy/@required")) != null ? proxyRequired.equalsIgnoreCase("true") : (cfg.proxyRequired = false);
            if (cfg.proxyRequired) {
                cfg.proxyHost = BaseBusinessDelegateInvocationHandler.getBzdConfigProperty(this.getAppCode(), this.getBzdOid(), "proxyHost", "bzdRemote/proxy/host");
                cfg.proxyPort = BaseBusinessDelegateInvocationHandler.getBzdConfigProperty(this.getAppCode(), this.getBzdOid(), "proxyPort", "bzdRemote/proxy/port");
                String authRequired = BaseBusinessDelegateInvocationHandler.getBzdConfigProperty(this.getAppCode(), this.getBzdOid(), "authorizationRequired", "bzdRemote/proxy/authorization/@required");
                boolean bl2 = authRequired != null ? authRequired.equalsIgnoreCase("true") : (cfg.proxyAuthRequired = false);
                if (cfg.proxyAuthRequired) {
                    cfg.proxyUsr = BaseBusinessDelegateInvocationHandler.getBzdConfigProperty(this.getAppCode(), this.getBzdOid(), "proxyUsr", "bzdRemote/proxy/authorization/usr");
                    cfg.proxyPwd = BaseBusinessDelegateInvocationHandler.getBzdConfigProperty(this.getAppCode(), this.getBzdOid(), "proxyPwd", "bzdRemote/proxy/authorization/pwd");
                }
            }
            _rpcCfgCache.put(cfg.rpcKey, cfg);
        }
        if (cfg.rpcServletURL == null || cfg.rpcModule == null) {
            throw new BzdConfigException("No esta definido el parametro businessDelegatesConfig/businessDelegate[@oid='...']/bzdRemote/rpcServlet o el parametro businessDelegatesConfig/businessDelegate[@oid='...']/bzdRemote/module en el fichero de configuracion de BZD");
        }
    }

    class RPCServletConfigWrapper {
        public transient String rpcKey = null;
        public transient String rpcServletURL = null;
        public transient String rpcModule = null;
        public transient String xoMapFile = null;
        public transient boolean proxyRequired = false;
        public transient String proxyHost = null;
        public transient String proxyPort = null;
        public transient boolean proxyAuthRequired = false;
        public transient String proxyUsr = null;
        public transient String proxyPwd = null;
        public transient long conxTimeout = NO_TIME_OUT;

        public RPCServletConfigWrapper() {
        }

        public RPCServletConfigWrapper(String appCode, String bzdOid) {
            this.rpcKey = String.valueOf(appCode) + "." + bzdOid;
        }

        public String composeDebugInfo() {
            StringBuffer sb = new StringBuffer(131);
            sb.append("--Configuraci\u00f3n de acceso RPC: ");
            sb.append(this.rpcKey);
            sb.append(" rpcServletURL=");
            sb.append(this.rpcServletURL);
            sb.append('.');
            sb.append(this.rpcModule);
            sb.append("\r\n\t-conxTimeOut=");
            sb.append(this.conxTimeout == NO_TIME_OUT ? "NO TIMEOUT" : Long.toString(this.conxTimeout));
            sb.append("\t-xoMapFile=");
            sb.append(this.xoMapFile);
            sb.append("\t-proxy host:port=");
            sb.append(this.proxyHost);
            sb.append(':');
            sb.append(this.proxyPort);
            sb.append("\t-proxyAuth usr:pwd=");
            sb.append(this.proxyUsr);
            sb.append(':');
            sb.append(this.proxyPwd);
            return sb.toString();
        }
    }
}

