/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.businessdelegate;

import com.ejie.r01f.businessdelegate.BaseBusinessDelegateInvocationHandler;
import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.ejb.EJBAdapter;
import com.ejie.r01f.ejb.ServiceLocator;
import com.ejie.r01f.ejb.ServiceLocatorException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;

class EJBBusinessDelegateInvocationHandler
extends BaseBusinessDelegateInvocationHandler {
    private static Map _ejbCfgCache = new HashMap();
    private transient Object _remoteEJB = null;
    private transient String opDesc = "BZD (EJBBusinessDelegateInvocationHandler) >>>";

    public EJBBusinessDelegateInvocationHandler() {
    }

    public EJBBusinessDelegateInvocationHandler(String newAppCode, String newBzdOid) throws BzdConfigException {
        super(newAppCode, newBzdOid);
        this.opDesc = String.valueOf(this.opDesc) + " aplicacion " + newAppCode + " identificador del Bzd " + newBzdOid;
        this._init();
    }

    public EJBBusinessDelegateInvocationHandler(String newAppCode, String newBzdOid, boolean newCheckLocal, String newEjbJndi, Class newEjbHomeClassDef, String newContextFactory, String newContextURLProvider, String newContextUser, String newContextPassword) throws BzdConfigException {
        this(newAppCode, newBzdOid, newCheckLocal, newEjbJndi, newEjbHomeClassDef.getPackage() + "." + newEjbHomeClassDef.getName(), newContextFactory, newContextURLProvider, newContextUser, newContextPassword);
    }

    public EJBBusinessDelegateInvocationHandler(String newAppCode, String newBzdOid, boolean newCheckLocal, String newEjbJndi, String newEjbHomeClassName, String newContextFactory, String newContextURLProvider, String newContextUser, String newContextPassword) throws BzdConfigException {
        super(newAppCode, newBzdOid);
        EJBConfigWrapper cfg = new EJBConfigWrapper(newAppCode, newBzdOid);
        cfg.checkLocal = newCheckLocal;
        if (cfg.checkLocal) {
            cfg.addLocalEJBProperty("ejbLocalJndi", newEjbJndi);
            cfg.addLocalEJBProperty("ejbLocalHomeClassName", newEjbHomeClassName);
            if (cfg.getLocalEJBProperty("ejbLocalJndi") != null && cfg.getLocalEJBProperty("ejbLocalHomeClassName") != null) {
                cfg.isLocal = ServiceLocator.getInstance(null).checkLocalHomeInterface(cfg.getLocalEJBProperty("ejbLocalJndi"));
            }
        }
        cfg.addRemoteEJBProperty("ejbRemoteJndi", newEjbJndi);
        cfg.addRemoteEJBProperty("ejbRemoteHomeClassName", newEjbHomeClassName);
        cfg.addRemoteEJBProperty("contextFactory", newContextFactory);
        cfg.addRemoteEJBProperty("contextURLProvider", newContextURLProvider);
        cfg.addRemoteEJBProperty("contextUser", newContextUser);
        cfg.addRemoteEJBProperty("contextPassword", newContextPassword);
        _ejbCfgCache.put(cfg.ejbKey, cfg);
    }

    @Override
    Object doInvoke(Method method, Object[] args) throws Throwable {
        if (DEBUG) {
            R01FLog.to("r01f.bzd").info(String.valueOf(this.opDesc) + ".Invocando al EJB ...");
        }
        try {
            this._init();
            if (DEBUG) {
                try {
                    R01FLog.to("r01f.bzd").info(String.valueOf(this.opDesc) + ".Invocar el metodo " + method.getName() + " en el Objeto, con los argumentos:");
                    Class<?>[] params = method.getParameterTypes();
                    if (params != null && params.length > 0) {
                        int i = 0;
                        while (i < params.length) {
                            R01FLog.to("r01f.bzd").info("\targ[" + i + "] : " + params[i].getName());
                            ++i;
                        }
                    }
                    R01FLog.to("r01f.bzd").info(String.valueOf(this.opDesc) + ".Definici\u00f3n de la clase del EJB:");
                    Method[] metodos = this._remoteEJB.getClass().getMethods();
                    if (metodos != null && metodos.length > 0) {
                        StringBuffer metodo = new StringBuffer();
                        int i = 0;
                        while (i < metodos.length) {
                            metodo.setLength(0);
                            metodo.append("\tmetodo: ");
                            metodo.append(metodos[i].getName());
                            metodo.append('(');
                            Class<?>[] paramsMet = method.getParameterTypes();
                            if (paramsMet != null && paramsMet.length > 0) {
                                int j = 0;
                                while (j < paramsMet.length) {
                                    metodo.append(paramsMet[j].getName());
                                    metodo.append(',');
                                    ++j;
                                }
                                metodo.deleteCharAt(metodo.length() - 1);
                            }
                            metodo.append(')');
                            R01FLog.to("r01f.bzd").info(metodo.toString());
                            ++i;
                        }
                    }
                }
                catch (Exception params) {
                    // empty catch block
                }
            }
            Method remoteMethod = this._remoteEJB.getClass().getMethod(method.getName(), method.getParameterTypes());
            return remoteMethod.invoke(this._remoteEJB, args);
        }
        catch (InvocationTargetException invTgtEx) {
            if (DEBUG) {
                R01FLog.to("r01f.bzd").info(String.valueOf(this.opDesc) + ".Error en la invocacion ...");
            }
            if (invTgtEx.getTargetException() instanceof EJBException) {
                Exception cause = ((EJBException)invTgtEx.getTargetException()).getCausedByException();
                if (cause != null) {
                    throw cause;
                }
                throw (EJBException)invTgtEx.getTargetException();
            }
            if (invTgtEx.getTargetException() instanceof RemoteException) {
                Throwable cause = invTgtEx.getTargetException().getCause();
                if (cause == null) {
                    invTgtEx.getTargetException().printStackTrace(System.out);
                    throw invTgtEx.getTargetException();
                }
                if (cause instanceof RemoteException) {
                    Throwable remoteCauseExc = cause.getCause();
                    if (remoteCauseExc == null) {
                        invTgtEx.getTargetException().printStackTrace(System.out);
                        throw invTgtEx.getTargetException();
                    }
                    if (remoteCauseExc instanceof EJBException) {
                        Exception ejbCause = ((EJBException)remoteCauseExc).getCausedByException();
                        if (ejbCause != null) {
                            ejbCause.printStackTrace(System.out);
                            throw ejbCause;
                        }
                        throw cause;
                    }
                    if (remoteCauseExc instanceof ClassCastException) {
                        R01FLog.to("r01f.bzd").severe("Ha ocurrido un ClassCastException al invocar al m\u00e9todo " + method + " del objeto " + this._remoteEJB.getClass().getName() + ". Si es una invocaci\u00f3n v\u00eda EJBs, es posible que el tipo de retorno NO sea Serializable...verifica las trazas");
                    }
                    throw remoteCauseExc;
                }
                if (cause instanceof EJBException) {
                    Exception ejbCause = ((EJBException)cause).getCausedByException();
                    if (ejbCause != null) {
                        ejbCause.printStackTrace(System.out);
                        throw ejbCause;
                    }
                    throw cause;
                }
                if (cause instanceof ClassCastException) {
                    R01FLog.to("r01f.bzd").severe("Ha ocurrido un ClassCastException al invocar al m\u00e9todo " + method + " del objeto " + this._remoteEJB.getClass().getName() + ". Si es una invocaci\u00f3n v\u00eda EJBs, es posible que el tipo de retorno NO sea Serializable...verifica las trazas");
                }
                throw cause;
            }
            throw invTgtEx;
        }
        catch (Exception ex) {
            R01FLog.to("r01f.bzd").severe(String.valueOf(this.opDesc) + ".Error :" + ex.getMessage());
            ex.printStackTrace(System.out);
            throw ex;
        }
    }

    private void _init() throws BzdConfigException {
        EJBConfigWrapper cfg;
        if (DEBUG) {
            R01FLog.to("r01f.bzd").info(String.valueOf(this.opDesc) + ".Inicializando ...." + this.getAppCode() + "." + this.getBzdOid());
        }
        if ((cfg = (EJBConfigWrapper)_ejbCfgCache.get(String.valueOf(this.getAppCode()) + "." + this.getBzdOid())) == null) {
            boolean checkLocal;
            if (DEBUG) {
                R01FLog.to("r01f.bzd").info(String.valueOf(this.opDesc) + ".La configuraci\u00f3n no est\u00e1 en la cache, as\u00ed que cargarla desde el fichero...");
            }
            cfg = new EJBConfigWrapper(this.getAppCode(), this.getBzdOid());
            String checkLocalStr = BaseBusinessDelegateInvocationHandler.getBzdConfigProperty(this.getAppCode(), this.getBzdOid(), "checkLocal", "bzdRemote/checkLocal");
            if (checkLocalStr == null) {
                R01FLog.to("r01f.bzd").info("No esta definido el parametro businessDelegatesConfig/businessDelegate[@oid='...']/bzdRemote/checkLocal en el fichero de configuracion de BZD.\r\nSe utilizar\u00e1 por defecto el interfaz remoto...");
            }
            cfg.checkLocal = checkLocal = checkLocalStr == null ? false : "true".equals(checkLocalStr);
            cfg.isLocal = false;
            if (checkLocal) {
                if (DEBUG) {
                    R01FLog.to("r01f.bzd").info(String.valueOf(this.opDesc) + ".Obtener una definici\u00f3n de la interfaz local ...");
                }
                cfg.addLocalEJBProperty("ejbLocalJndi", BaseBusinessDelegateInvocationHandler.getBzdConfigProperty(this.getAppCode(), this.getBzdOid(), "ejbLocalJndi", "bzdRemote/localJndiName"));
                cfg.addLocalEJBProperty("ejbLocalHomeClassName", BaseBusinessDelegateInvocationHandler.getBzdConfigProperty(this.getAppCode(), this.getBzdOid(), "ejbLocalHomeClassName", "bzdRemote/homeLocalClass"));
                if (cfg.getLocalEJBProperty("ejbLocalJndi") != null && cfg.getLocalEJBProperty("ejbLocalHomeClassName") != null) {
                    cfg.isLocal = ServiceLocator.getInstance(null).checkLocalHomeInterface(cfg.getLocalEJBProperty("ejbLocalJndi"));
                }
            }
            if (DEBUG) {
                R01FLog.to("r01f.bzd").info(String.valueOf(this.opDesc) + ".Obtener una definici\u00f3n de la interfaz remota ...");
            }
            cfg.addRemoteEJBProperty("ejbRemoteJndi", BaseBusinessDelegateInvocationHandler.getBzdConfigProperty(this.getAppCode(), this.getBzdOid(), "ejbRemoteJndi", "bzdRemote/remoteJndiName"));
            cfg.addRemoteEJBProperty("ejbRemoteHomeClassName", BaseBusinessDelegateInvocationHandler.getBzdConfigProperty(this.getAppCode(), this.getBzdOid(), "ejbRemoteHomeClassName", "bzdRemote/homeRemoteClass"));
            cfg.addRemoteEJBProperty("contextFactory", BaseBusinessDelegateInvocationHandler.getBzdConfigProperty(this.getAppCode(), this.getBzdOid(), "contextFactory", "bzdRemote/context/factory"));
            cfg.addRemoteEJBProperty("contextURLProvider", BaseBusinessDelegateInvocationHandler.getBzdConfigProperty(this.getAppCode(), this.getBzdOid(), "contextURLProvider", "bzdRemote/context/url"));
            cfg.addRemoteEJBProperty("contextUser", BaseBusinessDelegateInvocationHandler.getBzdConfigProperty(this.getAppCode(), this.getBzdOid(), "contextUser", "bzdRemote/context/user"));
            cfg.addRemoteEJBProperty("contextPassword", BaseBusinessDelegateInvocationHandler.getBzdConfigProperty(this.getAppCode(), this.getBzdOid(), "contextPassword", "bzdRemote/context/password"));
            _ejbCfgCache.put(cfg.ejbKey, cfg);
        }
        if (DEBUG) {
            R01FLog.to("r01f.bzd").info(String.valueOf(this.opDesc) + ".Obtener la interfaz de la configuracion a partir de la clave " + cfg.ejbKey + ":");
            R01FLog.to("r01f.bzd").info("\tejbLocalJndi=" + cfg.getRemoteEJBProperty("ejbLocalJndi"));
            R01FLog.to("r01f.bzd").info("\tejbLocalHomeClassName=" + cfg.getRemoteEJBProperty("ejbLocalHomeClassName"));
            R01FLog.to("r01f.bzd").info("\tejbRemoteJndi=" + cfg.getRemoteEJBProperty("ejbRemoteJndi"));
            R01FLog.to("r01f.bzd").info("\tejbRemoteHomeClassName=" + cfg.getRemoteEJBProperty("ejbRemoteHomeClassName"));
            R01FLog.to("r01f.bzd").info("\tcontextFactory=" + cfg.getRemoteEJBProperty("contextFactory"));
            R01FLog.to("r01f.bzd").info("\tcontextURLProvider=" + cfg.getRemoteEJBProperty("contextURLProvider"));
            R01FLog.to("r01f.bzd").info("\tcontextUser=" + cfg.getRemoteEJBProperty("contextUser"));
        }
        if (cfg.isLocal) {
            if (DEBUG) {
                R01FLog.to("r01f.bzd").info(String.valueOf(this.opDesc) + ".Utilizando la interfaz LOCAL.");
            }
            this._remoteEJB = this._initTargetEJB(true, cfg.getLocalEJBProperty("ejbLocalJndi"), cfg.getLocalEJBProperty("ejbLocalHomeClassName"), null);
        } else if (cfg.getRemoteEJBProperty("ejbRemoteJndi") != null && cfg.getRemoteEJBProperty("ejbRemoteHomeClassName") != null) {
            if (DEBUG) {
                R01FLog.to("r01f.bzd").info(String.valueOf(this.opDesc) + ".Utilizando la interfaz REMOTA.");
            }
            Properties props = null;
            if (cfg.getRemoteEJBProperty("contextFactory") != null) {
                props = new Properties();
                props.put("factory", cfg.getRemoteEJBProperty("contextFactory"));
                props.put("url", cfg.getRemoteEJBProperty("contextURLProvider"));
                props.put("user", cfg.getRemoteEJBProperty("contextUser"));
                props.put("password", cfg.getRemoteEJBProperty("contextPassword"));
            }
            this._remoteEJB = this._initTargetEJB(false, cfg.getRemoteEJBProperty("ejbRemoteJndi"), cfg.getRemoteEJBProperty("ejbRemoteHomeClassName"), props);
        } else {
            throw new BzdConfigException("NO se haNo estan definidos los parametros businessDelegatesConfig/businessDelegate[@oid='...']/bzdRemote/remoteJndiName y businessDelegatesConfig/businessDelegate[@oid='...']/bzdRemote/homeRemoteClass en el fichero de configuracion del BZD");
        }
        if (this._remoteEJB == null) {
            throw new BzdConfigException("NO se ha podido inicializar el EJB remoto!!!");
        }
        if (DEBUG) {
            R01FLog.to("r01f.bzd").info(String.valueOf(this.opDesc) + ".Finalizada la inicializaci\u00f3n !!!!!.");
        }
    }

    private Object _initTargetEJB(boolean useLocal, String inHomeJndiName, String inHomeClassName, Properties props) {
        Object outEJB = null;
        try {
            outEJB = this._initTargetEJB(useLocal, inHomeJndiName, ReflectionUtils.getObjectClassDef(inHomeClassName), props);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace(System.out);
            R01FLog.to("r01f.ejb").severe("NO se puede encontrar la clase home " + inHomeClassName + " del ejb jndi:" + inHomeJndiName + " REVISA EL CLASSPATH!!");
        }
        return outEJB;
    }

    private Object _initTargetEJB(boolean useLocal, String inHomeJndiName, Class inHomeClass, Properties props) {
        EJBLocalObject outObj = null;
        try {
            if (useLocal) {
                if (DEBUG) {
                    R01FLog.to("r01f.bzd").info(String.valueOf(this.opDesc) + ".Creando una instancia del EJB local.");
                }
                EJBLocalHome localHome = ServiceLocator.getInstance(props).getLocalHome(inHomeJndiName, inHomeClass);
                outObj = EJBAdapter.createLocalEJB(localHome, null, null);
            } else {
                if (DEBUG) {
                    R01FLog.to("r01f.bzd").info(String.valueOf(this.opDesc) + ".Creando una instancia del EJB remoto.");
                }
                EJBHome home = null;
                home = props != null ? ServiceLocator.getInstance(props).getRemoteHome(inHomeJndiName, props.get("url").toString(), inHomeClass) : ServiceLocator.getInstance(props).getRemoteHome(inHomeJndiName, inHomeClass);
                outObj = EJBAdapter.createRemoteEJB(home, null, null);
            }
        }
        catch (ServiceLocatorException slEx) {
            R01FLog.to("r01f.bzd").severe("\r\n\r\n\r\n\r\nNo se ha podido obtener acceder al interfaz home del EJB " + inHomeJndiName + ": " + slEx.toString());
            slEx.printStackTrace(System.out);
        }
        catch (Throwable th) {
            R01FLog.to("r01f.bzd").severe("\r\n\r\n\r\n\r\nNo se ha podido obtener una instancia del EJB " + inHomeJndiName + ". Error al llamar al metodo create(): " + th.toString());
            th.printStackTrace(System.out);
        }
        this.setRetryTimes(1);
        return outObj;
    }

    class EJBConfigWrapper {
        public transient String ejbKey = null;
        public transient boolean checkLocal = true;
        public transient boolean isLocal = true;
        public transient Properties localEJBProperties = null;
        public transient Properties remoteEJBProperties = null;

        public EJBConfigWrapper() {
        }

        public EJBConfigWrapper(String appCode, String bzdOid) {
            this.ejbKey = String.valueOf(appCode) + "." + bzdOid;
        }

        public void addLocalEJBProperty(String propertyName, String propertyValue) {
            if (propertyName == null || propertyValue == null) {
                return;
            }
            if (this.localEJBProperties == null) {
                this.localEJBProperties = new Properties();
            }
            this.localEJBProperties.put(propertyName, propertyValue);
        }

        public String getLocalEJBProperty(String propertyName) {
            return this.localEJBProperties != null ? this.localEJBProperties.getProperty(propertyName) : null;
        }

        public void addRemoteEJBProperty(String propertyName, String propertyValue) {
            if (propertyName == null || propertyValue == null) {
                return;
            }
            if (this.remoteEJBProperties == null) {
                this.remoteEJBProperties = new Properties();
            }
            this.remoteEJBProperties.put(propertyName, propertyValue);
        }

        public String getRemoteEJBProperty(String propertyName) {
            return this.remoteEJBProperties != null ? this.remoteEJBProperties.getProperty(propertyName) : null;
        }

        public String composeDebugInfo() {
            StringBuffer sb = new StringBuffer(167);
            sb.append("--Configuraci\u00f3n de acceso al EJB: ");
            sb.append(this.ejbKey);
            sb.append(" checkLocal=");
            sb.append(this.checkLocal);
            sb.append("\r\n");
            if (this.isLocal) {
                sb.append("\t- acceso=local\r\n");
                if (this.localEJBProperties != null) {
                    sb.append("\t-ejbLocalHomeClassName=");
                    sb.append(this.localEJBProperties.getProperty("ejbLocalHomeClassName", "Not defined"));
                    sb.append("\r\n\t-ejbLocalJndi=");
                    sb.append(this.localEJBProperties.getProperty("ejbLocalJndi", "Not defined"));
                    sb.append("\r\n");
                } else {
                    sb.append("\tNO SE HAN DEFINIDO PROPIEDADES PARA EL ACCESO AL EJB DE FORMA LOCAL: Revisa el fichero de configuracion del bzd!!!");
                }
            } else {
                sb.append("\t- acceso=remoto\r\n");
                if (this.remoteEJBProperties != null) {
                    sb.append("\t-ejbLocalHomeClassName=");
                    sb.append(this.localEJBProperties.getProperty("ejbLocalHomeClassName", "Not defined"));
                    sb.append("\r\n\t-ejbLocalJndi=");
                    sb.append(this.localEJBProperties.getProperty("ejbLocalJndi", "Not defined"));
                    sb.append("\r\n");
                } else {
                    sb.append("\tNO SE HAN DEFINIDO PROPIEDADES PARA EL ACCESO AL EJB DE FORMA REMOTA: Revisa el fichero de configuracion del bzd!!!");
                }
            }
            return sb.toString();
        }
    }
}

