/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.businessdelegate;

import com.ejie.r01f.businessdelegate.BaseBusinessDelegateInvocationHandler;
import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.businessdelegate.EJBBusinessDelegateInvocationHandler;
import com.ejie.r01f.businessdelegate.LocalClassBusinessDelegateInvocationHandler;
import com.ejie.r01f.businessdelegate.OtherBusinessDelegateInvocationHandler;
import com.ejie.r01f.businessdelegate.RPCServletBusinessDelegateInvocationHandler;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.logging.Level;

public abstract class BaseBusinessDelegateFactory {
    static boolean DEBUG = R01FLog.getLogLevel("r01f.bzd").intValue() != Level.OFF.intValue();

    protected Object getBzd(String appCode, String bzdOid) throws BzdConfigException {
        String opDesc = "BZD >>> Obtener el Bzd '" + bzdOid + "' para la aplicaci\u00f3n " + appCode + ".";
        if (DEBUG) {
            R01FLog.to("r01f.bzd").info(opDesc);
        }
        String bzdInterface = BaseBusinessDelegateInvocationHandler.getBzdConfigProperty(appCode, bzdOid, "bzdClass", "bzdClass");
        if (DEBUG) {
            R01FLog.to("r01f.bzd").info(String.valueOf(opDesc) + "El interface es " + bzdInterface);
        }
        int bzdType = BaseBusinessDelegateInvocationHandler.getBusinessDelegateType(appCode, bzdOid);
        try {
            BaseBusinessDelegateInvocationHandler handler = null;
            switch (bzdType) {
                case -1: {
                    throw new BzdConfigException("NO se conoce el tipo de BZD a crear!");
                }
                case 1: {
                    if (DEBUG) {
                        R01FLog.to("r01f.bzd").info("BZD >>> Bzd v\u00eda clase Java.........");
                    }
                    handler = new LocalClassBusinessDelegateInvocationHandler(appCode, bzdOid);
                    break;
                }
                case 2: {
                    if (DEBUG) {
                        R01FLog.to("r01f.bzd").info("BZD >>> Bzd v\u00eda RMI (EJB).........");
                    }
                    handler = new EJBBusinessDelegateInvocationHandler(appCode, bzdOid);
                    break;
                }
                case 4: {
                    if (DEBUG) {
                        R01FLog.to("r01f.bzd").info("BZD >>> Bzd v\u00eda OTHER (Client Customized Implementation)........");
                    }
                    handler = new OtherBusinessDelegateInvocationHandler(appCode, bzdOid);
                    break;
                }
                case 3: {
                    if (DEBUG) {
                        R01FLog.to("r01f.bzd").info("BZD >>> Bzd v\u00eda RPC Servlet.........\r\n");
                    }
                    handler = new RPCServletBusinessDelegateInvocationHandler(appCode, bzdOid);
                    break;
                }
                default: {
                    throw new BzdConfigException("Business Delegate NO soportado actualmente. Revisa el parametro clientObjectsConfig/bzdType en el fichero de properties de las clases cliente");
                }
            }
            Class bzdInterfaceDef = ReflectionUtils.getObjectClassDef(bzdInterface);
            if (DEBUG) {
                R01FLog.to("r01f.bzd").info(String.valueOf(opDesc) + "La clase implementadora del BZD es " + bzdInterfaceDef.getClass().getName());
            }
            return BaseBusinessDelegateFactory._createProxyInstance(bzdInterfaceDef, handler);
        }
        catch (ClassNotFoundException cnfEx) {
            cnfEx.printStackTrace(System.out);
            throw new BzdConfigException("Error al obtener la definicion del interfaz " + bzdInterface + ". Comprobar si el interfaz esta en el classpath!!");
        }
    }

    protected Object getEjbBzd(String bzdInterface, boolean checkLocalEjb, String ejbJndi, String ejbHomeClassName, String contextFactory, String contextURLProvider, String contextUser, String contextPassword) throws BzdConfigException {
        try {
            EJBBusinessDelegateInvocationHandler handler = new EJBBusinessDelegateInvocationHandler("r01f", "defEjb", checkLocalEjb, ejbJndi, ejbHomeClassName, contextFactory, contextURLProvider, contextUser, contextPassword);
            Class bzdInterfaceDef = ReflectionUtils.getObjectClassDef(bzdInterface);
            return BaseBusinessDelegateFactory._createProxyInstance(bzdInterfaceDef, handler);
        }
        catch (ClassNotFoundException cnfEx) {
            cnfEx.printStackTrace(System.out);
            throw new BzdConfigException("Error al obtener la definicion del interfaz " + bzdInterface + ". Comprobar si el interfaz esta en el classpath!!");
        }
    }

    protected Object getRPCServletBzd(String bzdInterface, String rpcServletURL, String rpcModule, String xoMapFile, long conxTimeOut, String proxyHost, String proxyPort, String proxyUsr, String proxyPwd) throws BzdConfigException {
        try {
            RPCServletBusinessDelegateInvocationHandler handler = new RPCServletBusinessDelegateInvocationHandler("r01f", "defRPC", rpcServletURL, rpcModule, xoMapFile, conxTimeOut, proxyHost, proxyPort, proxyUsr, proxyPwd);
            Class bzdInterfaceDef = ReflectionUtils.getObjectClassDef(bzdInterface);
            return BaseBusinessDelegateFactory._createProxyInstance(bzdInterfaceDef, handler);
        }
        catch (ClassNotFoundException cnfEx) {
            cnfEx.printStackTrace(System.out);
            throw new BzdConfigException("Error al obtener la definicion del interfaz " + bzdInterface + ". Comprobar si el interfaz esta en el classpath!!");
        }
    }

    protected Object getClassBzd(String bzdInterface, String bzdImpl) throws BzdConfigException {
        try {
            LocalClassBusinessDelegateInvocationHandler handler = new LocalClassBusinessDelegateInvocationHandler("r01f", "defLocalClass", bzdImpl);
            Class bzdInterfaceDef = ReflectionUtils.getObjectClassDef(bzdInterface);
            return BaseBusinessDelegateFactory._createProxyInstance(bzdInterfaceDef, handler);
        }
        catch (ClassNotFoundException cnfEx) {
            cnfEx.printStackTrace(System.out);
            throw new BzdConfigException("Error al obtener la definicion del interfaz " + bzdInterface + ". Comprobar si el interfaz esta en el classpath!!");
        }
    }

    private static Object _createProxyInstance(Class bzdClassDef, InvocationHandler handler) throws BzdConfigException {
        try {
            return Proxy.newProxyInstance(bzdClassDef.getClassLoader(), new Class[]{bzdClassDef}, handler);
        }
        catch (IllegalArgumentException argExc) {
            throw new BzdConfigException("Error al obtener el servicio a ser invocado. Revisar la configuraci\u00f3n y las comunicaciones.");
        }
        catch (NullPointerException nullExc) {
            throw new BzdConfigException("Error al obtener el servicio a ser invocado. Revisar la configuraci\u00f3n y las comunicaciones.");
        }
    }
}

