/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.auxdata;

import com.ejie.r01f.auxdata.AuxDataLoader;
import com.ejie.r01f.auxdata.AuxDataLoaderException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.sql.DBManager;
import com.ejie.r01f.util.StringMap;
import com.ejie.r01f.util.StringUtils;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DefaultDataBaseDataLoaderImpl
implements AuxDataLoader {
    @Override
    public Map load(String appCode, String dataSetOid, Properties props) throws AuxDataLoaderException {
        if (props == null) {
            throw new AuxDataLoaderException("Error de configuracion: No existen propiedades en la configuracion del loader de datos Auxiliares.");
        }
        String conxOid = props.getProperty("conxOid");
        String sql = props.getProperty("sql");
        String codeColumnName = props.getProperty("codeColumnName");
        String valueColumnName = props.getProperty("valueColumnName");
        if (conxOid == null) {
            throw new AuxDataLoaderException("Error de configuracion: Falta la propiedad 'conxOid' en la configuracion del loader de datos Auxiliares");
        }
        if (sql == null) {
            throw new AuxDataLoaderException("Error de configuracion: Falta la propiedad 'sql' en la configuracion del loader de datos Auxiliares");
        }
        if (codeColumnName == null) {
            throw new AuxDataLoaderException("Error de configuracion: Falta la propiedad 'codeColumnName' en la configuracion del loader de datos Auxiliares");
        }
        if (valueColumnName == null) {
            throw new AuxDataLoaderException("Error de configuracion: Falta la propiedad 'valueColumnName' en la configuracion del loader de datos Auxiliares");
        }
        Properties varValues = new Properties();
        varValues.put("appCode", appCode);
        varValues.put("dataSet", dataSetOid);
        if (props != null) {
            varValues.putAll(props);
        }
        sql = StringUtils.replaceVariableValues(sql, '$', (Map)varValues);
        R01FLog.to("r01f.util").finest("SQL a ejecutar para obtener los datos auxiliares: " + sql);
        try {
            DBManager dbMan = new DBManager(appCode, conxOid);
            List result = dbMan.executeQuery(sql, null);
            if (result != null) {
                String[][] outArray = new String[result.size()][2];
                int i = 0;
                Map currRow2 = null;
                for (Map currRow2 : result) {
                    outArray[i][0] = (String)currRow2.get(codeColumnName.toUpperCase());
                    outArray[i][1] = (String)currRow2.get(valueColumnName.toUpperCase());
                    ++i;
                }
                return new StringMap(outArray);
            }
            return null;
        }
        catch (SQLException sqlEx) {
            throw new AuxDataLoaderException("Error al ejecutar la query para obtener los datos auxiliares de " + dataSetOid + ": " + sqlEx.getMessage(), (Exception)sqlEx);
        }
    }
}

