//
//  descargarRecursos.m
//  iEuskadi
//
//  Created by Gonzalo Torres Ayastuy on 13/06/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "descargarRecursos.h"

@implementation descargarRecursos

/*
 Función que devuelve los recursos (en un Array) del webService de turismo
 */

+(NSMutableArray *) descargarRecursosMapa: (CLLocation *)location arrayCategorias:(NSMutableArray *)arrCat distance:(NSString *) distancia{
    NSMutableArray *arrRecursos = [[NSMutableArray alloc] init];
    //NSString *filePath = [[NSBundle mainBundle] pathForResource:@"json2" ofType:@"txt"];
    //NSString *myText = [NSString stringWithContentsOfFile:filePath];
    //SBJsonParser *parser = [[[SBJsonParser alloc] init] autorelease];
	//NSDictionary *jsonObject = [parser objectWithString:myText error:NULL];
    NSString *strLatitud = [NSString stringWithFormat:@"%f", location.coordinate.latitude];
    NSString *strLongitud = [NSString stringWithFormat:@"%f", location.coordinate.longitude];
    
    //Parámetro multicat para pararle al WebService
    NSString *strMulticat = [self crearFiltroMulticat: arrCat];
    
    //Parámetro de idioma
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
    NSString *lang = [defaults objectForKey:@"AppLanguage"];
    NSString *langParameter = [NSString stringWithFormat:@""];
	if([lang isEqualToString:@"es"])
		langParameter = @"es";
	else if([lang isEqualToString:@"eu-ES"])
		langParameter = @"eu";
	else if([lang isEqualToString:@"en"])
		langParameter = @"en";
    else if([lang isEqualToString:@"fr"])
		langParameter = @"fr";
    else if([lang isEqualToString:@"de"])
		langParameter = @"de";
    NSString *url = @"http://turismoa.euskadi.net/s12LayarWar/servlet/S12LayarServlet?countryCode=ES&";
    url = [url stringByAppendingFormat:@"lat=%@", strLatitud];
    url = [url stringByAppendingFormat:@"&userId=ed48067cda8e1b985dbb8ff3653a2da4fd490a371000&"];
    url = [url stringByAppendingFormat:@"&radius=%@", distancia];
    url = [url stringByAppendingFormat:@"&lon=%@", strLongitud];
    url = [url stringByAppendingFormat:@"&layerName=turismoeuskadi&accuracy=100"];
    url = [url stringByAppendingFormat:@"&lang=%@", langParameter];
    url = [url stringByAppendingFormat:@"&multicat=%@", strMulticat];
    url = [url stringByAppendingFormat:@"&R01HNoPortal=true"];
    
    //Prepare URL request to download statuses from Twitter
    NSURLRequest *request = [NSURLRequest requestWithURL:[NSURL URLWithString:url]];
    NSError *error = nil;
    NSURLResponse* urlResponse;
    // Perform request and get JSON back as a NSData object
    NSData *response = [NSURLConnection sendSynchronousRequest:request returningResponse:&urlResponse error:&error];

    NSString *json_string = [[NSString alloc] initWithData:response encoding:NSUTF8StringEncoding];
    if (!error){
        SBJsonParser *parser = [[SBJsonParser alloc] init];
        NSDictionary *jsonObject = [parser objectWithString:json_string error:NULL];
        NSArray *list = [jsonObject objectForKey:@"hotspots"];
        for (NSDictionary *hotspot in list)
        {
            NSString *imageURL = [hotspot objectForKey:@"imageURL"];
            NSDictionary *text = [hotspot objectForKey:@"text"];
            NSString *title = [text objectForKey:@"title"];
            NSString *description = [text objectForKey:@"description"];
            //NSNumber *type = [hotspot objectForKey:@"iconType"];
            NSDictionary *icon = [hotspot objectForKey:@"icon"];
            NSNumber *type = [icon objectForKey:@"type"];
            NSDictionary *anchor = [hotspot objectForKey:@"anchor"];
            NSDictionary *geolocation = [anchor objectForKey:@"geolocation"];
            NSNumber *lat = [geolocation objectForKey:@"lat"];
            NSNumber *lon = [geolocation objectForKey:@"lon"];
            NSNumber *idRecurso = [hotspot objectForKey:@"id"];
            NSMutableArray *actions = [hotspot objectForKey:@"actions"];
            NSString *tel = @"";
            NSString *mail = @"";
            NSString *urlRecurso = @"";
            for (int i=0; i< [actions count]; i++){
                NSDictionary *datosAction = [actions objectAtIndex:i];
                //NSString *label = [datosAction objectForKey:@"label"];
                NSString *uri = [datosAction objectForKey:@"uri"];
                //NSNumber *activityType = [datosAction objectForKey:@"activityType"];
                NSNumber *tipoAccion = [datosAction objectForKey:@"tipoAccion"];
                ;
                /*if ([label isEqualToString:@"Etiqueta TELEFONO - idioma"]) {
                 tel = [uri stringByReplacingOccurrencesOfString:@"tel:" withString:@""];
                 tel = [tel stringByReplacingOccurrencesOfString:@" " withString:@""];
                 tel = [tel substringToIndex:9];
                 }
                 if ([label isEqualToString:@"Etiqueta MAIL por idioma"]) {
                 mail = [uri stringByReplacingOccurrencesOfString:@"tel:" withString:@""];
                 }
                 if ([label isEqualToString:@"Etiqueta WEB - idioma"]) {
                 urlRecurso = uri;
                 }*/
                
                if (tipoAccion == [NSNumber numberWithInt:2]) {
                    tel = [uri stringByReplacingOccurrencesOfString:@"tel:" withString:@""];
                    tel = [tel stringByReplacingOccurrencesOfString:@" " withString:@""];
                    if ([tel length] >= 9){
                        tel = [tel substringToIndex:9];
                    }else{
                        tel = nil;
                    }
                    
                }
                if (tipoAccion == [NSNumber numberWithInt:4]) {
                    mail = [uri stringByReplacingOccurrencesOfString:@"mailto:" withString:@""];
                }
                if (tipoAccion == [NSNumber numberWithInt:5]/* && ([label isEqualToString:@"Web"] || [label isEqualToString:@"Web_en"] || [label isEqualToString:@"Web_fr"] || [label isEqualToString:@"Web_de"] || [label isEqualToString:@"Web_eu"])*/) {
                    urlRecurso = uri;
                }
            }
            
            //Se transforma el código HTML a NSString
            NSString* strippedTitle = [title stripHtml];
            NSString* strippedDescripcion = [description stripHtml];
            
            //Se calcula la distancia entre el usuario y el recurso
            CLLocation *poiLoc = [[CLLocation alloc] initWithLatitude: [lat doubleValue] longitude: [lon doubleValue]];
            double dist = [location distanceFromLocation:poiLoc]/1000;
            //Se crea el objeto y se añade al array de recursos
            RecursoTuristico *recurso = [[RecursoTuristico alloc] initWithName:idRecurso imageURL:imageURL title:strippedTitle desc:strippedDescripcion type:type latitud:lat longitud:lon telefono:tel mail:mail urlRecurso:urlRecurso distance:dist];
            [arrRecursos addObject:recurso];
            
            //Se ordena el array por distancia
            NSSortDescriptor *sortDescriptor;
            sortDescriptor = [[NSSortDescriptor alloc] initWithKey:@"distance" ascending:YES];
            NSArray *sortDescriptors = [NSArray arrayWithObject:sortDescriptor];
            [arrRecursos sortUsingDescriptors:sortDescriptors];
        }
        
        [[NSNotificationCenter defaultCenter] postNotificationName: @"NotificacionDescarga" object: error];
        
    }else{
        [[NSNotificationCenter defaultCenter] postNotificationName: @"NotificacionDescargaError" object: error];
    }
    
    return arrRecursos;
    
}

/*
 Función que crea el filtro de categorías para pasar al webService
 */

+ (NSString *) crearFiltroMulticat: (NSMutableArray *)arrCategorias{
    
    NSString *strFiltroCat = @"";
    for (int i = 0; i< [arrCategorias count]; i++){
        NSString *catActual = [[arrCategorias objectAtIndex:i] stringValue];
        if (i ==0){
            strFiltroCat = [strFiltroCat stringByAppendingFormat:@"%@", catActual];
        } else{
            strFiltroCat = [strFiltroCat stringByAppendingFormat:@"c"];
            strFiltroCat = [strFiltroCat stringByAppendingFormat:@"%@", catActual];
        }
    }
    
    return strFiltroCat;
}

@end
