//
//  SeleccionIdioma.m
//  iEuskadi
//
//  Created by Gonzalo Torres Ayastuy on 08/06/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "SeleccionIdioma.h"
#import <QuartzCore/QuartzCore.h>

@implementation SeleccionIdioma

@synthesize btnAleman, btnIngles, btnEspanol, btnEuskera, btnFrances, delegate, btnCancel;
@synthesize lblAleman, lblIngles, lblEspanol, lblEuskera, lblFrances;

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        // Initialization code
    }
    return self;
}

-(id) initWithTitle:(NSString *)title image:(UIImage*)_image{
    
    self = [super initWithFrame:CGRectMake(0, 0, 320, 280)];

    //self.layer.backgroundColor = [UIColor colorWithRed:0.2 green:0.4 blue:0.5 alpha:0.8f].CGColor;
    self.layer.backgroundColor = [UIColor clearColor].CGColor;
    
    UIView *viewBack = [[UIView alloc] initWithFrame:CGRectMake(self.layer.frame.origin.x+15, self.layer.frame.origin.y+15, self.layer.frame.size.width-30, self.layer.frame.size.height-30)];
    viewBack.layer.cornerRadius = 10.0f;
    viewBack.layer.borderWidth = 1.0f;
    viewBack.layer.borderColor = [UIColor whiteColor].CGColor;
    viewBack.layer.masksToBounds = YES;
    viewBack.alpha = 0.9f;
    [viewBack setBackgroundColor:[UIColor whiteColor]];
    
    //button euskera
    btnEuskera = [UIButton buttonWithType:UIButtonTypeCustom];
    [btnEuskera setBackgroundColor:[UIColor whiteColor]];
    btnEuskera.frame = CGRectMake(0, 0, viewBack.layer.frame.size.width, 50);
    [btnEuskera addTarget:self action:@selector(onClickEuskera:) forControlEvents:UIControlEventTouchUpInside];
    btnEuskera.layer.borderWidth = 1.0f;
    btnEuskera.layer.borderColor = [UIColor lightGrayColor].CGColor;
    [btnEuskera setBackgroundImage:[UIImage imageNamed:@"fondoCeldaIdioma"] forState:UIControlStateHighlighted];
    [viewBack insertSubview:btnEuskera aboveSubview:viewBack];
    
    //label euskera
    lblEuskera = [[UILabel alloc] initWithFrame:CGRectMake(100, 5, 150, 50)];
    lblEuskera.backgroundColor = [UIColor clearColor];
    lblEuskera.center = btnEuskera.center;
    lblEuskera.font = [UIFont fontWithName:@"Verdana" size:21];
    lblEuskera.textAlignment = NSTextAlignmentCenter;
    [lblEuskera setTextColor:[UIColor darkGrayColor]];
    [viewBack insertSubview:lblEuskera aboveSubview:viewBack];
    
    //button espanol
    btnEspanol = [UIButton buttonWithType:UIButtonTypeCustom];
    [btnEspanol setBackgroundColor:[UIColor whiteColor]];
    btnEspanol.frame = CGRectMake(0, btnEuskera.layer.frame.size.height, viewBack.layer.frame.size.width, 50);
    [btnEspanol addTarget:self action:@selector(onClickEspanol:) forControlEvents:UIControlEventTouchUpInside];
    btnEspanol.layer.borderWidth = 0.5f;
    btnEspanol.layer.borderColor = [UIColor lightGrayColor].CGColor;
    [btnEspanol setBackgroundImage:[UIImage imageNamed:@"fondoCeldaIdioma"] forState:UIControlStateHighlighted];
    [viewBack insertSubview:btnEspanol aboveSubview:viewBack];
    
    //label español
    lblEspanol = [[UILabel alloc] initWithFrame:CGRectMake(100, 60, 150, 50)];
    lblEspanol.backgroundColor = [UIColor clearColor];
    lblEspanol.center = btnEspanol.center;
    lblEspanol.font = [UIFont fontWithName:@"Verdana" size:21];
    lblEspanol.textAlignment = NSTextAlignmentCenter;
    [lblEspanol setTextColor:[UIColor darkGrayColor]];
    [viewBack insertSubview:lblEspanol aboveSubview:viewBack];
    
    //button ingles
    btnIngles = [UIButton buttonWithType:UIButtonTypeCustom];
    [btnIngles setBackgroundColor:[UIColor whiteColor]];
    btnIngles.frame = CGRectMake(0, btnEspanol.layer.frame.origin.y + btnEspanol.layer.frame.size.height, viewBack.layer.frame.size.width, 50);
    [btnIngles addTarget:self action:@selector(onClickIngles:) forControlEvents:UIControlEventTouchUpInside];
    btnIngles.layer.borderWidth = 0.5f;
    btnIngles.layer.borderColor = [UIColor lightGrayColor].CGColor;
    [btnIngles setBackgroundImage:[UIImage imageNamed:@"fondoCeldaIdioma"] forState:UIControlStateHighlighted];
    [viewBack insertSubview:btnIngles aboveSubview:viewBack];
    
    //label francésés
    lblIngles = [[UILabel alloc] initWithFrame:CGRectMake(80, 115, 150, 50)];
    lblIngles.backgroundColor = [UIColor clearColor];
    lblIngles.center = btnIngles.center;
    lblIngles.font = [UIFont fontWithName:@"Verdana" size:21];
    lblIngles.textAlignment = NSTextAlignmentCenter;
    [lblIngles setTextColor:[UIColor darkGrayColor]];
    [viewBack insertSubview:lblIngles aboveSubview:viewBack];
    
    //button frances
    btnFrances = [UIButton buttonWithType:UIButtonTypeCustom];
    [btnFrances setBackgroundColor:[UIColor whiteColor]];
    btnFrances.frame = CGRectMake(0, btnIngles.layer.frame.origin.y + btnIngles.layer.frame.size.height, viewBack.layer.frame.size.width, 50);
    [btnFrances addTarget:self action:@selector(onClickFrances:) forControlEvents:UIControlEventTouchUpInside];
    btnFrances.layer.borderWidth = 0.5f;
    btnFrances.layer.borderColor = [UIColor lightGrayColor].CGColor;
    [btnFrances setBackgroundImage:[UIImage imageNamed:@"fondoCeldaIdioma"] forState:UIControlStateHighlighted];
    [viewBack insertSubview:btnFrances aboveSubview:viewBack];
    
    //label inglés
    lblFrances = [[UILabel alloc] initWithFrame:CGRectMake(80, 170, 150, 50)];
    lblFrances.backgroundColor = [UIColor clearColor];
    lblFrances.center = btnFrances.center;
    lblFrances.font = [UIFont fontWithName:@"Verdana" size:21];
    lblFrances.textAlignment = NSTextAlignmentCenter;
    [lblFrances setTextColor:[UIColor darkGrayColor]];
    [viewBack insertSubview:lblFrances aboveSubview:viewBack];
    
    //button aleman
    btnAleman = [UIButton buttonWithType:UIButtonTypeCustom];
    [btnAleman setBackgroundColor:[UIColor whiteColor]];
    btnAleman.frame = CGRectMake(0, btnFrances.layer.frame.origin.y + btnFrances.layer.frame.size.height, viewBack.layer.frame.size.width, 50);
    [btnAleman addTarget:self action:@selector(onClickAleman:) forControlEvents:UIControlEventTouchUpInside];
    btnAleman.layer.borderWidth = 0.5f;
    btnAleman.layer.borderColor = [UIColor lightGrayColor].CGColor;
    [btnAleman setBackgroundImage:[UIImage imageNamed:@"fondoCeldaIdioma"] forState:UIControlStateHighlighted];
    [viewBack insertSubview:btnAleman aboveSubview:viewBack];
    
    //label alemánés
    lblAleman = [[UILabel alloc] initWithFrame:CGRectMake(80, 225, 150, 50)];
    lblAleman.backgroundColor = [UIColor clearColor];
    lblAleman.font = [UIFont fontWithName:@"Verdana" size:21];
    lblAleman.textAlignment = NSTextAlignmentCenter;
    lblAleman.center = btnAleman.center;
    [lblAleman setTextColor:[UIColor darkGrayColor]];
    [viewBack insertSubview:lblAleman aboveSubview:viewBack];
    
    [self recargarLiterales];
    [self insertSubview:viewBack aboveSubview:self];
    
    //button cancel
    btnCancel = [UIButton buttonWithType:UIButtonTypeCustom];
    [btnCancel setBackgroundImage:[UIImage imageNamed:@"iconCloseX.png"] forState:UIControlStateNormal];
    btnCancel.frame = CGRectMake(self.frame.size.width -40, 5, btnCancel.currentBackgroundImage.size.width, btnCancel.currentBackgroundImage.size.height);
    [btnCancel addTarget:self action:@selector(cancelAndClose:) forControlEvents:UIControlEventTouchUpInside];
    [self insertSubview:btnCancel aboveSubview:self];
    self.transform = CGAffineTransformMakeScale(1.0, 0.1);

   
    
    return self;
}

-(void)show
{
    
    [UIView beginAnimations:@"playAnimation" context:nil];
    [UIView setAnimationDuration:0.5f];
    self.transform = CGAffineTransformMakeScale(1.0, 1.0);
    [UIView commitAnimations];
    
}

-(IBAction)cancelAndClose:(id)sender{
    
    [UIView setAnimationDuration:0.5f];
    self.transform = CGAffineTransformMakeScale(0.1, 0.1);
    [UIView commitAnimations];
    [delegate didClose];
    
    [self removeFromSuperview];
    
}

-(IBAction)onClickEuskera:(id)sender{
    [delegate didSelect:1];
    [self removeFromSuperview];

}

-(IBAction)onClickEspanol:(id)sender{
    [delegate didSelect:2];
    [self removeFromSuperview];

}

-(IBAction)onClickIngles:(id)sender{
    [delegate didSelect:3];
    [self removeFromSuperview];

}

-(IBAction)onClickFrances:(id)sender{
    [delegate didSelect:4];
    [self removeFromSuperview];

}

-(IBAction)onClickAleman:(id)sender{
    [delegate didSelect:5];
    [self removeFromSuperview];

}

-(void) recargarLiterales{
    
    [lblAleman setText:[traducirLiteral languageSelectedStringForKey:@"ALEMAN"]];  
    [lblEspanol setText:[traducirLiteral languageSelectedStringForKey:@"ESPANOL"]]; 
    [lblEuskera setText:[traducirLiteral languageSelectedStringForKey:@"EUSKERA"]]; 
    [lblFrances setText:[traducirLiteral languageSelectedStringForKey:@"FRANCES"]]; 
    [lblIngles setText:[traducirLiteral languageSelectedStringForKey:@"INGLES"]]; 
    
}

@end
