//
//  RootViewController.m
//  iEuskadi
//
//  Created by Gonzalo Torres Ayastuy on 18/05/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "RootViewController.h"
#import "Twitter/Twitter.h"
#import "BMNavigationBar.h"
#import <QuartzCore/QuartzCore.h>

@implementation RootViewController


@synthesize btnRecursos, facebook, btnLayar, btnFavoritos;
@synthesize imgBackground, viewBack;

#pragma mark - View Lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];
    facebook = [[Facebook alloc] initWithAppId:fb_appId andDelegate:self];
    
    // ----- BOTON CONNECT -----
    self.btnConnect = [[UIButton alloc] initWithFrame:CGRectMake(0, 0, 35, 30)];
    [self.btnConnect setBackgroundImage:[UIImage imageNamed:@"btnMainConecct"] forState:UIControlStateNormal];
    [self.btnConnect setUserInteractionEnabled:YES];
    [self.btnConnect addTarget:self action:@selector(onClickBtnConnect:) forControlEvents:UIControlEventTouchUpInside];
    self.btnConnect.layer.cornerRadius = 15.0f;
    
    // NAVIGATION BAR ---------------------------------------------------------------------------
    BMNavigationBar *navigationBar = (BMNavigationBar *) self.navigationController.navigationBar;
    [navigationBar dropShadowWithOffset:CGSizeMake(0, 2) radius:1 color:[UIColor colorWithRed:0.0f green:0.0f blue:0.0f alpha:0.7f] opacity:1];
    self.navigationItem.rightBarButtonItem = [[UIBarButtonItem alloc] initWithCustomView:self.btnConnect];
    
    // ----- First Run -----
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
	if (![defaults objectForKey:@"firstRun"])
	{
		[defaults setObject:[NSDate date] forKey:@"firstRun"];
        if([[[NSLocale currentLocale] localeIdentifier] isEqualToString:@"eu_ES"])
            [defaults setObject:@"eu-ES" forKey:@"AppLanguage"];
        else if([[[NSLocale currentLocale] localeIdentifier] isEqualToString:@"es"])
            [defaults setObject:@"es" forKey:@"AppLanguage"];
        else if([[[NSLocale currentLocale] localeIdentifier] isEqualToString:@"en"])
            [defaults setObject:@"en" forKey:@"AppLanguage"];
        else if([[[NSLocale currentLocale] localeIdentifier] isEqualToString:@"fr"])
            [defaults setObject:@"fr" forKey:@"AppLanguage"];
        else if([[[NSLocale currentLocale] localeIdentifier] isEqualToString:@"de"])
            [defaults setObject:@"de" forKey:@"AppLanguage"];
        else{
            [defaults setObject:@"en" forKey:@"AppLanguage"];
        }
		[[NSUserDefaults standardUserDefaults] synchronize];
	}
    
    // ----- Boton Recursos -----
    self.btnRecursos.layer.shadowColor = [UIColor lightGrayColor].CGColor;
	self.btnRecursos.layer.shadowOpacity = 0.8f;
	self.btnRecursos.layer.shadowRadius = 2.0f;
	self.btnRecursos.layer.cornerRadius = 2.0f;
    self.btnRecursos.layer.shadowOffset = CGSizeMake(2, 3);
    _lblRecursos = [[UILabel alloc] initWithFrame:CGRectMake(0, self.btnRecursos.frame.size.height-50, self.btnRecursos.frame.size.width, 20)];
    _lblRecursos.backgroundColor = [UIColor clearColor];
    _lblRecursos.textColor = [UIColor whiteColor];
    _lblRecursos.font = [UIFont fontWithName:@"Verdana-Bold" size:11];
    _lblRecursos.textAlignment = UITextAlignmentCenter;
    _lblFavoritos.text = @"HOLA";
    [self.btnRecursos addSubview:_lblRecursos];

    // ----- Boton Realidad Aumentada -----
    self.btnLayar.layer.shadowColor = [UIColor lightGrayColor].CGColor;
	self.btnLayar.layer.shadowOpacity = 0.8f;
	self.btnLayar.layer.shadowRadius = 2.0f;
	self.btnLayar.layer.cornerRadius = 2.0f;
    self.btnLayar.layer.shadowOffset = CGSizeMake(2, 3);
    _lblRealidadAumentada = [[UILabel alloc] initWithFrame:CGRectMake(0, self.btnLayar.frame.size.height-50, self.btnLayar.frame.size.width, 20)];
    _lblRealidadAumentada.backgroundColor = [UIColor clearColor];
    _lblRealidadAumentada.textColor = [UIColor whiteColor];
    _lblRealidadAumentada.font = [UIFont fontWithName:@"Verdana-Bold" size:11];
    _lblRealidadAumentada.textAlignment = UITextAlignmentCenter;
    [self.btnLayar addSubview:_lblRealidadAumentada];

    // ----- Boton Favoritos -----
    self.btnFavoritos.layer.shadowColor = [UIColor lightGrayColor].CGColor;
	self.btnFavoritos.layer.shadowOpacity = 0.8f;
	self.btnFavoritos.layer.shadowRadius = 2.0f;
	self.btnFavoritos.layer.cornerRadius = 2.0f;
    self.btnFavoritos.layer.shadowOffset = CGSizeMake(2, 3);
    _lblFavoritos = [[UILabel alloc] initWithFrame:CGRectMake(0, self.btnFavoritos.frame.size.height-50, self.btnFavoritos.frame.size.width, 20)];
    _lblFavoritos.backgroundColor = [UIColor clearColor];
    _lblFavoritos.textColor = [UIColor whiteColor];
    _lblFavoritos.font = [UIFont fontWithName:@"Verdana-Bold" size:11];
    _lblFavoritos.textAlignment = UITextAlignmentCenter;
    [self.btnFavoritos addSubview:_lblFavoritos];
    
    [self recargarLiterales];
    
    // ----- SlideShow -----
    _photos = [[NSMutableArray alloc] init];
    _currentImage = 0;
    [_photos addObject:[UIImage imageNamed:@"slide1iPhone.jpg"]];
    [_photos addObject:[UIImage imageNamed:@"slide2iPhone.jpg"]];
    [_photos addObject:[UIImage imageNamed:@"slide3iPhone.jpg"]];
    [_photos addObject:[UIImage imageNamed:@"slide4iPhone.jpg"]];
    [_photos addObject:[UIImage imageNamed:@"slide5iPhone.jpg"]];
    [_photos addObject:[UIImage imageNamed:@"slide6iPhone.jpg"]];
    
    timer = [NSTimer scheduledTimerWithTimeInterval: 4.0
                                             target: self
                                           selector: @selector(handleTimer:)
                                           userInfo: nil
                                            repeats: YES];
}

- (void)viewDidUnload
{
    [super viewDidUnload];
}


#pragma mark - background slideshow

- (void) handleTimer: (NSTimer *) timer {
    _currentImage++;
    if (_currentImage >= _photos.count) _currentImage = 0;
    
    CFTimeInterval animation_duration = 1.0;
    
    //SplashScreen
    UIImageView * splashView = [[UIImageView alloc] initWithFrame:CGRectMake(self.viewBack.bounds.origin.x,self.viewBack.bounds.origin.y, self.viewBack.bounds.size.width, self.viewBack.bounds.size.height)];
    int anterior = 0;
    if (_currentImage > 0) {
        anterior = _currentImage -1;
    }else{
        anterior = [_photos count] -1;
    }
    
    splashView.image = [_photos objectAtIndex:anterior];
    [self.viewBack addSubview:splashView];
    [self.viewBack bringSubviewToFront:splashView];
    
    //Animation (fade away with zoom effect)
    [UIView beginAnimations:nil context:nil];
    [UIView setAnimationDuration:animation_duration];
    [UIView setAnimationTransition:UIViewAnimationOptionTransitionNone forView:self.viewBack cache:YES];
    [UIView setAnimationDelegate:splashView];
    [UIView setAnimationDidStopSelector:@selector(removeFromSuperview)];
    splashView.alpha = 0.0;
    //splashView.frame = CGRectMake(-60, -60, 440, 600);
    
    [UIView commitAnimations];
    
    [imgBackground setImage:[_photos objectAtIndex:_currentImage]];
}

#pragma mark - Funciones de traducción

-(void) recargarLiterales
{
    _lblFavoritos.text = [traducirLiteral languageSelectedStringForKey:@"FAVORITOS"];
    _lblRecursos.text = [traducirLiteral languageSelectedStringForKey:@"RECURSOSTURISTICOS"];
    _lblRealidadAumentada.text = [traducirLiteral languageSelectedStringForKey:@"REALIDADAUMENTADA"];
    
    titleVCRecursos = [traducirLiteral languageSelectedStringForKey:@"TITLERECURSOS"];
    strMessageErrorTitle =  [traducirLiteral languageSelectedStringForKey:@"ERRORENVIOCABECERA"];
    strMessageError = [traducirLiteral languageSelectedStringForKey:@"ERRORENVIOCUERPO"];
    strTweetError =[traducirLiteral languageSelectedStringForKey:@"TWEETERROR"];
    strTweetSuccess =[traducirLiteral languageSelectedStringForKey:@"TWEETSUCCESS"];
    strTweetErrorTitle =[traducirLiteral languageSelectedStringForKey:@"TWEETERRORTITLE"];
    strTweetSuccessTitle =[traducirLiteral languageSelectedStringForKey:@"TWEETSUCCESSTITLE"];
    strMailEnviado =[traducirLiteral languageSelectedStringForKey:@"MAILENVIADO"];
    strMailNoEnviado =[traducirLiteral languageSelectedStringForKey:@"MAILNOENVIADO"];
    strMailEnviadoMessage =[traducirLiteral languageSelectedStringForKey:@"MAILENVIADOMESSAGE"];
    strMailNoEnviadoMessage =[traducirLiteral languageSelectedStringForKey:@"MAILNOENVIADOMESSAGE"];
    strFavoritos = [traducirLiteral languageSelectedStringForKey:@"FAVORITOS"];
    
    self.navigationItem.leftBarButtonItem.title = [traducirLiteral languageSelectedStringForKey:@"IDIOMASELECCIONADO"].uppercaseString;
}

#pragma mark - Eventos

- (IBAction)onClickBtnIdioma:(id)sender
{
    self.navigationItem.leftBarButtonItem.enabled = NO;
    self.btnConnect.enabled = NO;
    _seleccionIdioma = [[SeleccionIdioma alloc] initWithTitle:@"SeleccionIdioma:" image:nil];
    _seleccionIdioma.delegate = self;
    _seleccionIdioma.center = self.view.center;
    btnLayar.enabled = NO;
    btnFavoritos.enabled = NO;
    btnRecursos.enabled = NO;
    
    [self.view addSubview:_seleccionIdioma];
    [_seleccionIdioma show];
    
}

- (IBAction)onClickBtnConnect:(id)sender{
    self.navigationItem.leftBarButtonItem.enabled = NO;
    self.btnConnect.enabled = NO;
    btnLayar.enabled = NO;
    btnFavoritos.enabled = NO;
    btnRecursos.enabled = NO;
    _modalConectar = [[ModalConectar alloc] initWithTitle:@"ModalConectar:" image:nil comesFrom:nil];
    _modalConectar.delegate = self;
    _modalConectar.center = self.view.center;
    self.btnConnect.enabled = NO;
    
    [self.view addSubview:_modalConectar];
    [_modalConectar show];
}

- (IBAction)onClickBtnRecursos:(id)sender
{
    RecursosTuristicosViewController *vistaRecursos = [[RecursosTuristicosViewController alloc] initWithNibName:@"RecursosTuristicosViewController" bundle:nil];
    vistaRecursos.title = titleVCRecursos;
    [self.navigationController pushViewController:vistaRecursos animated:YES];
}

-(IBAction)onClickBtnAbrirFavoritos:(id)sender{
    FavoritosViewController *vistaFavoritos = [[FavoritosViewController alloc] initWithNibName:@"FavoritosViewController" bundle:nil];
    vistaFavoritos.title = strFavoritos;
    [self.navigationController pushViewController:vistaFavoritos animated:YES];
}

-(IBAction)onClickBtnAbrirLayar:(id)sender{
    NSURL *url = [NSURL URLWithString:@"layar://turismoeuskadi?action=refresh"];
    if([[UIApplication sharedApplication] canOpenURL: url]) {
        [[UIApplication sharedApplication] openURL:url];
    } else {
        [[UIApplication sharedApplication] openURL:[NSURL URLWithString:@"https://itunes.apple.com/py/app/layar-augmented-reality/id334404207?mt=8"]];
    }
}


#pragma mark - TWITTER ACTION

/*
 Método para enviar un Tweet con un mensaje precargado
 */
- (void)enviarTweet{
    TWTweetComposeViewController *twitter = [[TWTweetComposeViewController alloc] init];
    
    [twitter setInitialText:tweet_message];
    [twitter addImage:[UIImage imageNamed:@"iconiPhoneRetina.png"]];
    [self presentViewController:twitter animated:YES completion:nil];
    twitter.completionHandler = ^(TWTweetComposeViewControllerResult res) {
        if(res == TWTweetComposeViewControllerResultDone) {
            UIAlertView* alertView = [[UIAlertView alloc] initWithTitle:strTweetSuccessTitle message:strTweetSuccess delegate:self cancelButtonTitle:@"OK" otherButtonTitles:nil];
            [alertView show];
        } else if(res == TWTweetComposeViewControllerResultCancelled) {
            UIAlertView* alertView = [[UIAlertView alloc] initWithTitle:strTweetErrorTitle message:strTweetError delegate:self cancelButtonTitle:@"OK" otherButtonTitles:nil];
            [alertView show];
        }
        [self dismissModalViewControllerAnimated:YES];
    };
}

#pragma mark - MAILER METHODS


- (void)showPicker{
    Class mailClass = (NSClassFromString(@"MFMailComposeViewController"));
    if (mailClass != nil) {
        if ([mailClass canSendMail])
            [self displayComposerSheet];
        else {
            UIAlertView *error = [[UIAlertView alloc] initWithTitle:strMessageErrorTitle message:strMessageError delegate:self cancelButtonTitle:@"OK" otherButtonTitles:nil, nil];
            [error show];
        }
    }
    else {
        UIAlertView *error = [[UIAlertView alloc] initWithTitle:strMessageErrorTitle message:strMessageError delegate:self cancelButtonTitle:@"OK" otherButtonTitles:nil, nil];
        [error show];
    }
}

- (void) displayComposerSheet
{
    
    MFMailComposeViewController *picker = [[MFMailComposeViewController alloc] init];
    picker.mailComposeDelegate = self;
    NSArray *toRecipients = [NSArray arrayWithObject:mail_Recipient];
    [picker setToRecipients:toRecipients];
    [picker setSubject:mail_Subject];
    [self presentModalViewController:picker animated:YES];
}

- (void)mailComposeController:(MFMailComposeViewController *)controller didFinishWithResult:(MFMailComposeResult)result error:(NSError *)error
{
	if (result == MFMailComposeResultSent){
		UIAlertView *Notpermitted=[[UIAlertView alloc] initWithTitle:strMailEnviado message:strMailEnviadoMessage delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
        [Notpermitted show];
	} else if (result == MFMailComposeResultFailed){
		UIAlertView *Notpermitted=[[UIAlertView alloc] initWithTitle:strMailNoEnviado message:strMailNoEnviadoMessage delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
        [Notpermitted show];
	}
	
    [self dismissModalViewControllerAnimated:YES];
}


#pragma mark - FACEBOOK METHODS


- (void)onClicFacebookModal{
    
    // Create the parameters dictionary that will keep the data that will be posted.
    NSMutableDictionary* params = [NSMutableDictionary dictionaryWithObjectsAndKeys:
                                   fb_appId, @"app_id",
                                   @"http://turismo.euskadi.net", @"link",
                                   @"http://turismo.euskadi.net/images/x65-logo-turismo-Euskadi-es.png", @"picture",
                                   @"iEuskadi", @"name",
                                   @"Comparte Euskadi", @"caption",
                                   @"Aplicación de turismo de Euskadi", @"description",
                                   nil];
    
    [facebook dialog:@"feed" andParams:params andDelegate:self];
    [facebook logout];
    
}


#pragma mark - Language METHODS


-(void) didClose{
    self.navigationItem.leftBarButtonItem.enabled = YES;
    self.btnConnect.enabled = YES;
    btnLayar.enabled = YES;
    btnFavoritos.enabled = YES;
    btnRecursos.enabled = YES;
}

- (void) didSelect:(int) option
{
    self.navigationItem.leftBarButtonItem.enabled = YES;
    self.btnConnect.enabled = YES;
    btnLayar.enabled = YES;
    btnFavoritos.enabled = YES;
    btnRecursos.enabled = YES;
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
	if(option==1)
		[defaults setObject:@"eu-ES" forKey:@"AppLanguage"];
	else if(option==2)
		[defaults setObject:@"es" forKey:@"AppLanguage"];
	else if(option==3)
		[defaults setObject:@"en" forKey:@"AppLanguage"];
    else if(option==4)
		[defaults setObject:@"fr" forKey:@"AppLanguage"];
    else if(option==5)
		[defaults setObject:@"de" forKey:@"AppLanguage"];
    
    [[NSUserDefaults standardUserDefaults] synchronize];
    
    [self recargarLiterales];
    
}

#pragma mark - Modal conectar METHODS

- (void) didCloseConectar{
    self.navigationItem.leftBarButtonItem.enabled = YES;
    self.btnConnect.enabled = YES;
    btnLayar.enabled = YES;
    btnFavoritos.enabled = YES;
    btnRecursos.enabled = YES;
}
- (void) didSelectConect:(int) option{
    self.navigationItem.leftBarButtonItem.enabled = YES;
    self.btnConnect.enabled = YES;
    btnLayar.enabled = YES;
    btnFavoritos.enabled = YES;
    btnRecursos.enabled = YES;
    switch (option) {
        case 1:
            [self onClicFacebookModal];
            break;
        case 2:
            [self enviarTweet];
            break;
        case 3:
            break;
        case 4:
            [self showPicker];
            break;
        default:
            break;
    }
}

@end
