//
//  RootViewController.h
//  iEuskadi
//
//  Created by Gonzalo Torres Ayastuy on 18/05/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "RecursosTuristicosViewController.h"
#import "MessageUI/MessageUI.h"
#import "MessageUI/MFMailComposeViewController.h"
#import "SeleccionIdioma.h"
#import "traducirLiteral.h"
#import "FavoritosViewController.h"
#import "UIColor(Extras).h"
#import "ModalConectar.h"

// Facebook App ID
#define fb_appId                    @"212860918835240"

#define mail_Subject                @"[iEuskadi]"
#define mail_Recipient              @"promocion-turistica@ej-gv.es"
#define tweet_message               @"@TvEuskadi #iEuskadi "

@interface RootViewController : UIViewController <MFMailComposeViewControllerDelegate, FBSessionDelegate, FBRequestDelegate, FBDialogDelegate, SeleccionIdiomaDelegate, ModalConectarDelegate>{
    
    NSString *titleVCRecursos;
    NSString *strMessageErrorTitle;
    NSString *strMessageError;
    NSString *strTweetError;
    NSString *strTweetSuccess;
    NSString *strTweetErrorTitle;
    NSString *strTweetSuccessTitle;
    NSString *strMailEnviado;
    NSString *strMailNoEnviado;
    NSString *strMailEnviadoMessage;
    NSString *strMailNoEnviadoMessage;
    NSString *strFavoritos;
    
    UILabel *_lblRecursos;
    UILabel *_lblRealidadAumentada;
    UILabel *_lblFavoritos;
    
    Facebook *facebook;
    
    SeleccionIdioma *_seleccionIdioma;
    ModalConectar *_modalConectar;
    
    //SlideShow
    NSMutableArray *_photos;
    NSTimer *timer;
    int _currentImage;
    
    //Background image
    UIImageView *imgBackground;
    
}


// NavBar Buttons
@property (nonatomic, strong) UIButton *btnIdioma;
@property (nonatomic, strong) UIButton *btnConnect;

//Buttons
@property (nonatomic, strong) IBOutlet UIButton *btnRecursos;
@property (nonatomic, strong) IBOutlet UIButton *btnLayar;
@property (nonatomic, strong) IBOutlet UIButton *btnFavoritos;

//Background image
@property (nonatomic, strong) IBOutlet UIView *viewBack;
@property (nonatomic, strong) IBOutlet UIImageView *imgBackground;

@property (strong, nonatomic) Facebook *facebook;

//Métodos
- (IBAction)enviarTweet;
- (IBAction)onClickBtnRecursos:(id)sender;
- (IBAction)onClickBtnFacebook:(id)sender;
- (IBAction)onClickBtnIdioma:(id)sender;
- (IBAction)onClickBtnAbrirLayar:(id)sender;
- (IBAction)onClickBtnAbrirFavoritos:(id)sender;
- (IBAction)onClickBtnConnect:(id)sender;
- (IBAction)showPicker:(id)sender;
- (void) displayComposerSheet;


@end
