//
//  RecursosTuristicosViewController.m
//  iEuskadi
//
//  Created by Gonzalo Torres Ayastuy on 21/05/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import <QuartzCore/QuartzCore.h>
#import "RecursosTuristicosViewController.h"
#import "AppDelegate.h"

@implementation RecursosTuristicosViewController

@synthesize viewRecursos, viewBotones;

#pragma mark - View Lifecycle

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    self.viewRecursos.layer.cornerRadius = 10.0f;
    self.viewRecursos.layer.borderColor = [UIColor colorWithRed:1.0 green:1.0 blue:1.0 alpha:0.6].CGColor;
    self.viewRecursos.layer.borderWidth = 2.0f;
    self.viewRecursos.layer.shadowColor = [UIColor grayColor].CGColor;
    // Creating shadow path for better performance
    CGMutablePathRef path = CGPathCreateMutable();
    CGPathAddRect(path, NULL, self.viewRecursos.bounds);
    self.viewRecursos.layer.shadowPath = path;
    self.viewRecursos.layer.shadowOffset = CGSizeMake(5, 5);
    self.viewRecursos.layer.shadowRadius = 5.0f;
    self.viewRecursos.layer.shadowOpacity = 0.4;
    
    self.viewRecursos.layer.backgroundColor = [UIColor colorWithRed:1.0 green:1.0 blue:1.0 alpha:0.7].CGColor;
    
    self.viewBotones.layer.cornerRadius = 10.0f;
    self.viewBotones.layer.borderColor = [UIColor grayColor].CGColor;
    self.viewBotones.layer.borderWidth = 2.0f;
    self.viewBotones.layer.shadowColor = [UIColor grayColor].CGColor;
    // Creating shadow path for better performance
    //CGMutablePathRef path = CGPathCreateMutable();
    CGPathAddRect(path, NULL, self.viewBotones.bounds);
    self.viewBotones.layer.shadowPath = path;
    self.viewBotones.layer.shadowOffset = CGSizeMake(5, 5);
    self.viewBotones.layer.shadowRadius = 5.0f;
    self.viewBotones.layer.shadowOpacity = 0.4;
    
    self.viewBotones.layer.backgroundColor = [UIColor colorWithRed:1.0 green:1.0 blue:1.0 alpha:0.6].CGColor;
    
    isClickedCultura = YES;
    isClickedDeporte = YES;
    isClickedPlayas = YES;
    isClickedInfo = YES;
    isClickedTransporte = YES;
    isClickedComer = YES;
    isClickedDormir = YES;
    isClickedExperiencias = YES;
    isClickedReuniones = YES;
    
    self.btnAbrirLista.layer.shadowColor = [UIColor blackColor].CGColor;
	self.btnAbrirLista.layer.shadowOpacity = 0.8f;
	self.btnAbrirLista.layer.shadowRadius = 3.0f;
	self.btnAbrirLista.layer.cornerRadius = 3.0f;
    self.btnAbrirLista.layer.shadowOffset = CGSizeMake(2, 5);
    
    self.btnAbrirMapa.layer.shadowColor = [UIColor blackColor].CGColor;
	self.btnAbrirMapa.layer.shadowOpacity = 0.8f;
	self.btnAbrirMapa.layer.shadowRadius = 3.0f;
	self.btnAbrirMapa.layer.cornerRadius = 3.0f;
    self.btnAbrirMapa.layer.shadowOffset = CGSizeMake(2, 5);
    
    arrCategorias = [[NSMutableArray alloc] init];
    
    self.btnAbrirMapa.enabled = YES;
    self.btnAbrirLista.enabled = YES;
    
    [self.slider addTarget:self action:@selector(mySliderChanged:) forControlEvents:UIControlEventValueChanged];
    
    [self recargarLiterales];
    
    locationManager = [[CLLocationManager alloc] init];
    locationManager.delegate = self;
    
    [locationManager startUpdatingLocation];
    
    CLAuthorizationStatus authStatus = [CLLocationManager authorizationStatus];
    
    if( !(authStatus == kCLAuthorizationStatusAuthorized))
    {
        [locationManager stopUpdatingHeading];
        [locationManager stopUpdatingLocation];
    }

}


- (void)viewDidUnload
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}

#pragma mark - Segues

- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender
{
    // Make sure your segue name in storyboard is the same as this line
    if ([[segue identifier] isEqualToString:@"listado_recursos"])
    {
        ListaRecursosViewController *vc = (ListaRecursosViewController*)[segue destinationViewController];
        if ([self hayRed]){
            vc.title = [traducirLiteral languageSelectedStringForKey:@"LISTA"];
            vc.strDistancia = [NSString stringWithFormat:@"%d",(int) self.slider.value];
            vc.arrCategorias = [self crearArrayCategorias];
        } else {
            UIAlertView *notpermitted=[[UIAlertView alloc] initWithTitle:strSinRed message:strSinRedMessage delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
            [notpermitted show];
        }
    } else if ([segue.identifier isEqualToString:@"mapa_recursos"]){
        if ([self hayRed]){
            MapaRecursosViewController *vc = (MapaRecursosViewController*)[segue destinationViewController];
            vc.title = [traducirLiteral languageSelectedStringForKey:@"MAPA"];
            vc.strDistancia = [NSString stringWithFormat:@"%d",(int) self.slider.value];
            vc.arrCategorias = [self crearArrayCategorias];
        } else {
            UIAlertView *notpermitted=[[UIAlertView alloc] initWithTitle:strSinRed message:strSinRedMessage delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
            [notpermitted show];
        }
    }
}


#pragma mark - Eventos


-(IBAction)onClickBtnCultura:(id)sender
{
    if (!isClickedCultura){
        isClickedCultura = YES;
        [self.btnCultura setImage:[UIImage imageNamed:@"iconCultura"] forState:UIControlStateNormal];
        self.lblCultura.enabled = YES;
        [self activarBtnMapa];
    } else {
        isClickedCultura = NO;
        [self.btnCultura setImage:[UIImage imageNamed:@"iconCulturaGris.png"] forState:UIControlStateNormal];
        self.lblCultura.enabled = NO;
        [self activarBtnMapa];
    }
}
-(IBAction)onClickBtnDeporte:(id)sender
{
    if (!isClickedDeporte){
        isClickedDeporte = YES;
        [self.btnDeporte setImage:[UIImage imageNamed:@"iconDeportes"] forState:UIControlStateNormal];
        self.lblDeportes.enabled = YES;
        [self activarBtnMapa];
    } else {
        isClickedDeporte = NO;
        [self.btnDeporte setImage:[UIImage imageNamed:@"iconDeportesGris"] forState:UIControlStateNormal];
        self.lblDeportes.enabled = NO;
        [self activarBtnMapa];
    }
}
-(IBAction)onClickBtnPlayas:(id)sender
{
    if (!isClickedPlayas){
        isClickedPlayas = YES;
        [self.btnPlayas setImage:[UIImage imageNamed:@"iconPlayas"] forState:UIControlStateNormal];
        self.lblPlayas.enabled = YES;
        [self activarBtnMapa];
    }
    else {
        isClickedPlayas = NO;
        [self.btnPlayas setImage:[UIImage imageNamed:@"iconPlayasGris"] forState:UIControlStateNormal];
        self.lblPlayas.enabled = NO;
        [self activarBtnMapa];
    }
}
-(IBAction)onClickBtnInfo:(id)sender
{
    if (!isClickedInfo){
        isClickedInfo = YES;
        [self.btnInfo setImage:[UIImage imageNamed:@"iconInfo"] forState:UIControlStateNormal];
        self.lblOficinas.enabled = YES;
        [self activarBtnMapa];
    }
    else {
        isClickedInfo = NO;
        [self.btnInfo setImage:[UIImage imageNamed:@"iconInfoGris"] forState:UIControlStateNormal];
        self.lblOficinas.enabled = NO;
        [self activarBtnMapa];
    }
}
-(IBAction)onClickBtnTransporte:(id)sender
{
    if (!isClickedTransporte){
        isClickedTransporte = YES;
        [self.btnTransporte setImage:[UIImage imageNamed:@"iconTransporte"] forState:UIControlStateNormal];
        self.lblMoverse.enabled = YES;
        [self activarBtnMapa];
    }
    else {
        isClickedTransporte = NO;
        [self.btnTransporte setImage:[UIImage imageNamed:@"iconTransporteGris"] forState:UIControlStateNormal];
        self.lblMoverse.enabled = NO;
        [self activarBtnMapa];
    }
}
-(IBAction)onClickBtnComer:(id)sender
{
    if (!isClickedComer){
        isClickedComer = YES;
        [self.btnComer setImage:[UIImage imageNamed:@"iconComer"] forState:UIControlStateNormal];
        self.lblComer.enabled = YES;
        [self activarBtnMapa];
    }
    else {
        isClickedComer = NO;
        [self.btnComer setImage:[UIImage imageNamed:@"iconComerGris.png"] forState:UIControlStateNormal];
        self.lblComer.enabled = NO;
        [self activarBtnMapa];
    }
}
-(IBAction)onClickBtnDormir:(id)sender
{
    if (!isClickedDormir){
        isClickedDormir = YES;
        [self.btnDormir setImage:[UIImage imageNamed:@"iconDormir"] forState:UIControlStateNormal];
        self.lblDormir.enabled = YES;
        [self activarBtnMapa];
    }
    else {
        isClickedDormir = NO;
        [self.btnDormir setImage:[UIImage imageNamed:@"iconDormirGris"] forState:UIControlStateNormal];
        self.lblDormir.enabled = NO;
        [self activarBtnMapa];
    }
}
-(IBAction)onClickBtnExperiencias:(id)sender
{
    if (!isClickedExperiencias){
        isClickedExperiencias = YES;
        [self.btnExperiencias setImage:[UIImage imageNamed:@"iconExperiencias"] forState:UIControlStateNormal];
        self.lblExperiencias.enabled = YES;
        [self activarBtnMapa];
    }
    else {
        isClickedExperiencias = NO;
        [self.btnExperiencias setImage:[UIImage imageNamed:@"iconExperienciasGris"] forState:UIControlStateNormal];
        self.lblExperiencias.enabled = NO;
        [self activarBtnMapa];
    }
}
-(IBAction)onClickBtnReuniones:(id)sender
{
    if (!isClickedReuniones){
        isClickedReuniones = YES;
        [self.btnReuniones setImage:[UIImage imageNamed:@"iconReuniones"] forState:UIControlStateNormal];
        self.lblReuniones.enabled = YES;
        [self activarBtnMapa];
    } else {
        isClickedReuniones = NO;
        [self.btnReuniones setImage:[UIImage imageNamed:@"iconReunionesGris"] forState:UIControlStateNormal];
        self.lblReuniones.enabled = NO;
        [self activarBtnMapa];
    }
    
}


#pragma mark - Otros


- (NSMutableArray *) crearArrayCategorias
{
    [arrCategorias removeAllObjects];
    if (isClickedCultura) [arrCategorias addObject:[NSNumber numberWithInt:1]];
    if (isClickedTransporte) [arrCategorias addObject:[NSNumber numberWithInt:2]];
    if (isClickedDeporte) [arrCategorias addObject:[NSNumber numberWithInt:3]];
    if (isClickedComer) [arrCategorias addObject:[NSNumber numberWithInt:4]];
    if (isClickedDormir) [arrCategorias addObject:[NSNumber numberWithInt:5]];
    if (isClickedExperiencias) [arrCategorias addObject:[NSNumber numberWithInt:6]];
    if (isClickedPlayas) [arrCategorias addObject:[NSNumber numberWithInt:7]];
    if (isClickedInfo) [arrCategorias addObject:[NSNumber numberWithInt:8]];
    if (isClickedReuniones) [arrCategorias addObject:[NSNumber numberWithInt:9]];
    return arrCategorias;
}

-(void) activarBtnMapa
{
    if (isClickedCultura||isClickedComer||isClickedDeporte||isClickedDormir||isClickedExperiencias||isClickedInfo||isClickedPlayas||isClickedTransporte||isClickedReuniones){
        self.btnAbrirMapa.enabled = YES;
        self.btnAbrirLista.enabled = YES;
    }else{
        self.btnAbrirMapa.enabled = NO;
        self.btnAbrirLista.enabled = NO;
    }
}

-(BOOL) hayRed
{
    AppDelegate *appDelegate = [[UIApplication sharedApplication] delegate];
    if ([appDelegate.netStatus isEqualToString:@"WWAN"] || [appDelegate.netStatus isEqualToString:@"WIFI"]) return YES;
    return NO;
}

#pragma mark - Traducción

-(void) recargarLiterales{
    self.navigationItem.title = [traducirLiteral languageSelectedStringForKey:@"TITLERECURSOS"];
    [self.lblCultura setText:[traducirLiteral languageSelectedStringForKey:@"CULTURA"]];
    [self.lblDeportes setText: [traducirLiteral languageSelectedStringForKey:@"DEPORTES"]];
    [self.lblMoverse setText: [traducirLiteral languageSelectedStringForKey:@"COMOMOVERSE"]];
    [self.lblDormir setText: [traducirLiteral languageSelectedStringForKey:@"DONDEDORMIR"]];
    [self.lblComer setText: [traducirLiteral languageSelectedStringForKey:@"DONDECOMER"]];
    [self.lblPlayas setText: [traducirLiteral languageSelectedStringForKey:@"PLAYAS"]];
    [self.lblExperiencias setText: [traducirLiteral languageSelectedStringForKey:@"EXPERIENCIASTOP"]];
    [self.lblOficinas setText: [traducirLiteral languageSelectedStringForKey:@"OFICINASDETURISMO"]];
    [self.lblReuniones setText: [traducirLiteral languageSelectedStringForKey:@"REUNIONES"]];
    titleVCMapa = [traducirLiteral languageSelectedStringForKey:@"MAPA"];
    strSinRed = [traducirLiteral languageSelectedStringForKey:@"SINRED"];
    strSinRedMessage = [traducirLiteral languageSelectedStringForKey:@"CONEXION"];
    [self.btnAbrirMapa setTitle:[traducirLiteral languageSelectedStringForKey:@"MAPA"] forState:UIControlStateNormal];
    [self.btnAbrirLista setTitle:[traducirLiteral languageSelectedStringForKey:@"LISTA"] forState:UIControlStateNormal];
}

#pragma mark - Slider

-(void) mySliderChanged:(id) sender{
    [self.lblDistancia setText:[NSString stringWithFormat:@"%d m", (int) self.slider.value]];
}


#pragma mark - Leyenda delegate

-(void) didClose{
    btnLeyenda.enabled = YES;
}

#pragma mark - CORE LOCATION delegate

- (void)locationManager:(CLLocationManager *)manager didUpdateToLocation:(CLLocation *)newLocation fromLocation:(CLLocation *)oldLocation
{
    [locationManager stopUpdatingLocation];
}

- (void)locationManager:(CLLocationManager *)manager didChangeAuthorizationStatus:(CLAuthorizationStatus)status {
    if( !(status == kCLAuthorizationStatusAuthorized)){
        [locationManager stopUpdatingHeading];
        [locationManager stopUpdatingLocation];
    }
}


@end
