//
//  RecursosTuristicosViewController.h
//  iEuskadi
//
//  Created by Gonzalo Torres Ayastuy on 21/05/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "MapaRecursosViewController.h"
#import "traducirLiteral.h"
#import "ListaRecursosViewController.h"
//#import "LayarPlayer.h"
#import "LeyendaMapa.h"

@interface RecursosTuristicosViewController : UIViewController<LeyendaMapaDelegate, CLLocationManagerDelegate>{

    UIView *viewRecursos;
    UIView *viewBotones;
    
    BOOL isClickedCultura;
    BOOL isClickedDeporte;
    BOOL isClickedPlayas;
    BOOL isClickedInfo;
    BOOL isClickedTransporte;
    BOOL isClickedComer;
    BOOL isClickedDormir;
    BOOL isClickedExperiencias;
    BOOL isClickedReuniones;
    
    //Array de categorías seleccionadas
    NSMutableArray *arrCategorias;
    
    NSString *titleVCMapa;
    NSString *strSinRed;
    NSString *strSinRedMessage;
    
    //Vista de la leyenda
    UIButton *btnLeyenda;
    LeyendaMapa *_leyendaMapa;
    
    //User Location
    CLLocationManager *locationManager;
    
}

@property(nonatomic, strong) IBOutlet UIView *viewRecursos;
@property(nonatomic, strong) IBOutlet UIView *viewBotones;

//Botones
@property(nonatomic, strong) IBOutlet UIButton *btnCultura;
@property(nonatomic, strong) IBOutlet UIButton *btnDeporte;
@property(nonatomic, strong) IBOutlet UIButton *btnPlayas;
@property(nonatomic, strong) IBOutlet UIButton *btnInfo;
@property(nonatomic, strong) IBOutlet UIButton *btnTransporte;
@property(nonatomic, strong) IBOutlet UIButton *btnComer;
@property(nonatomic, strong) IBOutlet UIButton *btnDormir;
@property(nonatomic, strong) IBOutlet UIButton *btnExperiencias;
@property(nonatomic, strong) IBOutlet UIButton *btnReuniones;
@property(nonatomic, strong) IBOutlet UIButton *btnAbrirMapa;
@property(nonatomic, strong) IBOutlet UIButton *btnAbrirLista;
@property(nonatomic, strong) IBOutlet UIButton *btnAbrirLayar;

//Labels
@property(nonatomic, strong) IBOutlet UILabel *lblCultura;
@property(nonatomic, strong) IBOutlet UILabel *lblDeportes;
@property(nonatomic, strong) IBOutlet UILabel *lblMoverse;
@property(nonatomic, strong) IBOutlet UILabel *lblComer;
@property(nonatomic, strong) IBOutlet UILabel *lblDormir;
@property(nonatomic, strong) IBOutlet UILabel *lblPlayas;
@property(nonatomic, strong) IBOutlet UILabel *lblExperiencias;
@property(nonatomic, strong) IBOutlet UILabel *lblOficinas;
@property(nonatomic, strong) IBOutlet UILabel *lblDistancia;
@property(nonatomic, strong) IBOutlet UILabel *lblReuniones;

//Slider distancia
@property(nonatomic, strong) IBOutlet UISlider *slider;

//Métodos
-(IBAction)onClickBtnCultura:(id)sender;
-(IBAction)onClickBtnDeporte:(id)sender;
-(IBAction)onClickBtnPlayas:(id)sender;
-(IBAction)onClickBtnInfo:(id)sender;
-(IBAction)onClickBtnTransporte:(id)sender;
-(IBAction)onClickBtnComer:(id)sender;
-(IBAction)onClickBtnDormir:(id)sender;
-(IBAction)onClickBtnExperiencias:(id)sender;
-(IBAction)onClickBtnReuniones:(id)sender;

@end
