//
//  SeleccionIdioma.m
//  iEuskadi
//
//  Created by Gonzalo Torres Ayastuy on 08/06/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "ModalTelefono.h"
#import <QuartzCore/QuartzCore.h>

@implementation ModalTelefono

@synthesize btnLlamar, delegate, btnCancel, btnAgregar;
@synthesize lblAgregar, lblLlamar;

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        // Initialization code
    }
    return self;
}

-(id) initWithTitle:(NSString *)title image:(UIImage*)_image comesFrom:(NSString *)_comes{
    
    self = [super initWithFrame:CGRectMake(0, 0, 320, 130)];
    
    self.layer.backgroundColor = [UIColor clearColor].CGColor;
    
    UIView *viewBack = [[UIView alloc] initWithFrame:CGRectMake(self.layer.frame.origin.x+15, self.layer.frame.origin.y+15, self.layer.frame.size.width-30, self.layer.frame.size.height-30)];
    viewBack.layer.cornerRadius = 10.0f;
    viewBack.layer.borderWidth = 1.0f;
    viewBack.layer.borderColor = [UIColor lightGrayColor].CGColor;
    viewBack.layer.masksToBounds = YES;
    viewBack.alpha = 0.9f;
    
    [viewBack setBackgroundColor:[UIColor whiteColor]];
    
    //button Facebook
    
    btnLlamar = [UIButton buttonWithType:UIButtonTypeCustom];
    [btnLlamar setBackgroundColor:[UIColor whiteColor]];
    btnLlamar.frame = CGRectMake(0, 0, viewBack.layer.frame.size.width, 50);
    [btnLlamar addTarget:self action:@selector(onClickLlamar:) forControlEvents:UIControlEventTouchUpInside];
    btnLlamar.layer.borderWidth = 1.0f;
    btnLlamar.layer.borderColor = [UIColor lightGrayColor].CGColor;
    [btnLlamar setBackgroundImage:[UIImage imageNamed:@"fondoCeldaIdioma"] forState:UIControlStateHighlighted];
    [viewBack insertSubview:btnLlamar aboveSubview:viewBack];
    
    //label Facebook
    lblLlamar = [[UILabel alloc] initWithFrame:CGRectMake(100, 5, 270, 50)];
    lblLlamar.backgroundColor = [UIColor clearColor];
    lblLlamar.center = btnLlamar.center;
    lblLlamar.font = [UIFont fontWithName:@"Verdana" size:16];
    lblLlamar.textAlignment = NSTextAlignmentCenter;
    [lblLlamar setTextColor:[UIColor darkGrayColor]];
    [viewBack insertSubview:lblLlamar aboveSubview:viewBack];
    
    btnAgregar = [UIButton buttonWithType:UIButtonTypeCustom];
    [btnAgregar setBackgroundColor:[UIColor whiteColor]];
    btnAgregar.frame = CGRectMake(0, btnLlamar.layer.frame.size.height, viewBack.layer.frame.size.width, 50);
    [btnAgregar addTarget:self action:@selector(onClickAgregar:) forControlEvents:UIControlEventTouchUpInside];
    btnAgregar.layer.borderWidth = 0.5f;
    btnAgregar.layer.borderColor = [UIColor lightGrayColor].CGColor;
    [btnAgregar setBackgroundImage:[UIImage imageNamed:@"fondoCeldaIdioma"] forState:UIControlStateHighlighted];
    [viewBack insertSubview:btnAgregar aboveSubview:viewBack];
    
    //label Twitter
    lblAgregar = [[UILabel alloc] initWithFrame:CGRectMake(100, 60, 270, 50)];
    lblAgregar.backgroundColor = [UIColor clearColor];
    lblAgregar.center = btnAgregar.center;
    lblAgregar.font = [UIFont fontWithName:@"Verdana" size:16];
    lblAgregar.textAlignment = NSTextAlignmentCenter;
    [lblAgregar setTextColor:[UIColor darkGrayColor]];
    [viewBack insertSubview:lblAgregar aboveSubview:viewBack];
    
    [self recargarLiterales];
    
    [self insertSubview:viewBack aboveSubview:self];
    
    //button cancel
    btnCancel = [UIButton buttonWithType:UIButtonTypeCustom];
    [btnCancel setBackgroundImage:[UIImage imageNamed:@"iconCloseX.png"] forState:UIControlStateNormal];
    btnCancel.frame = CGRectMake(self.frame.size.width -40, 5, btnCancel.currentBackgroundImage.size.width, btnCancel.currentBackgroundImage.size.height);
    [btnCancel addTarget:self action:@selector(cancelAndClose:) forControlEvents:UIControlEventTouchUpInside];
    [self insertSubview:btnCancel aboveSubview:self];
    self.transform = CGAffineTransformMakeScale(1.0, 0.1);
    
    
    
    return self;
}

-(void)show
{
    
    [UIView beginAnimations:@"playAnimation" context:nil];
    [UIView setAnimationDuration:0.5f];
    self.transform = CGAffineTransformMakeScale(1.0, 1.0);
    [UIView commitAnimations];
    
}

-(IBAction)cancelAndClose:(id)sender{
    
    [UIView setAnimationDuration:0.5f];
    self.transform = CGAffineTransformMakeScale(0.1, 0.1);
    [UIView commitAnimations];
    [delegate didCloseTelefono];
    
    [self removeFromSuperview];
    
}

-(IBAction)onClickLlamar:(id)sender{
    [delegate didSelectTelefono:1];
    [self removeFromSuperview];
    
}

-(IBAction)onClickAgregar:(id)sender{
    [delegate didSelectTelefono:2];
    [self removeFromSuperview];
    
}

-(void) recargarLiterales{
    
    [lblAgregar setText:[traducirLiteral languageSelectedStringForKey:@"AGREGAR"]];
    [lblLlamar setText:[traducirLiteral languageSelectedStringForKey:@"LLAMAR"]];

}

@end
