//
//  SeleccionIdioma.m
//  iEuskadi
//
//  Created by Gonzalo Torres Ayastuy on 08/06/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "ModalConectar.h"
#import <QuartzCore/QuartzCore.h>

@implementation ModalConectar

@synthesize btnFacebook, btnMail, btnTwitter, delegate, btnCancel;
@synthesize lblFacebook, lblMail, lblTwitter;

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        // Initialization code
    }
    return self;
}

-(id) initWithTitle:(NSString *)title image:(UIImage*)_image comesFrom:(NSString *)_comes{
    
    if ([_comes isEqual: @"detalle"]){
        self = [super initWithFrame:CGRectMake(0, 0, 320, 130)];
    } else{
        self = [super initWithFrame:CGRectMake(0, 0, 320, 180)];
    }
    
    self.layer.backgroundColor = [UIColor clearColor].CGColor;
    
    UIView *viewBack = [[UIView alloc] initWithFrame:CGRectMake(self.layer.frame.origin.x+15, self.layer.frame.origin.y+15, self.layer.frame.size.width-30, self.layer.frame.size.height-30)];
    viewBack.layer.cornerRadius = 10.0f;
    viewBack.layer.borderWidth = 1.0f;
    viewBack.layer.borderColor = [UIColor lightGrayColor].CGColor;
    viewBack.layer.masksToBounds = YES;
    viewBack.alpha = 0.9f;
    
    [viewBack setBackgroundColor:[UIColor whiteColor]];
    
    //button Facebook
    UIImageView *imgFacebook = [[UIImageView alloc] initWithFrame: CGRectMake(35, 5, 40, 40)];
    imgFacebook.image = [UIImage imageNamed:@"imgFacebook"];
    
    btnFacebook = [UIButton buttonWithType:UIButtonTypeCustom];
    [btnFacebook setBackgroundColor:[UIColor whiteColor]];
    btnFacebook.frame = CGRectMake(0, 0, viewBack.layer.frame.size.width, 50);
    [btnFacebook addTarget:self action:@selector(onClickFacebook:) forControlEvents:UIControlEventTouchUpInside];
    btnFacebook.layer.borderWidth = 1.0f;
    btnFacebook.layer.borderColor = [UIColor lightGrayColor].CGColor;
    [btnFacebook setBackgroundImage:[UIImage imageNamed:@"fondoCeldaIdioma"] forState:UIControlStateHighlighted];
    [btnFacebook addSubview:imgFacebook];
    [viewBack insertSubview:btnFacebook aboveSubview:viewBack];
    
    //label Facebook
    lblFacebook = [[UILabel alloc] initWithFrame:CGRectMake(100, 5, 150, 50)];
    lblFacebook.backgroundColor = [UIColor clearColor];
    lblFacebook.center = btnFacebook.center;
    lblFacebook.font = [UIFont fontWithName:@"Verdana" size:21];
    lblFacebook.textAlignment = NSTextAlignmentCenter;
    [lblFacebook setTextColor:[UIColor darkGrayColor]];
    [viewBack insertSubview:lblFacebook aboveSubview:viewBack];
    
    //button Twitter
    UIImageView *imgTwitter = [[UIImageView alloc] initWithFrame:CGRectMake(35, 5, 40, 40)];
    imgTwitter.image = [UIImage imageNamed:@"imgTwitter"];

    btnTwitter = [UIButton buttonWithType:UIButtonTypeCustom];
    [btnTwitter setBackgroundColor:[UIColor whiteColor]];
    btnTwitter.frame = CGRectMake(0, btnFacebook.layer.frame.size.height, viewBack.layer.frame.size.width, 50);
    [btnTwitter addTarget:self action:@selector(onClickTwitter:) forControlEvents:UIControlEventTouchUpInside];
    btnTwitter.layer.borderWidth = 0.5f;
    btnTwitter.layer.borderColor = [UIColor lightGrayColor].CGColor;
    [btnTwitter setBackgroundImage:[UIImage imageNamed:@"fondoCeldaIdioma"] forState:UIControlStateHighlighted];
    [btnTwitter addSubview:imgTwitter];
    [viewBack insertSubview:btnTwitter aboveSubview:viewBack];
    
    //label Twitter
    lblTwitter = [[UILabel alloc] initWithFrame:CGRectMake(100, 60, 150, 50)];
    lblTwitter.backgroundColor = [UIColor clearColor];
    lblTwitter.center = btnTwitter.center;
    lblTwitter.font = [UIFont fontWithName:@"Verdana" size:21];
    lblTwitter.textAlignment = NSTextAlignmentCenter;
    [lblTwitter setTextColor:[UIColor darkGrayColor]];
    [viewBack insertSubview:lblTwitter aboveSubview:viewBack];
    
    //button Mail
    if (_comes != @"detalle"){
        UIImageView *imgMail = [[UIImageView alloc] initWithFrame:CGRectMake(35, 5, 40, 40)];
        imgMail.image = [UIImage imageNamed:@"imgMail"];
    
        btnMail = [UIButton buttonWithType:UIButtonTypeCustom];
        [btnMail setBackgroundColor:[UIColor whiteColor]];
        btnMail.frame = CGRectMake(0, btnTwitter.layer.frame.origin.y + btnTwitter.layer.frame.size.height, viewBack.layer.frame.size.width, 50);
        [btnMail addTarget:self action:@selector(onClickMail:) forControlEvents:UIControlEventTouchUpInside];
        btnMail.layer.borderWidth = 0.5f;
        btnMail.layer.borderColor = [UIColor lightGrayColor].CGColor;
        [btnMail setBackgroundImage:[UIImage imageNamed:@"fondoCeldaIdioma"] forState:UIControlStateHighlighted];
        [btnMail addSubview:imgMail];
        [viewBack insertSubview:btnMail aboveSubview:viewBack];

    //label Mail
        lblMail = [[UILabel alloc] initWithFrame:CGRectMake(80, 170, 150, 50)];
        lblMail.backgroundColor = [UIColor clearColor];
        lblMail.center = btnMail.center;
        lblMail.font = [UIFont fontWithName:@"Verdana" size:21];
        lblMail.textAlignment = NSTextAlignmentCenter;
        [lblMail setTextColor:[UIColor darkGrayColor]];
        [viewBack insertSubview:lblMail aboveSubview:viewBack];
    }
    [self recargarLiterales];
    
    [self insertSubview:viewBack aboveSubview:self];
    
    //button cancel
    btnCancel = [UIButton buttonWithType:UIButtonTypeCustom];
    [btnCancel setBackgroundImage:[UIImage imageNamed:@"iconCloseX.png"] forState:UIControlStateNormal];
    btnCancel.frame = CGRectMake(self.frame.size.width -40, 5, btnCancel.currentBackgroundImage.size.width, btnCancel.currentBackgroundImage.size.height);
    [btnCancel addTarget:self action:@selector(cancelAndClose:) forControlEvents:UIControlEventTouchUpInside];
    [self insertSubview:btnCancel aboveSubview:self];
    self.transform = CGAffineTransformMakeScale(1.0, 0.1);
    
    
    
    return self;
}

-(void)show
{
    
    [UIView beginAnimations:@"playAnimation" context:nil];
    [UIView setAnimationDuration:0.5f];
    self.transform = CGAffineTransformMakeScale(1.0, 1.0);
    [UIView commitAnimations];
    
}

-(IBAction)cancelAndClose:(id)sender{
    
    [UIView setAnimationDuration:0.5f];
    self.transform = CGAffineTransformMakeScale(0.1, 0.1);
    [UIView commitAnimations];
    [delegate didCloseConectar];
    
    [self removeFromSuperview];
    
}

-(IBAction)onClickFacebook:(id)sender{
    [delegate didSelectConect:1];
    [self removeFromSuperview];
    
}

-(IBAction)onClickTwitter:(id)sender{
    [delegate didSelectConect:2];
    [self removeFromSuperview];
    
}

-(IBAction)onClickMail:(id)sender{
    [delegate didSelectConect:4];
    [self removeFromSuperview];
    
}

-(void) recargarLiterales{
    
    [lblFacebook setText:@"Facebook"];
    [lblMail setText:@"Mail"];
    [lblTwitter setText:@"Twitter"];
    
}

@end
