//
//  MapaRecursosViewController.m
//  iEuskadi
//
//  Created by Gonzalo Torres Ayastuy on 22/05/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "MapaRecursosViewController.h"
#import "AppDelegate.h"
#import "RecursoTuristico.h"
#import <QuartzCore/QuartzCore.h>

@implementation MapaRecursosViewController

@synthesize mapView;
@synthesize addAnnotation;
@synthesize btnTipoMapa;
@synthesize detalleRecursoView;
@synthesize arrCategorias;
@synthesize strDistancia;

#pragma mark - View Lifecycle

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    activity = 1;
    arrRecursos = [[NSMutableArray alloc] init];
    self.mapView.showsUserLocation = YES;
    self.mapView.mapType = MKMapTypeStandard;
    
    //Se posiciona el mapa en el unto indicado
    [self location];
    locationManager = [[CLLocationManager alloc] init];
    locationManager.delegate = self;
    locationManager.distanceFilter = kCLDistanceFilterNone; // whenever we move
    locationManager.desiredAccuracy = kCLLocationAccuracyHundredMeters; // 100 m
    didUpateLocation = 0;
    [locationManager startUpdatingLocation];
    
    CLAuthorizationStatus authStatus = [CLLocationManager authorizationStatus];
    
    if( !(authStatus == kCLAuthorizationStatusAuthorized)) {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Atención" message:@"No tiene permiso para acceder a la localización del dispositivo." delegate:self cancelButtonTitle:@"OK" otherButtonTitles:nil, nil];
        [alert show];
        [locationManager stopUpdatingHeading];
        [locationManager stopUpdatingLocation];
    }
    
    [self.btnTipoMapa setTitle:[traducirLiteral languageSelectedStringForKey:@"MAPA"] forSegmentAtIndex:0];
    [self.btnTipoMapa setTitle:[traducirLiteral languageSelectedStringForKey:@"SATELITE"] forSegmentAtIndex:1];
    [self.btnTipoMapa setTitle:[traducirLiteral languageSelectedStringForKey:@"HIBRIDO"] forSegmentAtIndex:2];
    
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(didReceiveNotificationDescarga:) name:@"NotificacionDescarga" object:nil];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(didReceiveNotificationDescargaError:) name:@"NotificacionDescargaError" object:nil];
    
}

- (void) didReceiveNotificationDescarga: (NSNotification *)notif{
    [_activityIndicator removeFromSuperview];
}

- (void) didReceiveNotificationDescargaError: (NSNotification *)notif{
    [_activityIndicator removeFromSuperview];
    UIAlertView *errorAlert = [[UIAlertView alloc] initWithTitle:@"Error" message:@"Los recursos no están disponibles en estos momentos, disculpen las molestias" delegate:self cancelButtonTitle:@"OK" otherButtonTitles:nil, nil];
    [errorAlert show];
}


- (void)viewDidUnload
{
    [super viewDidUnload];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}

-(void) dealloc
{
    [locationManager stopUpdatingLocation];
    mapView.delegate = nil;
    [[NSNotificationCenter defaultCenter] removeObserver:self name:@"NotificacionDescarga" object:nil];
    [[NSNotificationCenter defaultCenter] removeObserver:self name:@"NotificacionDescargaError" object:nil];
}

-(void) viewWillAppear:(BOOL)animated{
    if (activity == 1) {
        _activityIndicator = [[BMActivityIndicator alloc] initWithPoint:self.view.center withSquare:CGSizeMake(200, 60)];
        _activityIndicator.center = self.view.center;
        [self.view addSubview:_activityIndicator];
    }
    activity = 0;
    
}

#pragma mark - Segues

- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender
{
    // Make sure your segue name in storyboard is the same as this line
    if ([[segue identifier] isEqualToString:@"vista_detalle"])
    {
//        RecursoTuristico *recurso = [[RecursoTuristico alloc] init];
//        recurso = [_arrRecursos objectAtIndex:[self.tableView indexPathForSelectedRow].row];
//        
//        DetalleRecursoViewController *vc = (DetalleRecursoViewController*)[segue destinationViewController];
//        vc.recurso = recurso;
//        // Refresca todo para que desmarque la celda seleccionada
//        // [self.tableView reloadData];
//        
//        /**************************************************************/
        
//        RecursoTuristico *recurso = [[RecursoTuristico alloc] init];
//        for (int i=0; i<[arrRecursos count]; i++){
//            recurso = [arrRecursos objectAtIndex:i];
//            if ([recurso.title isEqualToString: _selectedCallout.annotation.title]){
//                break;
//            }
//        }
        DetalleRecursoViewController *vc = (DetalleRecursoViewController*)[segue destinationViewController];
        vc.title = _selectedCallout.title;
        vc.recurso = _selectedCallout;
    }
}

#pragma mark -

+ (CGFloat)annotationPadding;
{
    return 10.0f;
}
+ (CGFloat)calloutHeight;
{
    return 40.0f;
}

#pragma mark - Funciones de mapa

-(IBAction) getLocation{
    mapView.showsUserLocation = YES;
	
	MKCoordinateRegion region;
    region.center = self.mapView.userLocation.coordinate;
	
    MKCoordinateSpan span;
    span.latitudeDelta  = 0.0025; // Change these values to change the zoom
    span.longitudeDelta = 0.0025;
    region.span = span;
	
    [self.mapView setRegion:region animated:YES];
}

-(IBAction)setMap:(id)sender {
    switch (((UISegmentedControl *) sender).selectedSegmentIndex) {
        case 0:
            self.mapView.mapType = MKMapTypeStandard;
            break;
        case 1:
            self.mapView.mapType = MKMapTypeSatellite;
            break;
        case 2:
            self.mapView.mapType = MKMapTypeHybrid;
            break;
            
        default:
            break;
    }
}

-(void) location{
    //MKCoordinateRegion region;
    float lat = 43.072901;
    NSString *strLat = [NSString stringWithFormat:@"%.4f", lat];
    float lon = -2.609951;
    NSString *strlong = [NSString stringWithFormat:@"%.4f", lon];
    float lonDelta = 1.69872;
    float latDelta = 1.10863;
    NSString *strLatDelta = [NSString stringWithFormat:@"%.4f", latDelta];
    NSString *strLonDelta = [NSString stringWithFormat:@"%.4f", lonDelta];
    CLLocationCoordinate2D locationRegion;
    locationRegion.latitude = [strLat floatValue];
    locationRegion.longitude = [strlong floatValue];
    
    MKCoordinateSpan span = MKCoordinateSpanMake([strLatDelta floatValue], [strLonDelta floatValue]);
    MKCoordinateRegion region = MKCoordinateRegionMake(locationRegion, span);
    
	
    [self.mapView setRegion:region animated:NO];
    [self.mapView regionThatFits:region];
    
    
    self.mapView.delegate = self;
    
    //Se llama al método que pinta el contorno de Euskadi
    [self pintarPoligono];
    
}


/******************************************************
 Método para pintar una capa en el mapa con el controno de
 Euskadi
 *******************************************************/

-(void) pintarPoligono{
    
    //Se lee el contenido del plist con los puntos geográficos del polígono
    NSString *path = [[NSBundle mainBundle] pathForResource:@"KmlEuskadi" ofType:@"plist"];
    
    NSArray *items = [NSArray arrayWithContentsOfFile:path];
    CLLocationCoordinate2D  points[[items count]];
    int i = 0;
    
    //Se añaden los puntos geográficos al array de puntos
    for (NSDictionary *dict in items) {
        
        points[i] = CLLocationCoordinate2DMake([[dict valueForKey:@"Latitud"] doubleValue], [[dict valueForKey:@"Longitud"] doubleValue]);
        i = i+1;
    }
	
    //Se añade el arry de puntos al polígono
    MKPolygon* poly = [MKPolygon polygonWithCoordinates:points count:[items count]];
    poly.title = @"Euskadi";
    
    //Se pinta la capa en el mapa
    [self.mapView addOverlay:poly];
}

/******************************************************
 Método del delagate del mapa que ajusta los valores
 del polígono para pintarlo
 *******************************************************/

- (MKOverlayView *)mapView:(MKMapView *)mapView viewForOverlay:(id <MKOverlay>)overlay
{
    if ([overlay isKindOfClass:[MKPolygon class]])
    {
        MKPolygonView* aView = [[MKPolygonView alloc] initWithPolygon:(MKPolygon*)overlay];
        
        aView.fillColor = [[UIColor grayColor] colorWithAlphaComponent:0.3];
        aView.strokeColor = [[UIColor darkGrayColor] colorWithAlphaComponent:0.5];
        aView.lineWidth = 3;
        
        return aView;
    }
    if ([overlay isKindOfClass:[MKCircle class]])
    {
        MKCircleView* aView = [[MKCircleView alloc] initWithCircle:(MKCircle *)overlay];
        
        aView.fillColor = [[UIColor yellowColor] colorWithAlphaComponent:0.2];
        aView.strokeColor = [[UIColor darkGrayColor] colorWithAlphaComponent:0.4];
        aView.lineWidth = 2;
        
        return aView;
    }
    
    return nil;
}


- (void)locationManager:(CLLocationManager *)manager didUpdateToLocation:(CLLocation *)newLocation fromLocation:(CLLocation *)oldLocation
{
    NSLog(@":: MapaRecursos :: locationManager");
    
    didUpateLocation +=1;
    if (didUpateLocation == 1){
        [self.view addSubview:_activityIndicator];
        arrRecursos = [descargarRecursos descargarRecursosMapa:newLocation arrayCategorias:arrCategorias distance:strDistancia];
        [self mostrarRecursos:arrRecursos];
        
        //Se pinta un círculo alrededor de nuestra posición
        MKCircle *circle = [MKCircle circleWithCenterCoordinate:CLLocationCoordinate2DMake(newLocation.coordinate.latitude, newLocation.coordinate.longitude) radius:[strDistancia doubleValue]];
        circle.title = @"halo";
        
        //Se pinta la capa en el mapa
        [self.mapView addOverlay:circle];
        
    }
    [locationManager stopUpdatingLocation];
    
    float lat = newLocation.coordinate.latitude;
    NSString *strLat = [NSString stringWithFormat:@"%.4f", lat];
    float lon = newLocation.coordinate.longitude;
    NSString *strlong = [NSString stringWithFormat:@"%.4f", lon];
    float lonDelta = 0.0321;
    float latDelta = 0.0151;
    NSString *strLatDelta = [NSString stringWithFormat:@"%.4f", latDelta];
    NSString *strLonDelta = [NSString stringWithFormat:@"%.4f", lonDelta];
    CLLocationCoordinate2D locationRegion;
    locationRegion.latitude = [strLat floatValue];
    locationRegion.longitude = [strlong floatValue];
    
    MKCoordinateSpan span = MKCoordinateSpanMake([strLatDelta floatValue], [strLonDelta floatValue]);
    MKCoordinateRegion region = MKCoordinateRegionMake(locationRegion, span);
    
    
    [self.mapView setRegion:region animated:YES];
    [self.mapView regionThatFits:region];
}

- (void)locationManager:(CLLocationManager *)manager didChangeAuthorizationStatus:(CLAuthorizationStatus)status
{
    if( !(status == kCLAuthorizationStatusAuthorized))
    {
        [locationManager stopUpdatingHeading];
        [locationManager stopUpdatingLocation];
        if ([[self.view subviews] containsObject:_activityIndicator]){
            [_activityIndicator removeFromSuperview];
        }
       
    }
}

- (void) mostrarRecursos: (NSMutableArray *) arrayRecursos
{
    
    NSLog(@":: MapaRecursos :: mostrarRecursos");
    for (int i = 0; i<[arrayRecursos count]; i++) {
        
        RecursoTuristico *recursoMapaArray = nil;
        recursoMapaArray = [arrayRecursos objectAtIndex:i];
        
        float latRecurso = [recursoMapaArray.latitud floatValue];
        NSString *strLatRecurso = [NSString stringWithFormat:@"%.4f", latRecurso];
        float lonRecurso = [recursoMapaArray.longitud floatValue];
        NSString *strlongRecurso = [NSString stringWithFormat:@"%.4f", lonRecurso];
		
        CLLocationCoordinate2D location2D;
        location2D.latitude = [strLatRecurso floatValue];
        location2D.longitude = [strlongRecurso floatValue];
        
        addAnnotation = [[AddressAnnotation alloc] initWithCoordinate:location2D];
        addAnnotation.title = recursoMapaArray.title;
        NSString *dist = [NSString stringWithFormat:@"%.3f", recursoMapaArray.distance];
        dist = [dist stringByAppendingFormat:@" Km."];
        addAnnotation.subtitle = dist;
        [self.mapView addAnnotation:addAnnotation];
    }
    //[_activityIndicator removeFromSuperview];
    //[_activityIndicator release];
}

/*
 * Draws an icon for each item
 */
- (MKAnnotationView *) mapView:(MKMapView *)mapView viewForAnnotation:(id <MKAnnotation>) annotation
{
    NSLog(@":: viewForAnnotation");
    MKAnnotationView *annView;
	if (annotation == self.mapView.userLocation){
        // Draws current location
		annView=[[MKPinAnnotationView alloc] initWithAnnotation:annotation reuseIdentifier:@"currentLoc"];
    	//annView.pinColor = MKPinAnnotationColorRed;
    	annView.canShowCallout = NO;
	} else {
        _selectedCallout = [[RecursoTuristico alloc] init];
        for (int i =0; i<[arrRecursos count]; i++){
            _selectedCallout = [arrRecursos objectAtIndex:i];
            if ([_selectedCallout.title isEqualToString:annotation.title]) {
                break;
            }
        }
        UIImage *image = [[UIImage alloc] init];
        UIImage *flagImage = [[UIImage alloc] init];
        
        switch (_selectedCallout.type.intValue) {
            case 1:
                image = [UIImage imageNamed:@"iconCultura"];
                flagImage = [UIImage imageNamed:@"PinCultura.png"];
                break;
            case 2:
                image = [UIImage imageNamed:@"iconTransporte"];
                flagImage = [UIImage imageNamed:@"PinTransporte.png"];
                break;
            case 3:
                image = [UIImage imageNamed:@"iconDeportes"];
                flagImage = [UIImage imageNamed:@"PinDeportes.png"];
                break;
            case 4:
                image = [UIImage imageNamed:@"iconComer"];
                flagImage = [UIImage imageNamed:@"PinComer.png"];
                break;
            case 5:
                image = [UIImage imageNamed:@"iconDormir"];
                flagImage = [UIImage imageNamed:@"PinDormir.png"];
                break;
            case 6:
                image = [UIImage imageNamed:@"iconExperiencias"];
                flagImage = [UIImage imageNamed:@"PinExperiencias.png"];
                break;
            case 7:
                image = [UIImage imageNamed:@"iconPlayas"];
                flagImage = [UIImage imageNamed:@"PinPlayas.png"];
                break;
            case 8:
                image = [UIImage imageNamed:@"iconInfo"];
                flagImage = [UIImage imageNamed:@"PinInfo.png"];
                break;
            case 9:
                image = [UIImage imageNamed:@"iconReuniones"];
                flagImage = [UIImage imageNamed:@"PinReuniones.png"];
                break;
            default:
                break;
        }
        
        CGRect resizeRect;
        
        resizeRect.size = flagImage.size;
        CGSize maxSize = CGRectInset(self.view.bounds,
                                     [MapaRecursosViewController annotationPadding],
                                     [MapaRecursosViewController annotationPadding]).size;
        
        maxSize.height -= self.navigationController.navigationBar.frame.size.height + [MapaRecursosViewController calloutHeight];
        if (resizeRect.size.width > maxSize.width)
            resizeRect.size = CGSizeMake(maxSize.width, resizeRect.size.height / resizeRect.size.width * maxSize.width);
        if (resizeRect.size.height > maxSize.height)
            resizeRect.size = CGSizeMake(resizeRect.size.width / resizeRect.size.height * maxSize.height, maxSize.height);
        
        resizeRect.origin = (CGPoint){0.0f, 0.0f};
        UIGraphicsBeginImageContext(resizeRect.size);
        [flagImage drawInRect:resizeRect];
        UIImage *resizedImage = UIGraphicsGetImageFromCurrentImageContext();
        UIGraphicsEndImageContext();
        
		annView=[[MKAnnotationView alloc] initWithAnnotation:annotation reuseIdentifier:@"recurso"];
        annView.image = resizedImage;
        
        // Creating shadow path for better performance
        CGMutablePathRef path = CGPathCreateMutable();
        CGPathAddRect(path, NULL, annView.bounds);
        annView.layer.shadowPath = path;
        CGPathCloseSubpath(path);
        CGPathRelease(path);
        annView.layer.shadowOffset = CGSizeMake(2, 2);
        annView.layer.shadowRadius = 2.0f;
        annView.layer.shadowOpacity = 0.6;
        
    	NSString *strTitle = [NSString stringWithString:annotation.title];
    	UIButton *discloseButton = [UIButton buttonWithType: UIButtonTypeDetailDisclosure];
        
    	discloseButton.titleLabel.text = strTitle;
    	discloseButton.accessibilityLabel = strTitle;
        
    	UIImageView *imgView = [[UIImageView alloc] initWithImage:image];
        imgView.frame = CGRectMake(0, 0, 30, 30);
    	annView.leftCalloutAccessoryView = imgView;
        
    	annView.rightCalloutAccessoryView = discloseButton;
        
    	//annView.animatesDrop=NO;
    	annView.canShowCallout = YES;
    	annView.calloutOffset = CGPointMake(-5, 5);
        
	}
    return annView;
}

- (void)mapView:(MKMapView *)mv annotationView:(MKAnnotationView *)pin calloutAccessoryControlTapped:(UIControl *)control
{
    id<MKAnnotation> a = pin.annotation;
    NSArray *results = [arrRecursos filteredArrayUsingPredicate:[NSPredicate predicateWithBlock:^BOOL(id evaluatedObject, NSDictionary *bindings) {
        RecursoTuristico *recurso = (RecursoTuristico*) evaluatedObject;
        NSLog(@":: %hhd", [recurso.title isEqualToString:a.title]);
        return [recurso.title isEqualToString:a.title];
    }]];
    _selectedCallout = [results objectAtIndex:0];
    [self performSegueWithIdentifier:@"vista_detalle" sender:control];
}

-(void) didClose{
    btnLeyenda.enabled = YES;
}


-(void) shadowBar:(CGSize)offset radius:(CGFloat)radius color:(UIColor *)color opacity:(CGFloat)opacity {
    
    // Creating shadow path for better performance
    CGMutablePathRef path = CGPathCreateMutable();
    CGPathAddRect(path, NULL, CGRectMake(0, 0, self.view.frame.size.width, 45));
    self.navigationController.navigationBar.layer.shadowPath = path;
    CGPathCloseSubpath(path);
    CGPathRelease(path);
    
    self.navigationController.navigationBar.layer.shadowColor = color.CGColor;
    self.navigationController.navigationBar.layer.shadowOffset = offset;
    self.navigationController.navigationBar.layer.shadowRadius = radius;
    self.navigationController.navigationBar.layer.shadowOpacity = opacity;
    
    // Default clipsToBounds is YES, will clip off the shadow, so we disable it.
    self.navigationController.navigationBar.clipsToBounds = NO;
    
    
}

@end
