//
//  MapaRecursosViewController.h
//  iEuskadi
//
//  Created by Gonzalo Torres Ayastuy on 22/05/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <MapKit/MapKit.h>
#import <CoreLocation/CoreLocation.h>
#import "AddressAnnotation.h"
#import "DetalleRecursoViewController.h"
#import "LeyendaMapa.h"
#import "BMActivityIndicator.h"
#import "descargarRecursos.h"

@interface MapaRecursosViewController : UIViewController <MKMapViewDelegate,CLLocationManagerDelegate, LeyendaMapaDelegate>{

    //Mapa
    IBOutlet MKMapView *mapView;
    
    //Objeto anotacion
    AddressAnnotation *addAnnotation;
    
    //Segmented Control
    UISegmentedControl *btnTipoMapa;
    
    //User Location
    CLLocationManager *locationManager;
    
    int didUpateLocation;
    
    //Array donde se cargan los Recursos
    NSMutableArray *arrRecursos;
    //Array de categorías que viene desde la pantalla de selección
    NSMutableArray *arrCategorias;
    
    DetalleRecursoViewController *detalleRecursoView;
    
    //Vista de la leyenda
    UIButton *btnLeyenda;
    LeyendaMapa *_leyendaMapa;
    
    // ACTIVITY INDICATOR
    BMActivityIndicator *_activityIndicator;
    
    //Valor filtro distancia
    NSString *strDistancia;
    
    //Se controla si se debe mostrar el activity o no
    int activity;
    
    RecursoTuristico *_selectedCallout;
}

@property(nonatomic, strong) MKMapView *mapView;
@property(nonatomic, strong) AddressAnnotation *addAnnotation;
@property(nonatomic, strong) IBOutlet UISegmentedControl *btnTipoMapa;
@property(nonatomic, strong) DetalleRecursoViewController *detalleRecursoView;
@property(nonatomic, strong) NSMutableArray *arrCategorias;

//Valor filtro distancia
@property(nonatomic, strong) NSString *strDistancia;

+ (CGFloat)annotationPadding;
+ (CGFloat)calloutHeight;

//Métodos
-(void) pintarPoligono;
-(void) location;
-(IBAction) getLocation;
-(IBAction) setMap: (id) sender;

@end
