//
//  MapaDetalleViewController.m
//  iEuskadi
//
//  Created by Gonzalo Torres Ayastuy on 06/08/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "MapaDetalleViewController.h"
#import <QuartzCore/QuartzCore.h>
#import "traducirLiteral.h"

@implementation MapaDetalleViewController

@synthesize addAnnotation, mapView, gpsLat, gpsLong, strNombre, btnCallout, type;

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}


- (void)didReceiveMemoryWarning
{
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Release any cached data, images, etc that aren't in use.
}

-(IBAction)setMap:(id)sender {
    switch (((UISegmentedControl *) sender).selectedSegmentIndex) {
        case 0:
            mapView.mapType = MKMapTypeStandard;
            break;
        case 1:
            mapView.mapType = MKMapTypeSatellite;
            break;
        case 2:
            mapView.mapType = MKMapTypeHybrid;
            break;
        default:
            mapView.mapType = MKMapTypeStandard;
            break;
    }
}

#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    self.navigationItem.title = [traducirLiteral languageSelectedStringForKey:@"MAPA"];
    
    self.mapView.mapType = MKMapTypeStandard;
    [self.btnTipoMapa setTitle:[traducirLiteral languageSelectedStringForKey:@"MAPA"] forSegmentAtIndex:0];
    [self.btnTipoMapa setTitle:[traducirLiteral languageSelectedStringForKey:@"SATELITE"] forSegmentAtIndex:1];
    [self.btnTipoMapa setTitle:[traducirLiteral languageSelectedStringForKey:@"HIBRIDO"] forSegmentAtIndex:2];
    
    [self location];
}

-(void) location{
    //MKCoordinateRegion region;
    //region.center.latitude = [gpsLat doubleValue];
    
    float lat = [gpsLat floatValue];
    NSString *strLat = [NSString stringWithFormat:@"%.4f", lat];
    float lon = [gpsLong floatValue];
    NSString *strlong = [NSString stringWithFormat:@"%.4f", lon];
    float lonDelta = 0.00872;
    float latDelta = 0.00863;
    NSString *strLatDelta = [NSString stringWithFormat:@"%.4f", latDelta];
    NSString *strLonDelta = [NSString stringWithFormat:@"%.4f", lonDelta];
    /*region.center.latitude = [strLat floatValue];
     region.center.longitude = [strlong doubleValue];
     region.span.latitudeDelta = [strLatDelta floatValue];
     region.span.latitudeDelta = [strLonDelta floatValue];
     */
    
    
    CLLocationCoordinate2D location2D;
    location2D.latitude = [strLat floatValue];
    location2D.longitude = [strlong floatValue];
    
    addAnnotation = [[AddressAnnotation alloc] initWithCoordinate:location2D];
    addAnnotation.title = strNombre;
    //addAnnotation.subtitle = strProvincia;
    [self.mapView addAnnotation:addAnnotation];
    MKCoordinateSpan span = MKCoordinateSpanMake([strLatDelta floatValue], [strLonDelta floatValue]);
    MKCoordinateRegion region = MKCoordinateRegionMake(location2D, span);
    
    [self.mapView setRegion:region animated:TRUE];
    [self.mapView regionThatFits:region];
    self.mapView.delegate = self;
	/*lat = 0;
     lon = 0;
     lonDelta = 0;
     latDelta = 0;*/
}

- (MKAnnotationView *) mapView:(MKMapView *)mapView viewForAnnotation:(id <MKAnnotation>) annotation{
    MKAnnotationView *annView;UIImage *image = [[UIImage alloc] init];
    UIImage *flagImage = [[UIImage alloc] init];
    if (self.type == [NSNumber numberWithInt:1]){
        image = [UIImage imageNamed:@"iconCultura"];
        flagImage = [UIImage imageNamed:@"PinCultura.png"];
    }else if(self.type == [NSNumber numberWithInt:2]) {
        image = [UIImage imageNamed:@"iconTransporte"];
        flagImage = [UIImage imageNamed:@"PinTransporte.png"];
    }else if(self.type == [NSNumber numberWithInt:3]) {
        image = [UIImage imageNamed:@"iconDeportes"];
        flagImage = [UIImage imageNamed:@"PinDeportes.png"];
    }else if(self.type == [NSNumber numberWithInt:4]) {
        image = [UIImage imageNamed:@"iconComer"];
        flagImage = [UIImage imageNamed:@"PinComer.png"];
    }else if(self.type == [NSNumber numberWithInt:5]) {
        image = [UIImage imageNamed:@"iconDormir"];
        flagImage = [UIImage imageNamed:@"PinDormir.png"];
    }else if(self.type == [NSNumber numberWithInt:6]) {
        image = [UIImage imageNamed:@"iconExperiencias"];
        flagImage = [UIImage imageNamed:@"PinExperiencias.png"];
    }else if(self.type == [NSNumber numberWithInt:7]) {
        image = [UIImage imageNamed:@"iconPlayas"];
        flagImage = [UIImage imageNamed:@"PinPlayas.png"];
    }else if(self.type == [NSNumber numberWithInt:8]) {
        image = [UIImage imageNamed:@"iconInfo"];
        flagImage = [UIImage imageNamed:@"PinInfo.png"];
    }else if(self.type == [NSNumber numberWithInt:9]) {
        image = [UIImage imageNamed:@"iconReuniones"];
        flagImage = [UIImage imageNamed:@"PinReuniones.png"];
    }
    
    CGRect resizeRect;
    
    resizeRect.size = flagImage.size;
    CGSize maxSize = CGRectInset(self.view.bounds,
                                 [MapaDetalleViewController annotationPadding],
                                 [MapaDetalleViewController annotationPadding]).size;
    maxSize.height -= self.navigationController.navigationBar.frame.size.height + [MapaDetalleViewController calloutHeight];
    if (resizeRect.size.width > maxSize.width)
        resizeRect.size = CGSizeMake(maxSize.width, resizeRect.size.height / resizeRect.size.width * maxSize.width);
    if (resizeRect.size.height > maxSize.height)
        resizeRect.size = CGSizeMake(resizeRect.size.width / resizeRect.size.height * maxSize.height, maxSize.height);
    
    resizeRect.origin = (CGPoint){0.0f, 0.0f};
    UIGraphicsBeginImageContext(resizeRect.size);
    [flagImage drawInRect:resizeRect];
    UIImage *resizedImage = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    
    annView=[[MKAnnotationView alloc] initWithAnnotation:annotation reuseIdentifier:@"recurso"];
    annView.image = resizedImage;
    
    // Creating shadow path for better performance
    CGMutablePathRef path = CGPathCreateMutable();
    CGPathAddRect(path, NULL, annView.bounds);
    annView.layer.shadowPath = path;
    CGPathCloseSubpath(path);
    CGPathRelease(path);
    annView.layer.shadowOffset = CGSizeMake(2, 2);
    annView.layer.shadowRadius = 2.0f;
    annView.layer.shadowOpacity = 0.6;

    UIImageView *imgView = [[UIImageView alloc] initWithImage:image];
    imgView.frame = CGRectMake(0, 0, 30, 30);
    annView.leftCalloutAccessoryView = imgView;

    //annView.animatesDrop=NO;
    annView.canShowCallout = YES;
    annView.calloutOffset = CGPointMake(-5, 5);    return annView;
}


#pragma mark -

+ (CGFloat)annotationPadding;
{
    return 10.0f;
}
+ (CGFloat)calloutHeight;
{
    return 40.0f;
}

- (void)viewDidUnload
{
    [super viewDidUnload];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}


@end
