//
//  ListaRecursosViewController.m
//  iEuskadi
//
//  Created by Gonzalo Torres Ayastuy on 12/06/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "ListaRecursosViewController.h"

@implementation ListaRecursosViewController

@synthesize arrCategorias;
@synthesize detalleRecursoView, customCell;
@synthesize strDistancia;


- (void)viewDidLoad
{
    [super viewDidLoad];
    
    _activity = YES;
    _arrRecursos = [[NSMutableArray alloc] init];
    
//    vistaTableView.allowsSelection = YES;
//	vistaTableView.editing = NO;
    
    
    _locationManager = [[CLLocationManager alloc] init];
    _locationManager.delegate = self;
    _locationManager.distanceFilter = kCLDistanceFilterNone; // whenever we move
    _locationManager.desiredAccuracy = kCLLocationAccuracyHundredMeters; // 100 m
    didUpateLocation = 0;
    [_locationManager startUpdatingLocation];
    
    CLAuthorizationStatus authStatus = [CLLocationManager authorizationStatus];
    if(authStatus != kCLAuthorizationStatusAuthorized) {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Atención" message:@"No tiene permiso para acceder a la localización del dispositivo." delegate:self cancelButtonTitle:@"OK" otherButtonTitles:nil, nil];
        [alert show];
        [_locationManager stopUpdatingHeading];
        [_locationManager stopUpdatingLocation];
    }
}

-(void) viewWillAppear:(BOOL)animated{
    
    if (_activity == YES) {
        _activityIndicator = [[BMActivityIndicator alloc] initWithPoint:self.view.center withSquare:CGSizeMake(200, 60)];
        _activityIndicator.center = self.view.center;
        [self.view addSubview:_activityIndicator];
    }
    _activity = NO;
    
}

- (void)viewDidUnload
{
    [super viewDidUnload];
}


#pragma mark - Segues

- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender
{
    // Make sure your segue name in storyboard is the same as this line
    if ([[segue identifier] isEqualToString:@"vista_detalle"])
    {
        RecursoTuristico *recurso = [[RecursoTuristico alloc] init];
        recurso = [_arrRecursos objectAtIndex:[self.tableView indexPathForSelectedRow].row];
        
        DetalleRecursoViewController *vc = (DetalleRecursoViewController*)[segue destinationViewController];
        vc.recurso = recurso;
        // Refresca todo para que desmarque la celda seleccionada
        // [self.tableView reloadData];
    }
}


#pragma mark - Table view data source


- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return [_arrRecursos count];
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString *cellID = @"RecursoCustomCell";
    
	
	customCell = (RecursoCustomCell *)[tableView dequeueReusableCellWithIdentifier:cellID];
	if (customCell == nil) {
		NSArray *nibObjects = [[NSBundle mainBundle] loadNibNamed:@"RecursoCustomCell" owner:nil options:nil];
		for (id currentObject in nibObjects) {
			if ([currentObject isKindOfClass:[RecursoCustomCell class]]) {
				customCell = (RecursoCustomCell *)currentObject;
			}
		}
	}
    
    DTCustomColoredAccessory *accessory = [DTCustomColoredAccessory accessoryWithColor:[UIColor whiteColor]];
    accessory.highlightedColor = [UIColor blackColor];
    customCell.accessoryView =accessory;
    
    RecursoTuristico *recurso = [_arrRecursos objectAtIndex:indexPath.row];

    [customCell.lblTitle setText:recurso.title];
    NSString *distancia = [NSString stringWithFormat:@"%.3f", recurso.distance];
    distancia = [distancia stringByAppendingFormat:@" km."];
    [customCell.lblSubTitle setText:distancia];

    switch (recurso.type.intValue) {
        case 1:
            customCell.imageView.image = [UIImage imageNamed:@"iconCultura"];
            break;
        case 2:
            customCell.imageView.image = [UIImage imageNamed:@"iconTransporte"];
            break;
        case 3:
            customCell.imageView.image = [UIImage imageNamed:@"iconDeportes"];
            break;
        case 4:
            customCell.imageView.image = [UIImage imageNamed:@"iconComer"];
            break;
        case 5:
            customCell.imageView.image = [UIImage imageNamed:@"iconDormir"];
            break;
        case 6:
            customCell.imageView.image = [UIImage imageNamed:@"iconExperiencias"];
            break;
        case 7:
            customCell.imageView.image = [UIImage imageNamed:@"iconPlayas"];
            break;
        case 8:
            customCell.imageView.image = [UIImage imageNamed:@"iconInfo"];
            break;
        case 9:
            customCell.imageView.image = [UIImage imageNamed:@"iconReuniones"];
            break;
            
        default:
            break;
    }
    customCell.backgroundColor = [UIColor clearColor];
    return customCell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [self performSegueWithIdentifier:@"vista_detalle" sender:self];
}

#pragma mark - Location

- (void)locationManager:(CLLocationManager *)manager didUpdateToLocation:(CLLocation *)newLocation fromLocation:(CLLocation *)oldLocation
{
    didUpateLocation +=1;
    if (didUpateLocation == 1){
        _arrRecursos = [descargarRecursos descargarRecursosMapa:newLocation arrayCategorias:self.arrCategorias distance:strDistancia];
        [self.tableView reloadData];
        [_activityIndicator removeFromSuperview];
    }
    [_locationManager stopUpdatingLocation];
}

- (void)locationManager:(CLLocationManager *)manager didChangeAuthorizationStatus:(CLAuthorizationStatus)status {
    if(status != kCLAuthorizationStatusAuthorized){
        [_locationManager stopUpdatingHeading];
        [_locationManager stopUpdatingLocation];
        if ([[self.view subviews] containsObject:_activityIndicator]){
            [_activityIndicator removeFromSuperview];
        }
    }
}

@end
